/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.RateLimitChecker;
import org.kohsuke.github.RateLimitTarget;

class GitHubRateLimitChecker {
    @Nonnull
    private final RateLimitChecker core;
    @Nonnull
    private final RateLimitChecker search;
    @Nonnull
    private final RateLimitChecker graphql;
    @Nonnull
    private final RateLimitChecker integrationManifest;
    private static final Logger LOGGER = Logger.getLogger(GitHubRateLimitChecker.class.getName());

    GitHubRateLimitChecker() {
        this(RateLimitChecker.NONE, RateLimitChecker.NONE, RateLimitChecker.NONE, RateLimitChecker.NONE);
    }

    GitHubRateLimitChecker(@Nonnull RateLimitChecker core, @Nonnull RateLimitChecker search, @Nonnull RateLimitChecker graphql, @Nonnull RateLimitChecker integrationManifest) {
        this.core = Objects.requireNonNull(core);
        this.search = Objects.requireNonNull(search);
        this.graphql = Objects.requireNonNull(graphql);
        this.integrationManifest = Objects.requireNonNull(integrationManifest);
    }

    GitHubRateLimitChecker with(@Nonnull RateLimitChecker checker, @Nonnull RateLimitTarget rateLimitTarget) {
        return new GitHubRateLimitChecker(rateLimitTarget == RateLimitTarget.CORE ? checker : this.core, rateLimitTarget == RateLimitTarget.SEARCH ? checker : this.search, rateLimitTarget == RateLimitTarget.GRAPHQL ? checker : this.graphql, rateLimitTarget == RateLimitTarget.INTEGRATION_MANIFEST ? checker : this.integrationManifest);
    }

    void checkRateLimit(GitHubClient client, GitHubRequest request) throws IOException {
        RateLimitChecker guard = this.selectChecker(request.rateLimitTarget());
        if (guard == RateLimitChecker.NONE) {
            return;
        }
        GHRateLimit rateLimit = client.rateLimit(request.rateLimitTarget());
        GHRateLimit.Record rateLimitRecord = rateLimit.getRecord(request.rateLimitTarget());
        long waitCount = 0L;
        try {
            while (guard.checkRateLimit(rateLimitRecord, waitCount)) {
                ++waitCount;
                Thread.sleep(1000L);
                rateLimit = client.getRateLimit(request.rateLimitTarget());
                rateLimitRecord = rateLimit.getRecord(request.rateLimitTarget());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    @Nonnull
    private RateLimitChecker selectChecker(@Nonnull RateLimitTarget rateLimitTarget) {
        if (rateLimitTarget == RateLimitTarget.NONE) {
            return RateLimitChecker.NONE;
        }
        if (rateLimitTarget == RateLimitTarget.CORE) {
            return this.core;
        }
        if (rateLimitTarget == RateLimitTarget.SEARCH) {
            return this.search;
        }
        if (rateLimitTarget == RateLimitTarget.GRAPHQL) {
            return this.graphql;
        }
        if (rateLimitTarget == RateLimitTarget.INTEGRATION_MANIFEST) {
            return this.integrationManifest;
        }
        throw new IllegalArgumentException("Unknown rate limit target: " + rateLimitTarget.toString());
    }
}

