/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.StringUtils;

public final class MustacheUtils {
    private MustacheUtils() {
    }

    private static Map<String, String> envVars() {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        System.getenv().forEach((k, v) -> {
            if (!k.startsWith("JRELEASER_")) {
                vars.put("Env." + k, (String)v);
            }
        });
        return vars;
    }

    public static String applyTemplate(Reader reader, Map<String, Object> context, String templateName) {
        StringWriter input = new StringWriter();
        MyMustacheFactory mf = new MyMustacheFactory();
        Mustache mustache = mf.compile(reader, templateName);
        context.putAll(MustacheUtils.envVars());
        mustache.execute((Writer)input, context);
        input.flush();
        return input.toString();
    }

    public static String applyTemplate(Reader reader, Map<String, Object> context) {
        return MustacheUtils.applyTemplate(reader, context, UUID.randomUUID().toString()).trim();
    }

    public static String applyTemplate(String template, Map<String, Object> context, String templateName) {
        return MustacheUtils.applyTemplate(new StringReader(template), context, templateName);
    }

    public static String applyTemplate(String template, Map<String, Object> context) {
        return MustacheUtils.applyTemplate(new StringReader(template), context, UUID.randomUUID().toString()).trim();
    }

    public static void applyTemplates(Map<String, Object> props, Map<String, Object> templates) {
        for (Map.Entry<String, Object> e : templates.entrySet()) {
            String value = String.valueOf(e.getValue());
            if (value.contains("{{") && value.contains("}}")) {
                props.put(e.getKey(), MustacheUtils.applyTemplate(value, props));
                continue;
            }
            props.put(e.getKey(), value);
        }
    }

    public static String passThrough(String str) {
        return StringUtils.isNotBlank(str) ? "!!" + str + "!!" : str;
    }

    public static void applyFunctions(Map<String, Object> props) {
        ZonedDateTime now = (ZonedDateTime)props.get("__ZonedDateTime_now__");
        if (null == now) {
            now = ZonedDateTime.now();
        }
        props.put("f_now", new TimeFormatFunction(now));
        props.put("f_underscore", new UnderscoreFunction());
        props.put("f_dash", new DashFunction());
        props.put("f_slash", new SlashFunction());
        props.put("f_upper", new UpperFunction());
        props.put("f_lower", new LowerFunction());
        props.put("f_capitalize", new CapitalizeFunction());
        props.put("f_uncapitalize", new UncapitalizeFunction());
    }

    public static class UncapitalizeFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return StringUtils.uncapitalize(input);
        }
    }

    public static class CapitalizeFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return StringUtils.capitalize(input);
        }
    }

    public static class LowerFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.toLowerCase();
        }
    }

    public static class UpperFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.toUpperCase();
        }
    }

    public static class SlashFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.replace(".", "/").replace("-", "/").replace("+", "/");
        }
    }

    public static class DashFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.replace(".", "-").replace("_", "-").replace("+", "-");
        }
    }

    public static class UnderscoreFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.replace(".", "_").replace("-", "_").replace("+", "_");
        }
    }

    public static class TimeFormatFunction
    implements Function<String, String> {
        private final ZonedDateTime now;

        private TimeFormatFunction(ZonedDateTime now) {
            this.now = now;
        }

        @Override
        public String apply(String input) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(input);
            return this.now.format(formatter);
        }
    }

    private static class MyMustacheFactory
    extends DefaultMustacheFactory {
        private MyMustacheFactory() {
        }

        public void encode(String value, Writer writer) {
            if (value.startsWith("!!") && value.endsWith("!!")) {
                try {
                    writer.write(value.substring(2, value.length() - 2));
                }
                catch (IOException e) {
                    throw new MustacheException(RB.$("ERROR_mustache_write_value", value), (Throwable)e);
                }
            } else {
                super.encode(value, writer);
            }
        }
    }
}

