/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Scoop;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class ScoopPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Scoop> {
    public ScoopPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("scoopBucketRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Scoop)this.packager).getBucket().getOwner(), ((Scoop)this.packager).getBucket().getResolvedName()));
        props.put("scoopBucketRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Scoop)this.packager).getBucket().getOwner(), ((Scoop)this.packager).getBucket().getResolvedName()));
        props.put("scoopPackageName", ((Scoop)this.packager).getPackageName());
        props.put("scoopCheckverUrl", this.resolveCheckverUrl(props));
        props.put("scoopAutoupdateUrl", this.resolveAutoupdateUrl(props, distribution));
        String autoupdateExtractDir = (String)props.get("distributionArtifactFileName");
        autoupdateExtractDir = autoupdateExtractDir.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.put("scoopAutoupdateExtractDir", autoupdateExtractDir);
    }

    private Object resolveCheckverUrl(Map<String, Object> props) {
        if (!((Scoop)this.getPackager()).getCheckverUrl().contains("{{")) {
            return ((Scoop)this.getPackager()).getCheckverUrl();
        }
        return Templates.resolveTemplate((String)((Scoop)this.getPackager()).getCheckverUrl(), props);
    }

    private Object resolveAutoupdateUrl(Map<String, Object> props, Distribution distribution) {
        String url = ((Scoop)this.getPackager()).getAutoupdateUrl();
        if (StringUtils.isBlank((String)url)) {
            Artifact artifact = (Artifact)props.get("distributionArtifact");
            url = Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)"scoop", (Distribution)distribution, (Artifact)artifact);
        }
        String artifactFile = (String)props.get("distributionArtifactFile");
        String projectVersion = (String)props.get("projectVersion");
        String tagName = (String)props.get("tagName");
        url = url.replace(projectVersion, "$version");
        artifactFile = artifactFile.replace(projectVersion, "$version");
        tagName = tagName.replace(projectVersion, "$version");
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(props);
        copy.put("projectVersion", "$version");
        copy.put("projectEffectiveVersion", "$version");
        copy.put("tagName", tagName);
        copy.put("artifactFile", artifactFile);
        return Templates.resolveTemplate((String)url, copy);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "manifest.json".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("bucket").resolve(((Scoop)this.packager).getPackageName().concat(".json")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

