/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Github;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Macports
extends AbstractRepositoryPackager<Macports> {
    public static final String TYPE = "macports";
    public static final String SKIP_MACPORTS = "skipMacports";
    public static final String APP_NAME = "appName";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final List<String> categories = new ArrayList<String>();
    private final List<String> maintainers = new ArrayList<String>();
    private final MacportsRepository repository = new MacportsRepository();
    private String packageName;
    private Integer revision;

    public Macports() {
        super(TYPE);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.repository.freeze();
    }

    @Override
    public void merge(Macports macports) {
        this.freezeCheck();
        super.merge(macports);
        this.packageName = this.merge(this.packageName, macports.packageName);
        this.revision = this.merge(this.revision, macports.revision);
        this.setRepository(macports.repository);
        this.setCategories(this.merge(this.categories, macports.categories));
        this.setMaintainers(this.merge(this.maintainers, macports.maintainers));
    }

    public List<String> getResolvedMaintainers(JReleaserContext context) {
        String maintainer;
        Github github;
        if (this.maintainers.isEmpty() && (github = context.getModel().getRelease().getGithub()) != null && StringUtils.isNotBlank((String)(maintainer = github.getResolvedUsername()))) {
            this.maintainers.add("@" + maintainer);
        }
        return this.maintainers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.freezeCheck();
        this.packageName = packageName;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.freezeCheck();
        this.revision = revision;
    }

    public MacportsRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MacportsRepository repository) {
        this.repository.merge(repository);
    }

    public List<String> getCategories() {
        return this.freezeWrap(this.categories);
    }

    public void setCategories(List<String> categories) {
        this.freezeCheck();
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<String> getMaintainers() {
        return this.freezeWrap(this.maintainers);
    }

    public void setMaintainers(List<String> maintainers) {
        this.freezeCheck();
        this.maintainers.clear();
        this.maintainers.addAll(maintainers);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("revision", this.revision);
        props.put("categories", this.categories);
        props.put("maintainers", this.maintainers);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) && PlatformUtils.isIntel((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_MACPORTS));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.newSet((Object[])new String[]{FileType.DMG.extension()}));
    }

    public static class MacportsRepository
    extends AbstractRepositoryTap<MacportsRepository> {
        public MacportsRepository() {
            super(Macports.TYPE, Macports.TYPE);
        }
    }
}

