/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.ScpDownloader;
import org.jreleaser.model.validation.SshValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ScpDownloaderValidator
extends Validator {
    public static void validateScpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("scp");
        Map<String, ScpDownloader> scp = context.getModel().getDownload().getScp();
        for (Map.Entry<String, ScpDownloader> e : scp.entrySet()) {
            e.getValue().setName(e.getKey());
            ScpDownloaderValidator.validateScpDownloader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateScpDownloader(JReleaserContext context, JReleaserContext.Mode mode, ScpDownloader scp, Errors errors) {
        context.getLogger().debug("scp.{}", new Object[]{scp.getName()});
        if (!scp.isActiveSet()) {
            scp.setActive(Active.ALWAYS);
        }
        if (!scp.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        SshValidator.validateSsh(context, scp, scp.getName(), "SCP", scp.getType(), errors);
        ScpDownloaderValidator.validateTimeout(scp);
        if (scp.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"scp." + scp.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : scp.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"scp." + scp.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

