/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.http;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.HttpDownloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.downloader.spi.DownloadException;
import org.jreleaser.sdk.commons.AbstractArtifactDownloader;
import org.jreleaser.util.StringUtils;

public class HttpArtifactDownloader
extends AbstractArtifactDownloader<HttpDownloader> {
    private HttpDownloader downloader;

    public HttpArtifactDownloader(JReleaserContext context) {
        super(context);
    }

    public HttpDownloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(HttpDownloader downloader) {
        this.downloader = downloader;
    }

    public String getType() {
        return "http";
    }

    public void download(String name) throws DownloadException {
        for (Downloader.Asset asset : this.downloader.getAssets()) {
            this.downloadAsset(name, asset);
        }
    }

    private void downloadAsset(String name, Downloader.Asset asset) throws DownloadException {
        String input = asset.getResolvedInput(this.context, (Downloader)this.downloader);
        String output = asset.getResolvedOutput(this.context, (Downloader)this.downloader, Paths.get(input, new String[0]).getFileName().toString());
        if (StringUtils.isBlank((String)output)) {
            output = Paths.get(input, new String[0]).getFileName().toString();
        }
        Path outputPath = this.context.getDownloadDirectory().resolve(name).resolve(output);
        this.context.getLogger().info("{} -> {}", new Object[]{input, this.context.relativizeToBasedir(outputPath)});
        try {
            FileUtils.copyURLToFile((URL)new URL(input), (File)outputPath.toFile(), (int)(this.downloader.getConnectTimeout() * 1000), (int)(this.downloader.getReadTimeout() * 1000));
        }
        catch (IOException e) {
            throw new DownloadException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{input}), (Throwable)e);
        }
        this.unpack(asset.getUnpack(), outputPath);
    }
}

