/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.ExtendedPGPSecretKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPSecretKeyDecryptorWithAAD;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedPGPKeyData {
    private final List<PGPExtendedKeyHeader> headerList;
    private final SExpression keyExpression;

    public OpenedPGPKeyData(List<PGPExtendedKeyHeader> list, SExpression sExpression) {
        this.headerList = Collections.unmodifiableList(list);
        this.keyExpression = sExpression;
    }

    public List<PGPExtendedKeyHeader> getHeaderList() {
        return this.headerList;
    }

    public SExpression getKeyExpression() {
        return this.keyExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyType() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtendedPGPSecretKey getKeyData(PGPPublicKey pGPPublicKey, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, int n) throws PGPException, IOException {
        Object object11;
        Object object2;
        Object object3;
        String string = this.keyExpression.getString(0);
        ArrayList<PGPExtendedKeyAttribute> arrayList = new ArrayList<PGPExtendedKeyAttribute>();
        if (!string.equals("shadowed-private-key") && !string.equals("protected-private-key") && !string.equals("private-key")) return null;
        SExpression sExpression = this.getKeyExpression().getExpression(1);
        if (sExpression.hasLabel("ecc")) {
            Object object4;
            Object object5;
            Object object6;
            PGPPublicKey pGPPublicKey2 = this.getECCPublicKey(sExpression, keyFingerPrintCalculator);
            if (pGPPublicKey != null && pGPPublicKey2 != null) {
                object6 = (ECPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                object5 = (ECPublicBCPGKey)pGPPublicKey2.getPublicKeyPacket().getKey();
                if (!((ECPublicBCPGKey)object6).getCurveOID().equals((ASN1Primitive)((ECPublicBCPGKey)object5).getCurveOID()) || !((ECPublicBCPGKey)object6).getEncodedPoint().equals(((ECPublicBCPGKey)object5).getEncodedPoint())) {
                    throw new PGPException("passed in public key does not match secret key");
                }
            }
            pGPPublicKey = pGPPublicKey2;
            if (string.equals("shadowed-private-key")) {
                object6 = null;
            } else if (string.equals("protected-private-key")) {
                object5 = sExpression.getExpressionWithLabel("protected");
                if (object5 == null) {
                    throw new IllegalArgumentException(string + " does not have protected block");
                }
                object4 = ((SExpression)object5).getString(1);
                if (((String)object4).indexOf("aes") < 0) throw new PGPException("unsupported protection type");
                object6 = this.unwrapECCSecretKey((String)object4, pGPPublicKey, n, sExpression, (SExpression)object5, pBEProtectionRemoverFactory);
            } else {
                object4 = sExpression.getExpressionWithLabel("curve");
                if (object4 == null) {
                    throw new IllegalStateException("no curve expression");
                }
                object5 = ((SExpression)object4).getString(1);
                object6 = new UnwrapResult(sExpression, null, null, object5);
            }
            object5 = new BigInteger(1, ((UnwrapResult)object6).expression.getExpressionWithLabelOrFail("d").getBytes(1));
            if (((UnwrapResult)object6).metaData == null) {
                throw new IllegalStateException("expecting unwrap result to have meta data defining the curve");
            }
            object4 = ((UnwrapResult)object6).metaData.toString();
            BCPGObject bCPGObject = ((String)object4).startsWith("NIST") || ((String)object4).startsWith("brain") ? new ECSecretBCPGKey((BigInteger)object5) : new EdSecretBCPGKey((BigInteger)object5);
            return new ExtendedPGPSecretKey(this.headerList, arrayList, new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, ((UnwrapResult)object6).s2K, ((UnwrapResult)object6).iv, bCPGObject.getEncoded()), pGPPublicKey);
        }
        if (sExpression.hasLabel("elg")) {
            Object object7;
            Object object8;
            PGPPublicKey pGPPublicKey3 = this.getDSAPublicKey(sExpression, keyFingerPrintCalculator);
            if (pGPPublicKey != null && pGPPublicKey3 != null) {
                object8 = (ElGamalPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                object7 = (ElGamalPublicBCPGKey)pGPPublicKey3.getPublicKeyPacket().getKey();
                if (!(((ElGamalPublicBCPGKey)object8).getP().equals(((ElGamalPublicBCPGKey)object7).getP()) && ((ElGamalPublicBCPGKey)object8).getG().equals(((ElGamalPublicBCPGKey)object7).getG()) && ((ElGamalPublicBCPGKey)object8).getY().equals(((ElGamalPublicBCPGKey)object7).getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
            }
            pGPPublicKey = pGPPublicKey3;
            if (string.equals("shadowed-private-key")) {
                object8 = null;
            } else {
                if (string.equals("protected-private-key")) {
                    object7 = sExpression.getExpressionWithLabel("protected");
                    if (object7 == null) {
                        throw new IllegalArgumentException(string + " does not have protected block");
                    }
                    String string2 = ((SExpression)object7).getString(1);
                    if (string2.indexOf("aes") < 0) throw new PGPException("unsupported protection type");
                    throw new IllegalStateException("no decryption support for protected elgamal keys");
                }
                object8 = new UnwrapResult(sExpression, null, null);
            }
            object7 = BigIntegers.fromUnsignedByteArray((byte[])((UnwrapResult)object8).expression.getExpressionWithLabelOrFail("x").getBytes(1));
            if (!sExpression.hasLabel("elg")) return new ExtendedPGPSecretKey(this.headerList, arrayList, new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, ((UnwrapResult)object8).s2K, ((UnwrapResult)object8).iv, new DSASecretBCPGKey((BigInteger)object7).getEncoded()), pGPPublicKey);
            return new ExtendedPGPSecretKey(this.headerList, arrayList, new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, ((UnwrapResult)object8).s2K, ((UnwrapResult)object8).iv, new ElGamalSecretBCPGKey((BigInteger)object7).getEncoded()), pGPPublicKey);
        }
        if (sExpression.hasLabel("dsa")) {
            Object object9;
            Object object10;
            PGPPublicKey pGPPublicKey4 = this.getDSAPublicKey(sExpression, keyFingerPrintCalculator);
            if (pGPPublicKey != null && pGPPublicKey4 != null) {
                object10 = (DSAPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                object9 = (DSAPublicBCPGKey)pGPPublicKey4.getPublicKeyPacket().getKey();
                if (!(((DSAPublicBCPGKey)object10).getP().equals(((DSAPublicBCPGKey)object9).getP()) && ((DSAPublicBCPGKey)object10).getQ().equals(((DSAPublicBCPGKey)object9).getQ()) && ((DSAPublicBCPGKey)object10).getG().equals(((DSAPublicBCPGKey)object9).getG()) && ((DSAPublicBCPGKey)object10).getY().equals(((DSAPublicBCPGKey)object9).getY()))) {
                    throw new PGPException("passed in public key does not match secret key");
                }
            }
            pGPPublicKey = pGPPublicKey4;
            if (string.equals("shadowed-private-key")) {
                object10 = null;
            } else if (string.equals("protected-private-key")) {
                object9 = sExpression.getExpressionWithLabel("protected");
                if (object9 == null) {
                    throw new IllegalArgumentException(string + " does not have protected block");
                }
                String string3 = ((SExpression)object9).getString(1);
                if (string3.indexOf("aes") < 0) throw new PGPException("unsupported protection type");
                object10 = this.unwrapDSASecretKey(string3, pGPPublicKey, n, sExpression, (SExpression)object9, pBEProtectionRemoverFactory);
            } else {
                object10 = new UnwrapResult(sExpression, null, null);
            }
            object9 = BigIntegers.fromUnsignedByteArray((byte[])((UnwrapResult)object10).expression.getExpressionWithLabelOrFail("x").getBytes(1));
            return new ExtendedPGPSecretKey(this.headerList, arrayList, new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, ((UnwrapResult)object10).s2K, ((UnwrapResult)object10).iv, new DSASecretBCPGKey((BigInteger)object9).getEncoded()), pGPPublicKey);
        }
        if (!sExpression.hasLabel("rsa")) return null;
        PGPPublicKey pGPPublicKey5 = this.getRSAPublicKey(sExpression, keyFingerPrintCalculator);
        if (pGPPublicKey != null && pGPPublicKey5 != null) {
            object3 = (RSAPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
            object2 = (RSAPublicBCPGKey)pGPPublicKey5.getPublicKeyPacket().getKey();
            if (!((RSAPublicBCPGKey)object3).getModulus().equals(((RSAPublicBCPGKey)object2).getModulus()) || !((RSAPublicBCPGKey)object3).getPublicExponent().equals(((RSAPublicBCPGKey)object2).getPublicExponent())) {
                throw new PGPException("passed in public key does not match secret key");
            }
        }
        pGPPublicKey = pGPPublicKey5;
        if (string.equals("shadowed-private-key")) {
            object3 = null;
        } else if (string.equals("protected-private-key")) {
            object2 = sExpression.getExpressionWithLabel("protected");
            if (object2 == null) {
                throw new IllegalArgumentException(string + " does not have protected block");
            }
            object11 = ((SExpression)object2).getString(1);
            if (((String)object11).indexOf("aes") < 0) throw new PGPException("unsupported protection type");
            object3 = this.unwrapRSASecretKey((String)object11, pGPPublicKey, n, sExpression, (SExpression)object2, pBEProtectionRemoverFactory);
        } else {
            object3 = new UnwrapResult(sExpression, null, null);
        }
        for (Object object11 : sExpression.filterOut("rsa", "e", "n", "d", "p", "q", "u", "protected").getValues()) {
            if (object11 instanceof SExpression) {
                arrayList.add(((SExpression)object11).toAttribute());
                continue;
            }
            arrayList.add(PGPExtendedKeyAttribute.builder().addAttribute(object11).build());
        }
        if (object3 == null) {
            return new ExtendedPGPSecretKey(this.headerList, arrayList, null, pGPPublicKey);
        }
        object2 = BigIntegers.fromUnsignedByteArray((byte[])((UnwrapResult)object3).expression.getExpressionWithLabelOrFail("d").getBytes(1));
        object11 = BigIntegers.fromUnsignedByteArray((byte[])((UnwrapResult)object3).expression.getExpressionWithLabelOrFail("p").getBytes(1));
        BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])((UnwrapResult)object3).expression.getExpressionWithLabelOrFail("q").getBytes(1));
        return new ExtendedPGPSecretKey(this.headerList, arrayList, new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, ((UnwrapResult)object3).s2K, ((UnwrapResult)object3).iv, new RSASecretBCPGKey((BigInteger)object2, (BigInteger)object11, bigInteger).getEncoded()), pGPPublicKey);
    }

    private UnwrapResult unwrapDSASecretKey(String string, PGPPublicKey pGPPublicKey, int n, SExpression sExpression, SExpression sExpression2, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws PGPException, IOException {
        if (string.equals("openpgp-s2k3-sha1-aes-cbc")) {
            throw new IllegalArgumentException("openpgp-s2k3-sha1-aes-cbc not supported on newer key type");
        }
        if (string.equals("openpgp-s2k3-ocb-aes")) {
            SExpression.Builder builder = SExpression.builder().addValue("dsa");
            this.addPublicKey(pGPPublicKey, builder);
            builder.addContent(sExpression.filterOut("dsa", "p", "q", "g", "y", "protected"));
            byte[] byArray = builder.build().toCanonicalForm();
            SExpression sExpression3 = sExpression2.getExpression(2);
            SExpression sExpression4 = sExpression3.getExpression(0);
            S2K s2K = new S2K(PGPUtil.getDigestIDForName(sExpression4.getString(0)), sExpression4.getBytes(1), sExpression4.getInt(2));
            byte[] byArray2 = sExpression3.getBytes(1);
            PBESecretKeyDecryptor pBESecretKeyDecryptor = pBEProtectionRemoverFactory.createDecryptor("ocb");
            byte[] byArray3 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] byArray4 = sExpression2.getBytes(3);
            return new UnwrapResult(SExpression.parse(((PGPSecretKeyDecryptorWithAAD)pBESecretKeyDecryptor).recoverKeyData(7, byArray3, byArray2, byArray, byArray4, 0, byArray4.length), n).getExpression(0), s2K, Arrays.clone((byte[])byArray2));
        }
        throw new PGPException("unhandled protection type " + string);
    }

    private UnwrapResult unwrapECCSecretKey(String string, PGPPublicKey pGPPublicKey, int n, SExpression sExpression, SExpression sExpression2, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws PGPException, IOException {
        if (string.equals("openpgp-s2k3-sha1-aes-cbc")) {
            throw new IllegalArgumentException("openpgp-s2k3-sha1-aes-cbc not supported on newer key type");
        }
        if (string.equals("openpgp-s2k3-ocb-aes")) {
            SExpression.Builder builder = SExpression.builder().addValue("ecc");
            builder.addContent(sExpression.filterIn("curve", "flags"));
            this.addPublicKey(pGPPublicKey, builder);
            builder.addContent(sExpression.filterOut("ecc", "flags", "curve", "q", "protected"));
            byte[] byArray = builder.build().toCanonicalForm();
            SExpression sExpression3 = sExpression.getExpressionWithLabel("curve");
            if (sExpression3 == null) {
                throw new IllegalStateException("no curve expression");
            }
            String string2 = sExpression3.getString(1);
            SExpression sExpression4 = sExpression2.getExpression(2);
            SExpression sExpression5 = sExpression4.getExpression(0);
            S2K s2K = new S2K(PGPUtil.getDigestIDForName(sExpression5.getString(0)), sExpression5.getBytes(1), sExpression5.getInt(2));
            byte[] byArray2 = sExpression4.getBytes(1);
            PBESecretKeyDecryptor pBESecretKeyDecryptor = pBEProtectionRemoverFactory.createDecryptor("ocb");
            byte[] byArray3 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] byArray4 = sExpression2.getBytes(3);
            return new UnwrapResult(SExpression.parse(((PGPSecretKeyDecryptorWithAAD)pBESecretKeyDecryptor).recoverKeyData(7, byArray3, byArray2, byArray, byArray4, 0, byArray4.length), n).getExpression(0), s2K, Arrays.clone((byte[])byArray2), string2);
        }
        throw new PGPException("unhandled protection type " + string);
    }

    private PGPPublicKey getECCPublicKey(SExpression sExpression, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        Object object;
        SExpression sExpression2;
        Object object22;
        byte[] byArray = null;
        String string = null;
        for (Object object22 : sExpression.getValues()) {
            if (!(object22 instanceof SExpression)) continue;
            sExpression2 = (SExpression)object22;
            if (sExpression2.hasLabel("curve")) {
                string = sExpression2.getString(1);
                continue;
            }
            if (!sExpression2.hasLabel("q")) continue;
            byArray = sExpression2.getBytes(1);
        }
        if (string == null || byArray == null) {
            return null;
        }
        if (string.startsWith("Curve")) {
            string = Strings.toLowerCase((String)string);
        } else if (string.startsWith("NIST")) {
            string = string.substring("NIST".length()).trim();
        }
        if (Strings.toLowerCase((String)string).equals("ed25519")) {
            object22 = new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed25519, new BigInteger(1, byArray));
            object = new PublicKeyPacket(22, new Date(), (BCPGKey)object22);
        } else if (Strings.toLowerCase((String)string).equals("ed448")) {
            object22 = new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed448, new BigInteger(1, byArray));
            object = new PublicKeyPacket(22, new Date(), (BCPGKey)object22);
        } else {
            object22 = ECNamedCurveTable.getOID((String)string);
            sExpression2 = CustomNamedCurves.getByNameLazy((String)string);
            if (sExpression2 == null) {
                sExpression2 = TeleTrusTNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)object22);
            }
            if (sExpression2 == null) {
                throw new IllegalStateException("unable to resolve parameters for " + string);
            }
            ECPoint eCPoint = sExpression2.getCurve().decodePoint(byArray);
            ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey((ASN1ObjectIdentifier)object22, eCPoint);
            object = new PublicKeyPacket(19, new Date(), eCDSAPublicBCPGKey);
        }
        return new PGPPublicKey((PublicKeyPacket)object, keyFingerPrintCalculator);
    }

    private PGPPublicKey getDSAPublicKey(SExpression sExpression, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        for (Object object : sExpression.getValues()) {
            if (!(object instanceof SExpression)) continue;
            SExpression sExpression2 = (SExpression)object;
            if (sExpression2.hasLabel("p")) {
                bigInteger = BigIntegers.fromUnsignedByteArray((byte[])sExpression2.getBytes(1));
                continue;
            }
            if (sExpression2.hasLabel("q")) {
                bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])sExpression2.getBytes(1));
                continue;
            }
            if (sExpression2.hasLabel("g")) {
                bigInteger3 = BigIntegers.fromUnsignedByteArray((byte[])sExpression2.getBytes(1));
                continue;
            }
            if (!sExpression2.hasLabel("y")) continue;
            bigInteger4 = BigIntegers.fromUnsignedByteArray((byte[])sExpression2.getBytes(1));
        }
        if (bigInteger == null || !sExpression.hasLabel("elg") && bigInteger2 == null || bigInteger3 == null || bigInteger4 == null) {
            return null;
        }
        PublicKeyPacket publicKeyPacket = sExpression.hasLabel("elg") ? new PublicKeyPacket(20, new Date(), new ElGamalPublicBCPGKey(bigInteger, bigInteger3, bigInteger4)) : new PublicKeyPacket(17, new Date(), new DSAPublicBCPGKey(bigInteger, bigInteger2, bigInteger3, bigInteger4));
        return new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator);
    }

    private UnwrapResult unwrapRSASecretKey(String string, PGPPublicKey pGPPublicKey, int n, SExpression sExpression, SExpression sExpression2, PBEProtectionRemoverFactory pBEProtectionRemoverFactory) throws PGPException, IOException {
        if (string.equals("openpgp-s2k3-sha1-aes-cbc")) {
            throw new IllegalArgumentException("openpgp-s2k3-sha1-aes-cbc not supported on newer key type");
        }
        if (string.equals("openpgp-s2k3-ocb-aes")) {
            SExpression.Builder builder = SExpression.builder().addValue("rsa");
            this.addPublicKey(pGPPublicKey, builder);
            builder.addContent(sExpression.filterOut("rsa", "e", "n", "protected"));
            byte[] byArray = builder.build().toCanonicalForm();
            SExpression sExpression3 = sExpression2.getExpression(2);
            SExpression sExpression4 = sExpression3.getExpression(0);
            S2K s2K = new S2K(PGPUtil.getDigestIDForName(sExpression4.getString(0)), sExpression4.getBytes(1), sExpression4.getInt(2));
            byte[] byArray2 = sExpression3.getBytes(1);
            PBESecretKeyDecryptor pBESecretKeyDecryptor = pBEProtectionRemoverFactory.createDecryptor("ocb");
            byte[] byArray3 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] byArray4 = sExpression2.getBytes(3);
            return new UnwrapResult(SExpression.parse(((PGPSecretKeyDecryptorWithAAD)pBESecretKeyDecryptor).recoverKeyData(7, byArray3, byArray2, byArray, byArray4, 0, byArray4.length), n).getExpression(0), s2K, Arrays.clone((byte[])byArray2));
        }
        throw new PGPException("unhandled protection type " + string);
    }

    private PGPPublicKey getRSAPublicKey(SExpression sExpression, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        for (Object object : sExpression.getValues()) {
            if (!(object instanceof SExpression)) continue;
            SExpression sExpression2 = (SExpression)object;
            if (sExpression2.hasLabel("e")) {
                bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])sExpression2.getBytes(1));
                continue;
            }
            if (!sExpression2.hasLabel("n")) continue;
            bigInteger = BigIntegers.fromUnsignedByteArray((byte[])sExpression2.getBytes(1));
        }
        if (bigInteger == null || bigInteger2 == null) {
            return null;
        }
        PublicKeyPacket publicKeyPacket = new PublicKeyPacket(1, new Date(), new RSAPublicBCPGKey(bigInteger, bigInteger2));
        return new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator);
    }

    private SExpression.Builder addPublicKey(PGPPublicKey pGPPublicKey, SExpression.Builder builder) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    return builder.addValue(SExpression.builder().addValue("p").addValue(dSAPublicBCPGKey.getP().toByteArray()).build()).addValue(SExpression.builder().addValue("q").addValue(dSAPublicBCPGKey.getQ().toByteArray()).build()).addValue(SExpression.builder().addValue("g").addValue(dSAPublicBCPGKey.getG().toByteArray()).build()).addValue(SExpression.builder().addValue("y").addValue(dSAPublicBCPGKey.getY().toByteArray()).build());
                }
                case 18: {
                    BCPGKey bCPGKey = publicKeyPacket.getKey();
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)eCDHPublicBCPGKey.getEncodedPoint());
                        if (byArray.length < 1 || 64 != byArray[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        throw new IllegalStateException("not implemented");
                    }
                    throw new IllegalStateException("not implemented");
                }
                case 19: {
                    ECDSAPublicBCPGKey eCDSAPublicBCPGKey = (ECDSAPublicBCPGKey)publicKeyPacket.getKey();
                    byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)eCDSAPublicBCPGKey.getEncodedPoint());
                    return builder.addValue(SExpression.builder().addValue("q").addValue(byArray).build());
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)edDSAPublicBCPGKey.getEncodedPoint());
                    if (byArray.length < 1 || 64 != byArray[0]) {
                        throw new IllegalArgumentException("Invalid Ed25519 public key");
                    }
                    return builder.addValue(SExpression.builder().addValue("q").addValue(byArray).build());
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    throw new IllegalStateException("not implemented");
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    return builder.addValue(SExpression.builder().addValue("n").addValue(rSAPublicBCPGKey.getModulus().toByteArray()).build()).addValue(SExpression.builder().addValue("e").addValue(rSAPublicBCPGKey.getPublicExponent().toByteArray()).build());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ArrayList<PGPExtendedKeyHeader> headerList = new ArrayList();
        private SExpression keyExpression;

        public Builder setHeaderList(ArrayList<PGPExtendedKeyHeader> arrayList) {
            this.headerList = arrayList;
            return this;
        }

        public Builder setKeyExpression(SExpression sExpression) {
            this.keyExpression = sExpression;
            return this;
        }

        public OpenedPGPKeyData build() {
            return new OpenedPGPKeyData(this.headerList, this.keyExpression);
        }

        public void add(PGPExtendedKeyHeader pGPExtendedKeyHeader) {
            this.headerList.add(pGPExtendedKeyHeader);
        }
    }

    private static class UnwrapResult {
        final SExpression expression;
        final S2K s2K;
        final byte[] iv;
        final Object metaData;

        public UnwrapResult(SExpression sExpression, S2K s2K, byte[] byArray) {
            this.expression = sExpression;
            this.s2K = s2K;
            this.iv = byArray;
            this.metaData = null;
        }

        public UnwrapResult(SExpression sExpression, S2K s2K, byte[] byArray, Object object) {
            this.expression = sExpression;
            this.s2K = s2K;
            this.iv = byArray;
            this.metaData = object;
        }
    }
}

