/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.opencollective;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Feign;
import feign.Request;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.opencollective.OpenCollectiveException;
import org.jreleaser.sdk.opencollective.api.Envelope;
import org.jreleaser.sdk.opencollective.api.Mutation;
import org.jreleaser.sdk.opencollective.api.OpenCollectiveAPI;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class OpenCollectiveSdk {
    private static final String MUTATION_CREATE_UPDATE = "mutation (\n  $update: UpdateCreateInput!\n) {\n  createUpdate(update: $update) {\n    id\n  }\n}";
    private static final String MUTATION_PUBLISH_UPDATE = "mutation (\n  $id: String!\n  $audience: UpdateAudience\n) {\n  publishUpdate(id: $id, notificationAudience: $audience) {\n    id\n  }\n}";
    private final JReleaserLogger logger;
    private final OpenCollectiveAPI api;
    private final boolean dryrun;

    private OpenCollectiveSdk(JReleaserLogger logger, String host, String token, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.dryrun = dryrun;
        this.api = (OpenCollectiveAPI)Feign.builder().encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> {
            template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()});
            template.header("Personal-Token", new String[]{token});
        }).errorDecoder((methodKey, response) -> new RestAPIException(response.request(), response.status(), response.reason(), response.headers())).options(new Request.Options((long)connectTimeout, TimeUnit.SECONDS, (long)readTimeout, TimeUnit.SECONDS, true)).target(OpenCollectiveAPI.class, host);
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void postUpdate(String slug, String title, String body) throws OpenCollectiveException {
        this.wrap(() -> {
            Mutation mutation = new Mutation();
            mutation.setQuery(MUTATION_CREATE_UPDATE);
            mutation.setVariables((Map<Object, Object>)CollectionUtils.map().e((Object)"update", (Object)CollectionUtils.map().e((Object)"title", (Object)title).e((Object)"html", (Object)body).e((Object)"account", (Object)CollectionUtils.map().e((Object)"slug", (Object)slug))));
            Envelope envelope = this.api.createUpdate(mutation);
            mutation.setQuery(MUTATION_PUBLISH_UPDATE);
            mutation.setVariables((Map<Object, Object>)CollectionUtils.map().e((Object)"id", (Object)envelope.getData().getCreateUpdate().getId()).e((Object)"audience", (Object)"ALL"));
            this.api.publishUpdate(mutation);
        });
    }

    private void wrap(OpenCollectiveOperation op) throws OpenCollectiveException {
        try {
            if (!this.dryrun) {
                op.run();
            }
        }
        catch (RestAPIException e) {
            this.logger.trace((Throwable)e);
            throw new OpenCollectiveException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"openCollective"}), e);
        }
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    @FunctionalInterface
    public static interface OpenCollectiveOperation {
        public void run() throws OpenCollectiveException;
    }

    public static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private String token;
        private String host;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder token(String token) {
            this.token = StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank").trim();
            return this;
        }

        public Builder host(String host) {
            this.host = StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.host, (String)"'host' must not be blank");
            StringUtils.requireNonBlank((String)this.token, (String)"'token' must not be blank");
        }

        public OpenCollectiveSdk build() {
            this.validate();
            return new OpenCollectiveSdk(this.logger, this.host, this.token, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

