/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.signing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.signing.Signing;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.util.StringUtils;

public final class Signing
extends AbstractActivatable<Signing>
implements Domain {
    private static final long serialVersionUID = -7440879442726925285L;
    private final Command command = new Command();
    private final Cosign cosign = new Cosign();
    private Boolean armored;
    private Boolean verify;
    private String publicKey;
    private String secretKey;
    private String passphrase;
    private Signing.Mode mode;
    private Boolean artifacts;
    private Boolean files;
    private Boolean checksums;
    private Boolean catalogs;
    @JsonIgnore
    private final org.jreleaser.model.api.signing.Signing immutable = new org.jreleaser.model.api.signing.Signing(){
        private static final long serialVersionUID = -3565614952776622685L;

        public boolean isArmored() {
            return Signing.this.isArmored();
        }

        public boolean isVerify() {
            return Signing.this.isVerify();
        }

        public String getPublicKey() {
            return Signing.this.publicKey;
        }

        public String getSecretKey() {
            return Signing.this.secretKey;
        }

        public String getPassphrase() {
            return Signing.this.passphrase;
        }

        public Signing.Mode getMode() {
            return Signing.this.mode;
        }

        public boolean isArtifacts() {
            return Signing.this.isArtifacts();
        }

        public boolean isFiles() {
            return Signing.this.isFiles();
        }

        public boolean isChecksums() {
            return Signing.this.isChecksums();
        }

        public boolean isCatalogs() {
            return Signing.this.isCatalogs();
        }

        public Signing.Command getCommand() {
            return Signing.this.command.asImmutable();
        }

        public Signing.Cosign getCosign() {
            return Signing.this.cosign.asImmutable();
        }

        public Active getActive() {
            return Signing.this.getActive();
        }

        public boolean isEnabled() {
            return Signing.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Signing.this.asMap(full);
        }
    };

    public org.jreleaser.model.api.signing.Signing asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Signing source) {
        super.merge(source);
        this.armored = this.merge(this.armored, source.armored);
        this.verify = this.merge(this.verify, source.verify);
        this.publicKey = this.merge(this.publicKey, source.publicKey);
        this.secretKey = this.merge(this.secretKey, source.secretKey);
        this.passphrase = this.merge(this.passphrase, source.passphrase);
        this.mode = this.merge(this.mode, source.mode);
        this.artifacts = this.merge(this.artifacts, source.artifacts);
        this.files = this.merge(this.files, source.files);
        this.checksums = this.merge(this.checksums, source.checksums);
        this.catalogs = this.merge(this.catalogs, source.catalogs);
        this.setCommand(source.command);
        this.setCosign(source.cosign);
    }

    public Signing.Mode resolveMode() {
        if (null == this.mode) {
            this.mode = Signing.Mode.MEMORY;
        }
        return this.mode;
    }

    public boolean isArmored() {
        return null != this.armored && this.armored != false;
    }

    public void setArmored(Boolean armored) {
        this.armored = armored;
    }

    public boolean isArmoredSet() {
        return null != this.armored;
    }

    public boolean isVerify() {
        return null == this.verify || this.verify != false;
    }

    public void setVerify(Boolean verify) {
        this.verify = verify;
    }

    public boolean isVerifySet() {
        return null != this.verify;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public Signing.Mode getMode() {
        return this.mode;
    }

    public void setMode(Signing.Mode mode) {
        this.mode = mode;
    }

    public void setMode(String str) {
        this.setMode(Signing.Mode.of((String)str));
    }

    public boolean isArtifactsSet() {
        return null != this.artifacts;
    }

    public boolean isArtifacts() {
        return null == this.artifacts || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public boolean isFiles() {
        return null == this.files || this.files != false;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isFilesSet() {
        return null != this.files;
    }

    public boolean isChecksumsSet() {
        return null != this.checksums;
    }

    public boolean isChecksums() {
        return null == this.checksums || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    public boolean isCatalogsSet() {
        return null != this.catalogs;
    }

    public boolean isCatalogs() {
        return null == this.catalogs || this.catalogs != false;
    }

    public void setCatalogs(Boolean catalogs) {
        this.catalogs = catalogs;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command.merge(command);
    }

    public Cosign getCosign() {
        return this.cosign;
    }

    public void setCosign(Cosign cosign) {
        this.cosign.merge(cosign);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("armored", this.isArmored());
        props.put("verify", this.isVerify());
        props.put("mode", this.mode);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("checksums", this.isChecksums());
        props.put("catalogs", this.isCatalogs());
        props.put("passphrase", StringUtils.isNotBlank((String)this.passphrase) ? "************" : "**unset**");
        if (this.mode == Signing.Mode.COMMAND) {
            props.put("command", this.command.asMap(full));
        } else if (this.mode == Signing.Mode.COSIGN) {
            props.put("cosign", this.cosign.asMap(full));
        } else {
            props.put("publicKey", StringUtils.isNotBlank((String)this.publicKey) ? "************" : "**unset**");
            props.put("secretKey", StringUtils.isNotBlank((String)this.secretKey) ? "************" : "**unset**");
        }
        return props;
    }

    public String getSignatureExtension() {
        String extension = ".sig";
        if (this.mode != Signing.Mode.COSIGN) {
            extension = this.isArmored() ? ".asc" : ".sig";
        }
        return extension;
    }

    public static class Cosign
    extends AbstractModelObject<Cosign>
    implements Domain {
        private static final long serialVersionUID = 5608123183696686008L;
        private String version;
        private String privateKeyFile;
        private String publicKeyFile;
        @JsonIgnore
        private final Signing.Cosign immutable = new Signing.Cosign(){
            private static final long serialVersionUID = 3675807300391748445L;

            public String getVersion() {
                return version;
            }

            public String getPrivateKeyFile() {
                return privateKeyFile;
            }

            public String getPublicKeyFile() {
                return publicKeyFile;
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        public Signing.Cosign asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Cosign source) {
            this.version = this.merge(this.version, source.version);
            this.privateKeyFile = this.merge(this.privateKeyFile, source.privateKeyFile);
            this.publicKeyFile = this.merge(this.publicKeyFile, source.publicKeyFile);
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        public String getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public void setPublicKeyFile(String publicKeyFile) {
            this.publicKeyFile = publicKeyFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("version", this.version);
            props.put("privateKeyFile", null != this.privateKeyFile ? "************" : "**unset**");
            props.put("publicKeyFile", this.publicKeyFile);
            return props;
        }

        public Path getResolvedPrivateKeyFilePath(JReleaserContext context) {
            String privateKey = this.getPrivateKeyFile();
            if (StringUtils.isNotBlank((String)privateKey)) {
                return context.getBasedir().resolve(privateKey);
            }
            return this.resolveJReleaserHomeDir().resolve("cosign.key");
        }

        public Path getResolvedPublicKeyFilePath(JReleaserContext context) {
            String publicKey = this.getPublicKeyFile();
            if (StringUtils.isNotBlank((String)publicKey)) {
                return context.getBasedir().resolve(publicKey);
            }
            return this.resolveJReleaserHomeDir().resolve("cosign.pub");
        }

        private Path resolveJReleaserHomeDir() {
            String home = System.getenv("JRELEASER_USER_HOME");
            if (StringUtils.isBlank((String)home)) {
                home = System.getProperty("user.home") + File.separator + ".jreleaser";
            }
            return Paths.get(home, new String[0]);
        }
    }

    public static class Command
    extends AbstractModelObject<Command>
    implements Domain {
        private static final long serialVersionUID = 6761158529249184059L;
        private final List<String> args = new ArrayList<String>();
        private String executable;
        private String keyName;
        private String homeDir;
        private String publicKeyring;
        private Boolean defaultKeyring;
        @JsonIgnore
        private final Signing.Command immutable = new Signing.Command(){
            private static final long serialVersionUID = -8636071040086599491L;

            public String getExecutable() {
                return executable;
            }

            public String getKeyName() {
                return keyName;
            }

            public String getHomeDir() {
                return homeDir;
            }

            public String getPublicKeyring() {
                return publicKeyring;
            }

            public boolean isDefaultKeyring() {
                return this.isDefaultKeyring();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        private Signing.Command asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Command source) {
            this.executable = this.merge(this.executable, source.executable);
            this.keyName = this.merge(this.keyName, source.keyName);
            this.homeDir = this.merge(this.homeDir, source.homeDir);
            this.publicKeyring = this.merge(this.publicKeyring, source.publicKeyring);
            this.defaultKeyring = this.merge(this.defaultKeyring, source.defaultKeyring);
            this.setArgs(this.merge(this.args, source.args));
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setExecutable(String executable) {
            this.executable = executable;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getHomeDir() {
            return this.homeDir;
        }

        public void setHomeDir(String homeDir) {
            this.homeDir = homeDir;
        }

        public String getPublicKeyring() {
            return this.publicKeyring;
        }

        public void setPublicKeyring(String publicKeyring) {
            this.publicKeyring = publicKeyring;
        }

        public boolean isDefaultKeyringSet() {
            return null != this.defaultKeyring;
        }

        public boolean isDefaultKeyring() {
            return null == this.defaultKeyring || this.defaultKeyring != false;
        }

        public void setDefaultKeyring(Boolean defaultKeyring) {
            this.defaultKeyring = defaultKeyring;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("executable", this.executable);
            props.put("keyName", this.keyName);
            props.put("homeDir", this.homeDir);
            props.put("publicKeyring", this.publicKeyring);
            props.put("defaultKeyring", this.isDefaultKeyring());
            props.put("args", this.args);
            return props;
        }
    }
}

