/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jreleaser.cli.Banner;
import org.jreleaser.cli.BaseCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.IO;
import org.jreleaser.cli.internal.Colorizer;
import org.jreleaser.model.JReleaserException;
import picocli.CommandLine;

@CommandLine.Command
abstract class AbstractCommand<C extends IO>
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private C parent;

    AbstractCommand() {
    }

    protected C parent() {
        return this.parent;
    }

    @Override
    public Integer call() {
        this.setup();
        this.checkArgsForDeprecations();
        try {
            this.execute();
        }
        catch (HaltExecutionException e) {
            return 1;
        }
        catch (JReleaserException e) {
            Colorizer colorizer = new Colorizer(this.parent().getOut());
            String message = e.getMessage();
            colorizer.println(message);
            this.printDetails(e.getCause(), message, colorizer);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace(new Colorizer(this.parent().getOut()));
            return 1;
        }
        return 0;
    }

    protected void setup() {
        Banner.display(this.parent().getErr());
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "error");
    }

    protected void checkArgsForDeprecations() {
        TreeSet<DeprecatedArg> candidates = new TreeSet<DeprecatedArg>();
        this.collectCandidateDeprecatedArgs(candidates);
        Map<String, DeprecatedArg> groupedCandidates = candidates.stream().collect(Collectors.toMap(DeprecatedArg::getDeprecated, e -> e));
        TreeSet<DeprecatedArg> args = new TreeSet<DeprecatedArg>();
        CommandLine.ParseResult pr = this.spec.commandLine().getParseResult();
        List options = this.spec.options();
        for (CommandLine.Model.OptionSpec opt : options) {
            String optName = opt.shortestName();
            if (!groupedCandidates.containsKey(optName) || !pr.expandedArgs().contains(optName) || !pr.hasMatchedOption(optName)) continue;
            args.add(groupedCandidates.get(optName));
        }
        for (DeprecatedArg arg : args) {
            this.parent().getErr().println(this.$("deprecated.arg", arg.deprecated, arg.since, arg.replacement));
        }
    }

    protected void collectCandidateDeprecatedArgs(Set<DeprecatedArg> args) {
    }

    protected void printDetails(Throwable throwable, String message, Colorizer colorizer) {
        if (null == throwable) {
            return;
        }
        String myMessage = throwable.getMessage();
        if (!message.equals(myMessage)) {
            colorizer.println(myMessage);
        } else {
            this.printDetails(throwable.getCause(), message, colorizer);
        }
    }

    protected abstract void execute();

    public static final class DeprecatedArg
    implements Comparable<DeprecatedArg> {
        private final String deprecated;
        private final String replacement;
        private final String since;

        public DeprecatedArg(String deprecated, String replacement, String since) {
            this.deprecated = deprecated;
            this.replacement = replacement;
            this.since = since;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String getSince() {
            return this.since;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeprecatedArg that = (DeprecatedArg)o;
            return this.deprecated.equals(that.deprecated) && this.replacement.equals(that.replacement) && this.since.equals(that.since);
        }

        public int hashCode() {
            return Objects.hash(this.deprecated, this.replacement, this.since);
        }

        @Override
        public int compareTo(DeprecatedArg o) {
            return Comparator.comparing(DeprecatedArg::getDeprecated).compare(this, o);
        }
    }
}

