/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.userauth.keyprovider;

import com.hierynomus.sshj.common.KeyDecryptionFailedException;
import com.hierynomus.sshj.transport.cipher.BlockCiphers;
import com.hierynomus.sshj.transport.cipher.ChachaPolyCiphers;
import com.hierynomus.sshj.transport.cipher.GcmCiphers;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyFileUtil;
import com.hierynomus.sshj.userauth.keyprovider.bcrypt.BCrypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.openssl.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyV1KeyFile
extends BaseFileKeyProvider {
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";
    private static final byte[] AUTH_MAGIC = "openssh-key-v1\u0000".getBytes();
    public static final String OPENSSH_PRIVATE_KEY = "OPENSSH PRIVATE KEY-----";
    public static final String BCRYPT = "bcrypt";
    private static final String NONE_CIPHER = "none";
    private static final Map<String, Factory.Named<Cipher>> SUPPORTED_CIPHERS = new HashMap<String, Factory.Named<Cipher>>();
    private PublicKey pubKey;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void init(File location) {
        File pubKey = OpenSSHKeyFileUtil.getPublicKeyFile(location);
        if (pubKey != null) {
            try {
                this.initPubKey(new FileReader(pubKey));
            }
            catch (IOException e) {
                this.log.warn("Error reading public key file: {}", (Object)e.toString());
            }
        }
        super.init(location);
    }

    @Override
    protected KeyPair readKeyPair() throws IOException {
        BufferedReader reader;
        block5: {
            reader = new BufferedReader(this.resource.getReader());
            if (!this.checkHeader(reader)) break block5;
            String encodedPrivateKey = this.readEncodedKey(reader);
            byte[] decodedPrivateKey = Base64.getDecoder().decode(encodedPrivateKey);
            Buffer.PlainBuffer bufferedPrivateKey = new Buffer.PlainBuffer(decodedPrivateKey);
            KeyPair keyPair = this.readDecodedKeyPair(bufferedPrivateKey);
            IOUtils.closeQuietly(reader);
            return keyPair;
        }
        try {
            try {
                String message = String.format("File header not found [%s%s]", BEGIN, OPENSSH_PRIVATE_KEY);
                throw new IOException(message);
            }
            catch (GeneralSecurityException e) {
                throw new SSHRuntimeException("Read OpenSSH Version 1 Key failed", e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
    }

    private void initPubKey(Reader publicKey) throws IOException {
        OpenSSHKeyFileUtil.ParsedPubKey parsed = OpenSSHKeyFileUtil.initPubKey(publicKey);
        this.type = parsed.getType();
        this.pubKey = parsed.getPubKey();
    }

    private KeyPair readDecodedKeyPair(Buffer.PlainBuffer keyBuffer) throws IOException, GeneralSecurityException {
        byte[] bytes = new byte[AUTH_MAGIC.length];
        keyBuffer.readRawBytes(bytes);
        if (!ByteArrayUtils.equals(bytes, 0, AUTH_MAGIC, 0, AUTH_MAGIC.length)) {
            throw new IOException("This key does not contain the 'openssh-key-v1' format magic header");
        }
        String cipherName = keyBuffer.readString();
        String kdfName = keyBuffer.readString();
        byte[] kdfOptions = keyBuffer.readBytes();
        int nrKeys = keyBuffer.readUInt32AsInt();
        if (nrKeys != 1) {
            String message = String.format("OpenSSH Private Key number of keys not supported [%d]", nrKeys);
            throw new IOException(message);
        }
        PublicKey publicKey = this.pubKey;
        if (publicKey == null) {
            publicKey = this.readPublicKey(new Buffer.PlainBuffer(keyBuffer.readBytes()));
        } else {
            keyBuffer.readBytes();
        }
        byte[] privateKeyEncoded = keyBuffer.readBytes();
        Buffer.PlainBuffer privateKeyBuffer = new Buffer.PlainBuffer(privateKeyEncoded);
        if (NONE_CIPHER.equals(cipherName)) {
            return this.readUnencrypted(privateKeyBuffer, publicKey);
        }
        byte[] encryptedPrivateKey = this.readEncryptedPrivateKey(privateKeyEncoded, keyBuffer);
        while (true) {
            byte[] encrypted = (byte[])encryptedPrivateKey.clone();
            try {
                Buffer.PlainBuffer decrypted = this.decryptPrivateKey(encrypted, privateKeyEncoded.length, cipherName, kdfName, kdfOptions);
                return this.readUnencrypted(decrypted, publicKey);
            }
            catch (KeyDecryptionFailedException e) {
                if (this.pwdf != null && this.pwdf.shouldRetry(this.resource)) continue;
                throw e;
            }
            break;
        }
    }

    private byte[] readEncryptedPrivateKey(byte[] privateKeyEncoded, Buffer.PlainBuffer inputBuffer) throws Buffer.BufferException {
        byte[] encryptedPrivateKey;
        int bufferRemaining = inputBuffer.available();
        if (bufferRemaining == 0) {
            encryptedPrivateKey = privateKeyEncoded;
        } else {
            byte[] authenticationTag = new byte[bufferRemaining];
            inputBuffer.readRawBytes(authenticationTag);
            int encryptedBufferLength = privateKeyEncoded.length + authenticationTag.length;
            Buffer.PlainBuffer encryptedBuffer = new Buffer.PlainBuffer(encryptedBufferLength);
            encryptedBuffer.putRawBytes(privateKeyEncoded);
            encryptedBuffer.putRawBytes(authenticationTag);
            encryptedPrivateKey = new byte[encryptedBufferLength];
            encryptedBuffer.readRawBytes(encryptedPrivateKey);
        }
        return encryptedPrivateKey;
    }

    private Buffer.PlainBuffer decryptPrivateKey(byte[] privateKey, int privateKeyLength, String cipherName, String kdfName, byte[] kdfOptions) throws IOException {
        try {
            Cipher cipher = this.createCipher(cipherName);
            this.initializeCipher(kdfName, kdfOptions, cipher);
            cipher.update(privateKey, 0, privateKeyLength);
        }
        catch (SSHRuntimeException e) {
            String message = String.format("OpenSSH Private Key decryption failed with cipher [%s]", cipherName);
            throw new KeyDecryptionFailedException(new EncryptionException(message, (Throwable)e));
        }
        Buffer.PlainBuffer decryptedPrivateKey = new Buffer.PlainBuffer(privateKeyLength);
        decryptedPrivateKey.putRawBytes(privateKey, 0, privateKeyLength);
        return decryptedPrivateKey;
    }

    private void initializeCipher(String kdfName, byte[] kdfOptions, Cipher cipher) throws Buffer.BufferException {
        byte[] passphrase;
        Buffer.PlainBuffer bufferedOptions;
        if (kdfName.equals(BCRYPT)) {
            bufferedOptions = new Buffer.PlainBuffer(kdfOptions);
            passphrase = new byte[]{};
            if (this.pwdf != null) {
                CharBuffer charBuffer = CharBuffer.wrap(this.pwdf.reqPassword(null));
                ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
                passphrase = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                Arrays.fill(charBuffer.array(), '\u0000');
                Arrays.fill(byteBuffer.array(), (byte)0);
            }
        } else {
            String message = String.format("OpenSSH Private Key encryption KDF not supported [%s]", kdfName);
            throw new IllegalStateException(message);
        }
        int ivSize = cipher.getIVSize();
        int blockSize = cipher.getBlockSize();
        int parameterSize = ivSize + blockSize;
        byte[] keyIvParameters = new byte[parameterSize];
        byte[] salt = bufferedOptions.readBytes();
        int iterations = bufferedOptions.readUInt32AsInt();
        new BCrypt().pbkdf(passphrase, salt, iterations, keyIvParameters);
        Arrays.fill(passphrase, (byte)0);
        byte[] key = Arrays.copyOfRange(keyIvParameters, 0, blockSize);
        byte[] iv = Arrays.copyOfRange(keyIvParameters, blockSize, parameterSize);
        cipher.init(Cipher.Mode.Decrypt, key, iv);
    }

    private Cipher createCipher(String cipherName) {
        if (!SUPPORTED_CIPHERS.containsKey(cipherName)) {
            String message = String.format("OpenSSH Key encryption cipher not supported [%s]", cipherName);
            throw new IllegalStateException(message);
        }
        Factory.Named<Cipher> cipherFactory = SUPPORTED_CIPHERS.get(cipherName);
        Cipher cipher = (Cipher)cipherFactory.create();
        return cipher;
    }

    private PublicKey readPublicKey(Buffer.PlainBuffer plainBuffer) throws Buffer.BufferException, GeneralSecurityException {
        return KeyType.fromString(plainBuffer.readString()).readPubKeyFromBuffer(plainBuffer);
    }

    private String readEncodedKey(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean footerFound = false;
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith(END)) {
                footerFound = true;
                break;
            }
            builder.append(line);
            line = reader.readLine();
        }
        if (footerFound) {
            return builder.toString();
        }
        String message = String.format("File footer not found [%s%s]", END, OPENSSH_PRIVATE_KEY);
        throw new IOException(message);
    }

    private boolean checkHeader(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && !line.startsWith(BEGIN)) {
            line = reader.readLine();
        }
        if (line == null) {
            return false;
        }
        line = line.substring(BEGIN.length());
        return line.startsWith(OPENSSH_PRIVATE_KEY);
    }

    private KeyPair readUnencrypted(Buffer.PlainBuffer keyBuffer, PublicKey publicKey) throws IOException, GeneralSecurityException {
        KeyPair kp;
        int checkInt2;
        int privKeyListSize = keyBuffer.available();
        if (privKeyListSize % 8 != 0) {
            throw new IOException("The private key section must be a multiple of the block size (8)");
        }
        int checkInt1 = keyBuffer.readUInt32AsInt();
        if (checkInt1 != (checkInt2 = keyBuffer.readUInt32AsInt())) {
            throw new KeyDecryptionFailedException(new EncryptionException("OpenSSH Private Key integer comparison failed"));
        }
        String keyType = keyBuffer.readString();
        KeyType kt = KeyType.fromString(keyType);
        switch (kt) {
            case ED25519: {
                keyBuffer.readBytes();
                keyBuffer.readUInt32();
                byte[] privKey = new byte[32];
                keyBuffer.readRawBytes(privKey);
                keyBuffer.readRawBytes(new byte[32]);
                kp = new KeyPair(publicKey, (PrivateKey)new EdDSAPrivateKey(new EdDSAPrivateKeySpec(privKey, (EdDSAParameterSpec)EdDSANamedCurveTable.getByName((String)"Ed25519"))));
                break;
            }
            case RSA: {
                RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = this.readRsaPrivateKeySpec(keyBuffer);
                PrivateKey privateKey = SecurityUtils.getKeyFactory("RSA").generatePrivate(rsaPrivateCrtKeySpec);
                kp = new KeyPair(publicKey, privateKey);
                break;
            }
            case ECDSA256: {
                kp = new KeyPair(publicKey, this.createECDSAPrivateKey(kt, keyBuffer, "P-256"));
                break;
            }
            case ECDSA384: {
                kp = new KeyPair(publicKey, this.createECDSAPrivateKey(kt, keyBuffer, "P-384"));
                break;
            }
            case ECDSA521: {
                kp = new KeyPair(publicKey, this.createECDSAPrivateKey(kt, keyBuffer, "P-521"));
                break;
            }
            default: {
                throw new IOException("Cannot decode keytype " + keyType + " in openssh-key-v1 files (yet).");
            }
        }
        keyBuffer.readString();
        byte[] padding = new byte[keyBuffer.available()];
        keyBuffer.readRawBytes(padding);
        for (int i = 0; i < padding.length; ++i) {
            if (padding[i] == i + 1) continue;
            throw new IOException("Padding of key format contained wrong byte at position: " + i);
        }
        return kp;
    }

    private PrivateKey createECDSAPrivateKey(KeyType kt, Buffer.PlainBuffer buffer, String name) throws GeneralSecurityException, Buffer.BufferException {
        kt.readPubKeyFromBuffer(buffer);
        BigInteger s = new BigInteger(1, buffer.readBytes());
        X9ECParameters ecParams = NISTNamedCurves.getByName((String)name);
        ECNamedCurveSpec ecCurveSpec = new ECNamedCurveSpec(name, ecParams.getCurve(), ecParams.getG(), ecParams.getN());
        ECPrivateKeySpec pks = new ECPrivateKeySpec(s, (ECParameterSpec)ecCurveSpec);
        return SecurityUtils.getKeyFactory("ECDSA").generatePrivate(pks);
    }

    private RSAPrivateCrtKeySpec readRsaPrivateKeySpec(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        BigInteger modulus = buffer.readMPInt();
        BigInteger publicExponent = buffer.readMPInt();
        BigInteger privateExponent = buffer.readMPInt();
        BigInteger crtCoefficient = buffer.readMPInt();
        BigInteger primeP = buffer.readMPInt();
        BigInteger primeQ = buffer.readMPInt();
        BigInteger primeExponentP = privateExponent.remainder(primeP.subtract(BigInteger.ONE));
        BigInteger primeExponentQ = privateExponent.remainder(primeQ.subtract(BigInteger.ONE));
        return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
    }

    static {
        SUPPORTED_CIPHERS.put(BlockCiphers.TripleDESCBC().getName(), BlockCiphers.TripleDESCBC());
        SUPPORTED_CIPHERS.put(BlockCiphers.AES128CBC().getName(), BlockCiphers.AES128CBC());
        SUPPORTED_CIPHERS.put(BlockCiphers.AES192CBC().getName(), BlockCiphers.AES192CBC());
        SUPPORTED_CIPHERS.put(BlockCiphers.AES256CBC().getName(), BlockCiphers.AES256CBC());
        SUPPORTED_CIPHERS.put(BlockCiphers.AES128CTR().getName(), BlockCiphers.AES128CTR());
        SUPPORTED_CIPHERS.put(BlockCiphers.AES192CTR().getName(), BlockCiphers.AES192CTR());
        SUPPORTED_CIPHERS.put(BlockCiphers.AES256CTR().getName(), BlockCiphers.AES256CTR());
        SUPPORTED_CIPHERS.put(GcmCiphers.AES256GCM().getName(), GcmCiphers.AES256GCM());
        SUPPORTED_CIPHERS.put(GcmCiphers.AES128GCM().getName(), GcmCiphers.AES128GCM());
        SUPPORTED_CIPHERS.put(ChachaPolyCiphers.CHACHA_POLY_OPENSSH().getName(), ChachaPolyCiphers.CHACHA_POLY_OPENSSH());
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new OpenSSHKeyV1KeyFile();
        }

        @Override
        public String getName() {
            return KeyFormat.OpenSSHv1.name();
        }
    }
}

