/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserModel;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;

public interface JReleaserContext
extends Serializable {
    public static final String BASEDIR = "BASEDIR";
    public static final String DRY_RUN = "DRY_RUN";
    public static final String GIT_ROOT_SEARCH = "GIT_ROOT_SEARCH";
    public static final String STRICT = "STRICT";
    public static final String SELECT_CURRENT_PLATFORM = "SELECT_CURRENT_PLATFORM";
    public static final String SELECT_PLATFORMS = "SELECT_PLATFORMS";
    public static final String REJECT_PLATFORMS = "REJECT_PLATFORMS";

    public Path relativize(Path var1, Path var2);

    public Path relativizeToBasedir(Path var1);

    public JReleaserLogger getLogger();

    public Mode getMode();

    public JReleaserModel getModel();

    public Path getBasedir();

    public Path getOutputDirectory();

    public Path getChecksumsDirectory();

    public Path getCatalogsDirectory();

    public Path getSignaturesDirectory();

    public Path getPrepareDirectory();

    public Path getPackageDirectory();

    public Path getAssembleDirectory();

    public Path getDownloadDirectory();

    public Path getArtifactsDirectory();

    public Path getDeployDirectory();

    public boolean isDryrun();

    public boolean isGitRootSearch();

    public boolean isStrict();

    public List<String> getIncludedAnnouncers();

    public List<String> getIncludedAssemblers();

    public List<String> getIncludedDistributions();

    public List<String> getIncludedPackagers();

    public List<String> getIncludedDownloaderTypes();

    public List<String> getIncludedDownloaderNames();

    public List<String> getIncludedDeployerTypes();

    public List<String> getIncludedDeployerNames();

    public List<String> getIncludedUploaderTypes();

    public List<String> getIncludedUploaderNames();

    public List<String> getExcludedAnnouncers();

    public List<String> getExcludedAssemblers();

    public List<String> getExcludedDistributions();

    public List<String> getExcludedPackagers();

    public List<String> getExcludedDownloaderTypes();

    public List<String> getExcludedDownloaderNames();

    public List<String> getExcludedDeployerTypes();

    public List<String> getExcludedDeployerNames();

    public List<String> getExcludedUploaderTypes();

    public List<String> getExcludedUploaderNames();

    public JReleaserCommand getCommand();

    public TemplateContext props();

    public TemplateContext fullProps();

    public void nag(String var1, String var2);

    public Keyring createKeyring() throws SigningException;

    public Changelog getChangelog();

    public Map<String, Object> getAdditionalProperties();

    public static enum Mode {
        CONFIG,
        DOWNLOAD,
        ASSEMBLE,
        DEPLOY,
        FULL,
        CHANGELOG,
        ANNOUNCE;


        public boolean validateChangelog() {
            return this == CHANGELOG;
        }

        public boolean validateAnnounce() {
            return this == ANNOUNCE;
        }

        public boolean validateDeploy() {
            return this == DEPLOY;
        }

        public boolean validateDownload() {
            return this == DOWNLOAD;
        }

        public boolean validateAssembly() {
            return this == ASSEMBLE;
        }

        public boolean validateStandalone() {
            return this.validateAssembly() || this.validateDownload();
        }

        public boolean validateConfig() {
            return this == CONFIG || this == FULL;
        }

        public boolean validatePaths() {
            return this == FULL;
        }
    }

    public static class Changelog
    implements Serializable {
        private static final long serialVersionUID = -7619174395858420344L;
        private String resolvedChangelog;
        private String formattedChanges;
        private String formattedContributors;

        public String getResolvedChangelog() {
            return this.resolvedChangelog;
        }

        public void setResolvedChangelog(String resolvedChangelog) {
            this.resolvedChangelog = resolvedChangelog;
        }

        public String getFormattedChanges() {
            return this.formattedChanges;
        }

        public void setFormattedChanges(String formattedChanges) {
            this.formattedChanges = formattedChanges;
        }

        public String getFormattedContributors() {
            return this.formattedContributors;
        }

        public void setFormattedContributors(String formattedContributors) {
            this.formattedContributors = formattedContributors;
        }

        public void apply(TemplateContext props) {
            if (!props.contains("changelog")) {
                props.set("changelog", MustacheUtils.passThrough(this.resolvedChangelog));
            }
            if (!props.contains("changelogChanges")) {
                props.set("changelogChanges", MustacheUtils.passThrough(this.formattedChanges));
            }
            if (!props.contains("changelogContributors")) {
                props.set("changelogContributors", MustacheUtils.passThrough(this.formattedContributors));
            }
        }
    }
}

