/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.signing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPException;
import org.jreleaser.model.api.signing.Keyring;

public final class InMemoryKeyring
extends Keyring {
    private final byte[] encodedPublicKey;
    private final byte[] encodedPrivateKey;

    public InMemoryKeyring(byte[] encodedPublicKey, byte[] encodedPrivateKey) throws IOException, PGPException {
        this.encodedPublicKey = encodedPublicKey;
        this.encodedPrivateKey = encodedPrivateKey;
    }

    protected InputStream getPublicKeyRingStream() {
        if (null != this.encodedPublicKey) {
            return new ByteArrayInputStream(this.encodedPublicKey);
        }
        return new Keyring.EmptyInputStream();
    }

    protected InputStream getSecretKeyRingStream() {
        return new ByteArrayInputStream(this.encodedPrivateKey);
    }
}

