/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.files;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;

public final class Files
extends AbstractActivatable<Files>
implements Domain {
    private static final long serialVersionUID = -7799032884331569570L;
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final List<org.jreleaser.model.internal.common.Glob> globs = new ArrayList<org.jreleaser.model.internal.common.Glob>();
    @JsonIgnore
    private final Set<Artifact> paths = new LinkedHashSet<Artifact>();
    @JsonIgnore
    private boolean resolved;
    @JsonIgnore
    private final org.jreleaser.model.api.files.Files immutable = new org.jreleaser.model.api.files.Files(){
        private static final long serialVersionUID = -328612924170955820L;
        private Set<? extends org.jreleaser.model.api.common.Artifact> paths;
        private Set<? extends org.jreleaser.model.api.common.Artifact> artifacts;
        private List<? extends Glob> globs;

        public Set<? extends org.jreleaser.model.api.common.Artifact> getPaths() {
            if (null == this.paths) {
                this.paths = Files.this.paths.stream().map(Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.paths;
        }

        public Set<? extends org.jreleaser.model.api.common.Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = Files.this.artifacts.stream().map(Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends Glob> getGlobs() {
            if (null == this.globs) {
                this.globs = Files.this.globs.stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.globs;
        }

        public Active getActive() {
            return Files.this.getActive();
        }

        public boolean isEnabled() {
            return Files.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Files.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.files.Files asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Files source) {
        super.merge(source);
        this.setArtifacts(this.merge(this.artifacts, source.artifacts));
        this.setGlobs(this.merge(this.globs, source.globs));
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.globs.isEmpty();
    }

    public boolean arePathsResolved() {
        return this.resolved;
    }

    public Set<Artifact> getPaths() {
        return Artifact.sortArtifacts(this.paths);
    }

    public void setPaths(Set<Artifact> paths) {
        this.paths.clear();
        this.paths.addAll(paths);
        this.resolved = true;
    }

    public Set<Artifact> getArtifacts() {
        return Artifact.sortArtifacts(this.artifacts);
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<org.jreleaser.model.internal.common.Glob> getGlobs() {
        return this.globs;
    }

    public void setGlobs(List<org.jreleaser.model.internal.common.Glob> globs) {
        this.globs.clear();
        this.globs.addAll(globs);
    }

    public void addGlobs(List<org.jreleaser.model.internal.common.Glob> globs) {
        this.globs.addAll(globs);
    }

    public void addGlob(org.jreleaser.model.internal.common.Glob glob) {
        if (null != glob) {
            this.globs.add(glob);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        map.put("artifacts", mappedArtifacts);
        LinkedHashMap<String, Map<String, Object>> mappedGlobs = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.globs.size(); ++i) {
            mappedGlobs.put("glob " + i, this.globs.get(i).asMap(full));
        }
        map.put("globs", mappedGlobs);
        return map;
    }
}

