/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import org.jreleaser.util.IoUtils;

public class JReleaserVersion {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(JReleaserVersion.class.getName());
    private static final String JRELEASER_VERSION = BUNDLE.getString("jreleaser_version");
    private static final String BUILD_DATE = BUNDLE.getString("build_date");
    private static final String BUILD_TIME = BUNDLE.getString("build_time");
    private static final String BUILD_REVISION = BUNDLE.getString("build_revision");
    private static final String SEPARATOR = "------------------------------------------------------------%n";
    private static final String JRELEASER_FORMAT = "jreleaser %s%n";

    private JReleaserVersion() {
    }

    public static String getPlainVersion() {
        return JRELEASER_VERSION;
    }

    public static void banner(PrintStream out) {
        JReleaserVersion.banner(out, true);
    }

    public static void banner(PrintStream out, boolean full) {
        JReleaserVersion.banner(IoUtils.newPrintWriter((OutputStream)out), full);
    }

    public static void banner(PrintWriter out) {
        JReleaserVersion.banner(out, true);
    }

    public static void banner(PrintWriter out, boolean full) {
        if (full) {
            out.printf(SEPARATOR, new Object[0]);
            out.printf(JRELEASER_FORMAT, JRELEASER_VERSION);
            String jvm = System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + " " + System.getProperty("java.vm.version") + ")";
            out.printf(SEPARATOR, new Object[0]);
            out.printf("Build time:   %s %s%n", BUILD_DATE, BUILD_TIME);
            out.printf("Revision:     %s%n", BUILD_REVISION);
            out.printf("JVM:          %s%n", jvm);
            out.printf(SEPARATOR, new Object[0]);
        } else {
            out.printf(JRELEASER_FORMAT, JRELEASER_VERSION);
        }
    }
}

