/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.ChangelogGenerator;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.release.AbstractReleaser;
import org.jreleaser.sdk.github.Github;
import org.jreleaser.sdk.github.api.GhAsset;
import org.jreleaser.sdk.github.api.GhIssue;
import org.jreleaser.sdk.github.api.GhLabel;
import org.jreleaser.sdk.github.api.GhMilestone;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.sdk.github.api.GhReleaseNotes;
import org.jreleaser.sdk.github.api.GhReleaseNotesParams;
import org.jreleaser.sdk.github.api.GhRepository;
import org.jreleaser.util.StringUtils;

public class GithubReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.GithubReleaser> {
    private static final long serialVersionUID = -825713164586669508L;
    private static final String NOREPLY_GITHUB_COM_EMAIL = "noreply@github.com";
    private final org.jreleaser.model.internal.release.GithubReleaser github;

    public GithubReleaser(JReleaserContext context, Set<Asset> assets) {
        super(context, assets);
        this.github = context.getModel().getRelease().getGithub();
    }

    public org.jreleaser.model.api.release.GithubReleaser getReleaser() {
        return this.github.asImmutable();
    }

    public String generateReleaseNotes() throws IOException {
        if (this.github.getReleaseNotes().isEnabled()) {
            String content = this.generateReleaseNotesByAPI();
            if (this.github.getIssues().isEnabled()) {
                this.context.getLogger().info(RB.$((String)"issues.generator.extract", (Object[])new Object[0]));
                Set issues = ChangelogProvider.extractIssues((JReleaserContext)this.context, (String)content);
                ChangelogProvider.storeIssues((JReleaserContext)this.context, (Set)issues);
            }
            return ChangelogProvider.storeChangelog((JReleaserContext)this.context, (String)content);
        }
        try {
            return ChangelogProvider.getChangelog((JReleaserContext)this.context).trim();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private String generateReleaseNotesByAPI() throws JReleaserException {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        String tagName = github.getEffectiveTagName(this.context.getModel());
        try {
            Git git = GitSdk.of((JReleaserContext)this.context).open();
            ChangelogGenerator.Tags tags = new ChangelogGenerator().resolveTags(git, this.context);
            GhReleaseNotesParams params = new GhReleaseNotesParams();
            params.setTagName(tagName);
            if (!this.isTagInRemote(this.context, tagName)) {
                params.setTagName("HEAD");
            }
            if (tags.getPrevious().isPresent()) {
                params.setPreviousTagName(GitSdk.extractTagName((Ref)((Ref)tags.getPrevious().get())));
            }
            params.setTargetCommitish(github.getBranch());
            GhReleaseNotes releaseNotes = new Github(this.context.asImmutable(), github.getApiEndpoint(), github.getToken(), github.getConnectTimeout(), github.getReadTimeout()).generateReleaseNotes(github.getOwner(), github.getName(), params);
            return releaseNotes.getBody().replace("...HEAD", "..." + tagName);
        }
        catch (IOException | GitAPIException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), e);
        }
    }

    protected boolean isTagInRemote(JReleaserContext context, String tagName) {
        org.jreleaser.model.internal.release.GithubReleaser github = context.getModel().getRelease().getGithub();
        Github api = new Github(context.asImmutable(), github.getApiEndpoint(), github.getToken(), github.getConnectTimeout(), github.getReadTimeout());
        GhRepository repository = api.findRepository(github.getOwner(), github.getName());
        if (null == repository) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_repository_not_exists", (Object[])new Object[]{github.getCanonicalRepoName()}));
        }
        return api.listTags(github.getOwner(), github.getName()).stream().anyMatch(tag -> tag.getName().equals(tagName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        String pullBranch = this.github.getBranch();
        String pushBranch = this.github.getResolvedBranchPush(this.context.getModel());
        boolean mustCheckoutBranch = !pushBranch.equals(pullBranch);
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{this.github.getResolvedRepoUrl(this.context.getModel()), pushBranch});
        String tagName = this.github.getEffectiveTagName(this.context.getModel());
        try {
            Github api = new Github(this.context.asImmutable(), this.github.getApiEndpoint(), this.github.getToken(), this.github.getConnectTimeout(), this.github.getReadTimeout());
            if (!this.context.isDryrun()) {
                List<String> branchNames = api.listBranches(this.github.getOwner(), this.github.getName());
                GitSdk.of((JReleaserContext)this.context).checkoutBranch((BaseReleaser)this.github, pushBranch, mustCheckoutBranch, !branchNames.contains(pushBranch));
            }
            String changelog = this.normalizeChangelog(this.context.getChangelog().getResolvedChangelog());
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, this.github.getCanonicalRepoName()});
            GhRelease release = this.findReleaseByTag(api, tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (this.github.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(this.github.getOwner(), this.github.getName(), tagName, release.getId());
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.github.isMatch());
                    return;
                }
                if (this.github.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    GhRelease updater = new GhRelease();
                    if (this.github.getPrerelease().isEnabledSet()) {
                        updater.setPrerelease(this.github.getPrerelease().isEnabled());
                    }
                    if (this.github.isDraftSet()) {
                        updater.setDraft(this.github.isDraft());
                    }
                    if (this.github.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{this.github.getEffectiveReleaseName()});
                        updater.setName(this.github.getEffectiveReleaseName());
                    }
                    if (this.github.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setBody(changelog);
                    }
                    api.updateRelease(this.github.getOwner(), this.github.getName(), release.getId(), updater);
                    if (this.github.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        this.updateAssets(api, release);
                    }
                    this.linkDiscussion(tagName, release, api);
                    this.updateIssues(this.github, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{"GitHub", tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && this.github.isMatch());
            return;
        }
        catch (IOException | IllegalStateException | RestAPIException e) {
            this.context.getLogger().trace(e);
            throw new ReleaseException(e);
        }
    }

    private String normalizeChangelog(String changelog) throws ReleaseException {
        if (changelog.length() > 10000) {
            try {
                Path tmp = Files.createTempDirectory("jreleaser", new FileAttribute[0]);
                Path releaseMd = tmp.resolve("RELEASE.md");
                Files.write(releaseMd, changelog.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.assets.add(Asset.file((Path)releaseMd));
            }
            catch (IOException e) {
                throw new ReleaseException((Throwable)e);
            }
            this.context.getLogger().warn(RB.$((String)"github.release.changelog.trimmed", (Object[])new Object[0]));
            return changelog.substring(0, 9995) + " ...";
        }
        return changelog;
    }

    private GhRelease findReleaseByTag(Github api, String tagName) {
        if (this.context.isDryrun()) {
            return null;
        }
        return api.findReleaseByTag(this.github.getOwner(), this.github.getName(), tagName);
    }

    public Repository maybeCreateRepository(String owner, String repo, String password, ExtraProperties extraProperties) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        Github api = new Github(this.context.asImmutable(), this.github.getApiEndpoint(), password, this.github.getConnectTimeout(), this.github.getReadTimeout());
        GhRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(Repository.Kind.GITHUB, owner, repo, repository.getHtmlUrl(), repository.getCloneUrl());
    }

    public Optional<User> findUser(String email, String name) {
        if (NOREPLY_GITHUB_COM_EMAIL.equals(email)) {
            return Optional.empty();
        }
        try {
            return new Github(this.context.asImmutable(), this.github.getApiEndpoint(), this.github.getToken(), this.github.getConnectTimeout(), this.github.getReadTimeout()).findUser(email, name);
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<Release> listReleases(String owner, String repo) throws IOException {
        Github api = new Github(this.context.asImmutable(), this.github.getApiEndpoint(), this.github.getToken(), this.github.getConnectTimeout(), this.github.getReadTimeout());
        List<Release> releases = api.listReleases(owner, repo);
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Github api, String tagName, String changelog, boolean deleteTags) throws IOException {
        if (this.context.isDryrun()) {
            for (Asset asset : this.assets) {
                if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
            this.updateIssues(this.github, api);
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, this.github.getOwner(), this.github.getName(), tagName);
        }
        if (deleteTags || !this.github.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName, this.context.getModel().getCommit().getShortHash()});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GhRelease release = new GhRelease();
        release.setName(this.github.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setTargetCommitish(this.github.getResolvedBranchPush(this.context.getModel()));
        release.setBody(changelog);
        if (this.github.getPrerelease().isEnabledSet()) {
            release.setPrerelease(this.github.getPrerelease().isEnabled());
        }
        if (this.github.isDraftSet()) {
            release.setDraft(this.github.isDraft());
        }
        boolean isDraftBefore = release.isDraft();
        release = api.createRelease(this.github.getOwner(), this.github.getName(), release);
        api.uploadAssets(release, this.assets);
        if (this.github.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot()) {
            Optional<GhMilestone> milestone = api.findMilestoneByName(this.github.getOwner(), this.github.getName(), this.github.getMilestone().getEffectiveName());
            milestone.ifPresent(gtMilestone -> api.closeMilestone(this.github.getOwner(), this.github.getName(), (GhMilestone)gtMilestone));
        }
        this.linkDiscussion(tagName, release, api);
        this.updateIssues(this.github, api);
        this.context.getLogger().debug(RB.$((String)"git.check.release.draft", (Object[])new Object[]{this.github.getOwner(), this.github.getName(), release.getTagName()}));
        GhRelease newRelease = api.findReleaseById(this.github.getOwner(), this.github.getName(), release.getId());
        boolean isDraftAfter = newRelease.isDraft();
        if (!isDraftBefore && isDraftAfter) {
            GhRelease updater = new GhRelease();
            updater.setPrerelease(release.isPrerelease());
            updater.setDraft(false);
            updater.setTagName(release.getTagName());
            api.updateRelease(this.github.getOwner(), this.github.getName(), release.getId(), updater);
        }
    }

    private void updateIssues(org.jreleaser.model.internal.release.GithubReleaser github, Github api) throws IOException {
        if (!github.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        String tagName = github.getEffectiveTagName(this.context.getModel());
        String labelName = github.getIssues().getLabel().getName();
        String labelColor = github.getIssues().getLabel().getColor();
        TemplateContext props = github.props(this.context.getModel());
        github.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)github.getIssues().getComment(), (TemplateContext)props);
        if (labelColor.startsWith("#")) {
            labelColor = labelColor.substring(1);
        }
        GhLabel ghLabel = null;
        try {
            ghLabel = api.getOrCreateLabel(github.getOwner(), github.getName(), labelName, labelColor, github.getIssues().getLabel().getDescription());
        }
        catch (RestAPIException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional<Object> milestone = Optional.empty();
        Apply applyMilestone = github.getIssues().getApplyMilestone();
        if (github.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && !(milestone = api.findMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName());
        }
        for (String issueNumber : issueNumbers) {
            GhIssue ghIssue;
            Optional<GhIssue> op = api.findIssue(github.getOwner(), github.getName(), Integer.parseInt(issueNumber));
            if (!op.isPresent() || !"closed".equals((ghIssue = op.get()).getState()) || !ghIssue.getLabels().stream().noneMatch(l -> l.getName().equals(labelName))) continue;
            this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            api.addLabelToIssue(github.getOwner(), github.getName(), ghIssue, ghLabel);
            api.commentOnIssue(github.getOwner(), github.getName(), ghIssue, comment);
            milestone.ifPresent(ghMilestone -> this.applyMilestone(github, api, issueNumber, ghIssue, applyMilestone, (GhMilestone)ghMilestone));
        }
    }

    private void applyMilestone(org.jreleaser.model.internal.release.GithubReleaser github, Github api, String issueNumber, GhIssue ghIssue, Apply applyMilestone, GhMilestone targetMilestone) {
        GhMilestone issueMilestone = ghIssue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            api.setMilestoneOnIssue(github.getOwner(), github.getName(), ghIssue, targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    api.setMilestoneOnIssue(github.getOwner(), github.getName(), ghIssue, targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private void updateAssets(Github api, GhRelease release) throws IOException {
        TreeSet<Asset> assetsToBeUpdated = new TreeSet<Asset>();
        TreeSet<Asset> assetsToBeUploaded = new TreeSet<Asset>();
        Map<String, GhAsset> existingAssets = api.listAssets(this.github.getOwner(), this.github.getName(), release);
        LinkedHashMap assetsToBePublished = new LinkedHashMap();
        this.assets.forEach(asset -> assetsToBePublished.put(asset.getFilename(), asset));
        assetsToBePublished.keySet().forEach(name -> {
            if (existingAssets.containsKey(name)) {
                assetsToBeUpdated.add((Asset)assetsToBePublished.get(name));
            } else {
                assetsToBeUploaded.add((Asset)assetsToBePublished.get(name));
            }
        });
        api.updateAssets(this.github.getOwner(), this.github.getName(), release, assetsToBeUpdated, existingAssets);
        api.uploadAssets(release, assetsToBeUploaded);
    }

    private void linkDiscussion(String tagName, GhRelease release, Github api) {
        String discussionCategoryName = this.github.getDiscussionCategoryName();
        if (this.context.getModel().getProject().isSnapshot() || StringUtils.isBlank((String)discussionCategoryName) || this.github.isDraft()) {
            return;
        }
        this.context.getLogger().debug(RB.$((String)"git.releaser.link.discussion", (Object[])new Object[0]), new Object[]{tagName, discussionCategoryName});
        if (this.context.isDryrun()) {
            return;
        }
        try {
            GhRelease ghRelease = new GhRelease();
            ghRelease.setDiscussionCategoryName(discussionCategoryName);
            api.updateRelease(this.github.getOwner(), this.github.getName(), tagName, release.getId(), ghRelease);
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().warn(RB.$((String)"git.releaser.link.discussion.error", (Object[])new Object[0]), new Object[]{tagName, discussionCategoryName});
        }
    }

    private void deleteTags(Github api, String owner, String repo, String tagName) {
        try {
            api.deleteTag(owner, repo, tagName);
        }
        catch (RestAPIException e) {
            if (e.isUnprocessableEntity()) {
                return;
            }
            throw e;
        }
    }
}

