/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jreleaser.model.Asdf;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Github;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.Templates;

public class AsdfPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Asdf> {
    public AsdfPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        String repoUrl = gitService.getResolvedRepoUrl(this.context.getModel(), ((Asdf)this.packager).getRepository().getOwner(), ((Asdf)this.packager).getRepository().getResolvedName());
        props.put("asdfPluginRepoUrl", repoUrl);
        props.put("asdfPluginToolCheck", Templates.resolveTemplate((String)((Asdf)this.packager).getToolCheck(), props));
        String str = (String)props.get("distributionArtifactFile");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$ASDF_INSTALL_VERSION");
        props.put("asdfDistributionArtifactFile", str);
        str = (String)props.get("distributionArtifactFileName");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.put("asdfDistributionArtifactFileName", str);
        str = (String)props.get("distributionUrl");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.put("asdfDistributionUrl", str);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        if (fileName.contains("github") && !(gitService instanceof Github)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = StringUtils.remove((String)fileName, (String)"-github");
        }
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

