/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.CommitAuthor;
import org.jreleaser.model.CommitAuthorAware;
import org.jreleaser.model.Repository;

public class Article
extends AbstractAnnouncer<Article>
implements CommitAuthorAware {
    public static final String NAME = "article";
    private final Set<Artifact> files = new LinkedHashSet<Artifact>();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final Repository repository = new Repository();
    private String templateDirectory;

    public Article() {
        super(NAME);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.files.forEach(AbstractModelObject::freeze);
        this.commitAuthor.freeze();
        this.repository.freeze();
    }

    @Override
    public void merge(Article article) {
        this.freezeCheck();
        super.merge(article);
        this.templateDirectory = this.merge(this.templateDirectory, article.templateDirectory);
        this.setFiles(this.merge(this.files, article.files));
        this.setCommitAuthor(article.commitAuthor);
        this.setRepository(article.repository);
    }

    public Set<Artifact> getFiles() {
        return this.freezeWrap(Artifact.sortArtifacts(this.files));
    }

    public void setFiles(Set<Artifact> files) {
        this.freezeCheck();
        this.files.clear();
        this.files.addAll(files);
    }

    public void addFiles(Set<Artifact> files) {
        this.freezeCheck();
        this.files.addAll(files);
    }

    public void addFile(Artifact artifact) {
        this.freezeCheck();
        if (null != artifact) {
            this.files.add(artifact);
        }
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.merge(commitAuthor);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository.merge(repository);
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.freezeCheck();
        this.templateDirectory = templateDirectory;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("repository", this.repository.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getFiles()) {
            mappedArtifacts.put("files " + i++, artifact.asMap(full));
        }
        props.put("files", mappedArtifacts);
        props.put("templateDirectory", this.templateDirectory);
    }
}

