/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Brew
extends AbstractRepositoryPackager<Brew> {
    public static final String TYPE = "brew";
    public static final String SKIP_BREW = "skipBrew";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<String> livecheck = new ArrayList<String>();
    private final HomebrewTap tap = new HomebrewTap();
    private final Cask cask = new Cask();
    private String formulaName;
    private String cachedFormulaName;
    private Boolean multiPlatform;

    public Brew() {
        super(TYPE);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.tap.freeze();
        this.cask.freeze();
    }

    @Override
    public void merge(Brew brew) {
        this.freezeCheck();
        super.merge(brew);
        this.formulaName = this.merge(this.formulaName, brew.formulaName);
        this.multiPlatform = this.merge(this.multiPlatform, brew.multiPlatform);
        this.setTap(brew.tap);
        this.setDependenciesAsList(this.merge(this.dependencies, brew.dependencies));
        this.setLivecheck(this.merge(this.livecheck, brew.livecheck));
        this.setCask(brew.cask);
    }

    public String getResolvedFormulaName(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.cachedFormulaName)) {
            this.cachedFormulaName = Templates.resolveTemplate((String)this.formulaName, context.fullProps());
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        }
        return this.cachedFormulaName;
    }

    public String getResolvedFormulaName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedFormulaName)) {
            this.cachedFormulaName = Templates.resolveTemplate((String)this.formulaName, props);
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        } else if (this.cachedFormulaName.contains("{{")) {
            this.cachedFormulaName = Templates.resolveTemplate((String)this.cachedFormulaName, props);
            this.cachedFormulaName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedFormulaName);
        }
        return this.cachedFormulaName;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.freezeCheck();
        this.formulaName = formulaName;
    }

    public boolean isMultiPlatform() {
        return this.multiPlatform != null && this.multiPlatform != false;
    }

    public void setMultiPlatform(Boolean multiPlatform) {
        this.freezeCheck();
        this.multiPlatform = multiPlatform;
    }

    public boolean isMultiPlatformSet() {
        return this.multiPlatform != null;
    }

    public HomebrewTap getTap() {
        return this.tap;
    }

    public void setTap(HomebrewTap tap) {
        this.freezeCheck();
        this.tap.merge(tap);
    }

    public Cask getCask() {
        return this.cask;
    }

    public void setCask(Cask cask) {
        this.freezeCheck();
        this.cask.merge(cask);
    }

    public void setDependencies(Map<String, String> dependencies) {
        this.freezeCheck();
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        this.dependencies.clear();
        dependencies.forEach(this::addDependency);
    }

    public List<Dependency> getDependenciesAsList() {
        return this.freezeWrap(this.dependencies);
    }

    public void setDependenciesAsList(List<Dependency> dependencies) {
        this.freezeCheck();
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    public void addDependencies(Map<String, String> dependencies) {
        this.freezeCheck();
        if (null == dependencies || dependencies.isEmpty()) {
            return;
        }
        dependencies.forEach(this::addDependency);
    }

    public void addDependency(String key, String value) {
        this.freezeCheck();
        this.dependencies.add(new Dependency(key, value));
    }

    public void addDependency(String key) {
        this.freezeCheck();
        this.dependencies.add(new Dependency(key));
    }

    public List<String> getLivecheck() {
        return this.freezeWrap(this.livecheck);
    }

    public void setLivecheck(List<String> livecheck) {
        this.freezeCheck();
        this.livecheck.clear();
        this.livecheck.addAll(livecheck);
    }

    public boolean hasLivecheck() {
        return !this.livecheck.isEmpty();
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("formulaName", this.formulaName);
        props.put("multiPlatform", this.isMultiPlatform());
        props.put("tap", this.tap.asMap(full));
        props.put("dependencies", this.dependencies);
        props.put("livecheck", this.livecheck);
        props.put("cask", this.cask.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.tap;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        if (this.isMultiPlatform()) {
            return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isLinux((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
        }
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    public List<Artifact> resolveCandidateArtifacts(JReleaserContext context, Distribution distribution) {
        List<Artifact> candidateArtifacts = super.resolveCandidateArtifacts(context, distribution);
        if (this.cask.isEnabled()) {
            return candidateArtifacts.stream().filter(artifact -> PlatformUtils.isMac((String)artifact.getPlatform())).collect(Collectors.toList());
        }
        return candidateArtifacts;
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_BREW));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension(), FileType.DMG.extension(), FileType.PKG.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
    }

    public static class CaskItem
    extends AbstractModelObject<CaskItem>
    implements Domain {
        private final List<String> items = new ArrayList<String>();
        private String name;

        public CaskItem(String name, List<String> items) {
            this.name = name;
            this.items.addAll(items);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.freezeCheck();
            this.name = name;
        }

        public List<String> getItems() {
            return this.freezeWrap(this.items);
        }

        public void setItems(List<String> items) {
            this.freezeCheck();
            this.items.clear();
            this.items.addAll(items);
        }

        public boolean getHasItems() {
            return !this.items.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            return this.asMap();
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.items);
            return map;
        }

        @Override
        public void merge(CaskItem source) {
            this.name = this.merge(this.name, source.name);
            this.setItems(this.merge(this.items, source.items));
        }
    }

    public static class Cask
    extends AbstractModelObject<Cask>
    implements Domain {
        private final List<CaskItem> uninstall = new ArrayList<CaskItem>();
        private final List<CaskItem> zap = new ArrayList<CaskItem>();
        protected Boolean enabled;
        private String name;
        private String displayName;
        private String pkgName;
        private String appName;
        private String appcast;
        @JsonIgnore
        private String cachedCaskName;
        @JsonIgnore
        private String cachedDisplayName;
        @JsonIgnore
        private String cachedAppName;
        @JsonIgnore
        private String cachedPkgName;

        @Override
        public void freeze() {
            super.freeze();
            this.uninstall.forEach(AbstractModelObject::freeze);
            this.zap.forEach(AbstractModelObject::freeze);
        }

        @Override
        public void merge(Cask cask) {
            this.freezeCheck();
            this.enabled = this.merge(this.enabled, cask.enabled);
            this.name = this.merge(this.name, cask.name);
            this.displayName = this.merge(this.displayName, cask.displayName);
            this.pkgName = this.merge(this.pkgName, cask.pkgName);
            this.appName = this.merge(this.appName, cask.appName);
            this.appcast = this.merge(this.appcast, cask.appcast);
            this.setUninstallItems(this.merge(this.uninstall, cask.uninstall));
            this.setZapItems(this.merge(this.zap, cask.zap));
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.freezeCheck();
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getResolvedAppcast(Map<String, Object> props) {
            if (StringUtils.isNotBlank((String)this.appcast)) {
                return Templates.resolveTemplate((String)this.appcast, props);
            }
            return this.appcast;
        }

        public String getResolvedCaskName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedCaskName)) {
                this.cachedCaskName = Templates.resolveTemplate((String)this.name, context.getModel().props());
                this.cachedCaskName = this.cachedCaskName.toLowerCase(Locale.ENGLISH);
            }
            return this.cachedCaskName;
        }

        public String getResolvedCaskName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedCaskName)) {
                this.cachedCaskName = Templates.resolveTemplate((String)this.name, props);
                this.cachedCaskName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedCaskName);
            } else if (this.cachedCaskName.contains("{{")) {
                this.cachedCaskName = Templates.resolveTemplate((String)this.cachedCaskName, props);
                this.cachedCaskName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedCaskName);
            }
            return this.cachedCaskName;
        }

        public String getResolvedDisplayName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedDisplayName)) {
                this.cachedDisplayName = Templates.resolveTemplate((String)this.displayName, context.getModel().props());
                this.cachedDisplayName = StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName);
            }
            return this.cachedDisplayName;
        }

        public String getResolvedDisplayName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedDisplayName)) {
                this.cachedDisplayName = Templates.resolveTemplate((String)this.displayName, props);
                this.cachedDisplayName = StringUtils.getNaturalName((String)StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName));
            } else if (this.cachedDisplayName.contains("{{")) {
                this.cachedDisplayName = Templates.resolveTemplate((String)this.cachedDisplayName, props);
                this.cachedDisplayName = StringUtils.getNaturalName((String)StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.cachedDisplayName));
            }
            return this.cachedDisplayName;
        }

        public String getResolvedAppName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedAppName)) {
                this.cachedAppName = Templates.resolveTemplate((String)this.appName, context.getModel().props());
            }
            return this.cachedAppName;
        }

        public String getResolvedAppName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedAppName)) {
                this.cachedAppName = Templates.resolveTemplate((String)this.appName, props);
            } else if (this.cachedAppName.contains("{{")) {
                this.cachedAppName = Templates.resolveTemplate((String)this.cachedAppName, props);
            }
            return this.cachedAppName;
        }

        public String getResolvedPkgName(JReleaserContext context) {
            if (StringUtils.isBlank((String)this.cachedPkgName)) {
                this.cachedPkgName = Templates.resolveTemplate((String)this.pkgName, context.getModel().props());
            }
            return this.cachedPkgName;
        }

        public String getResolvedPkgName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedPkgName)) {
                this.cachedPkgName = Templates.resolveTemplate((String)this.pkgName, props);
            } else if (this.cachedPkgName.contains("{{")) {
                this.cachedPkgName = Templates.resolveTemplate((String)this.cachedPkgName, props);
            }
            return this.cachedPkgName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.freezeCheck();
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.freezeCheck();
            this.displayName = displayName;
        }

        public String getPkgName() {
            return this.pkgName;
        }

        public void setPkgName(String pkgName) {
            this.freezeCheck();
            this.pkgName = pkgName;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.freezeCheck();
            this.appName = appName;
        }

        public String getAppcast() {
            return this.appcast;
        }

        public void setAppcast(String appcast) {
            this.freezeCheck();
            this.appcast = appcast;
        }

        public List<CaskItem> getUninstallItems() {
            return this.freezeWrap(this.uninstall);
        }

        void setUninstallItems(List<CaskItem> uninstall) {
            this.freezeCheck();
            this.uninstall.clear();
            this.uninstall.addAll(uninstall);
        }

        public void setUninstall(Map<String, List<String>> uninstall) {
            this.freezeCheck();
            this.uninstall.clear();
            uninstall.forEach((name, items) -> this.uninstall.add(new CaskItem((String)name, (List<String>)items)));
        }

        public void addUninstall(CaskItem item) {
            this.freezeCheck();
            if (null != item) {
                this.uninstall.add(item);
            }
        }

        public boolean getHasUninstall() {
            return !this.uninstall.isEmpty();
        }

        public List<CaskItem> getZapItems() {
            return this.freezeWrap(this.zap);
        }

        void setZapItems(List<CaskItem> zap) {
            this.freezeCheck();
            this.zap.clear();
            this.zap.addAll(zap);
        }

        public void setZap(Map<String, List<String>> zap) {
            this.freezeCheck();
            this.zap.clear();
            zap.forEach((name, items) -> this.zap.add(new CaskItem((String)name, (List<String>)items)));
        }

        public void addZap(CaskItem item) {
            this.freezeCheck();
            if (null != item) {
                this.zap.add(item);
            }
        }

        public boolean getHasZap() {
            return !this.zap.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("name", this.name);
            map.put("displayName", this.displayName);
            map.put("appName", this.appName);
            map.put("pkgName", this.pkgName);
            map.put("appcast", this.appcast);
            if (!this.uninstall.isEmpty()) {
                map.put("uninstall", this.uninstall.stream().map(CaskItem::asMap).collect(Collectors.toList()));
            }
            if (!this.zap.isEmpty()) {
                map.put("zap", this.zap.stream().map(CaskItem::asMap).collect(Collectors.toList()));
            }
            return map;
        }
    }

    public static class HomebrewTap
    extends AbstractRepositoryTap<HomebrewTap> {
        public HomebrewTap() {
            super("homebrew", "homebrew-tap");
        }
    }

    public static class Dependency {
        private final String key;
        private final String value;

        private Dependency(String key) {
            this(key, (String)null);
        }

        private Dependency(String key, String value) {
            this.key = key;
            this.value = StringUtils.isBlank((String)value) || "null".equalsIgnoreCase(value) ? null : value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder formatted = new StringBuilder();
            if (this.key.startsWith(":")) {
                formatted.append(this.key);
            } else {
                formatted.append("\"").append(this.key).append("\"");
            }
            if (StringUtils.isNotBlank((String)this.value)) {
                formatted.append(" => \"").append(this.value).append("\"");
            }
            return formatted.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

