/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Active;
import org.jreleaser.model.ExecutionEvent;
import org.jreleaser.model.Hook;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.util.Templates;

public class CommandHook
extends AbstractModelObject<CommandHook>
implements Hook {
    private final Hook.Filter filter = new Hook.Filter();
    protected Boolean continueOnError;
    private String cmd;
    private Active active;
    @JsonIgnore
    private boolean enabled;

    @Override
    public void freeze() {
        super.freeze();
        this.filter.freeze();
    }

    @Override
    public void merge(CommandHook source) {
        this.freezeCheck();
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.cmd = this.merge(this.cmd, source.cmd);
        this.continueOnError = this.merge(this.continueOnError, source.continueOnError);
        this.setFilter(source.filter);
    }

    public String getResolvedCmd(JReleaserContext context, ExecutionEvent event) {
        Map<String, Object> props = context.fullProps();
        props.put("event", event);
        return Templates.resolveTemplate((String)this.cmd, props);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Active.ALWAYS);
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public boolean isContinueOnError() {
        return this.continueOnError != null && this.continueOnError != false;
    }

    @Override
    public void setContinueOnError(Boolean continueOnError) {
        this.freezeCheck();
        this.continueOnError = continueOnError;
    }

    @Override
    public boolean isContinueOnErrorSet() {
        return this.continueOnError != null;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.freezeCheck();
        this.cmd = cmd;
    }

    @Override
    public Hook.Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Hook.Filter filter) {
        this.filter.merge(filter);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", (Object)this.active);
        map.put("continueOnError", this.isContinueOnError());
        Map<String, Object> filterAsMap = this.filter.asMap(full);
        if (full || !filterAsMap.isEmpty()) {
            map.put("filter", filterAsMap);
        }
        map.put("cmd", this.cmd);
        return map;
    }
}

