/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.CommandHook;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Project;
import org.jreleaser.util.Env;

public class CommandHooks
extends AbstractModelObject<CommandHooks>
implements Domain,
Activatable {
    private final List<CommandHook> before = new ArrayList<CommandHook>();
    private final List<CommandHook> success = new ArrayList<CommandHook>();
    private final List<CommandHook> failure = new ArrayList<CommandHook>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;

    @Override
    public void freeze() {
        super.freeze();
        this.before.forEach(CommandHook::freeze);
        this.success.forEach(CommandHook::freeze);
        this.failure.forEach(CommandHook::freeze);
    }

    @Override
    public void merge(CommandHooks source) {
        this.freezeCheck();
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setBefore(this.merge(this.before, source.before));
        this.setSuccess(this.merge(this.success, source.success));
        this.setFailure(this.merge(this.failure, source.failure));
    }

    public boolean isSet() {
        return !this.before.isEmpty() || !this.success.isEmpty() || !this.failure.isEmpty();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"hooks.command.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public List<CommandHook> getBefore() {
        return this.freezeWrap(this.before);
    }

    public void setBefore(List<CommandHook> before) {
        this.freezeCheck();
        this.before.clear();
        this.before.addAll(before);
    }

    public List<CommandHook> getSuccess() {
        return this.freezeWrap(this.success);
    }

    public void setSuccess(List<CommandHook> success) {
        this.freezeCheck();
        this.success.clear();
        this.success.addAll(success);
    }

    public List<CommandHook> getFailure() {
        return this.freezeWrap(this.failure);
    }

    public void setFailure(List<CommandHook> failure) {
        this.freezeCheck();
        this.failure.clear();
        this.failure.addAll(failure);
    }

    public void addBefore(CommandHook hook) {
        this.freezeCheck();
        if (null != hook) {
            this.before.add(hook);
        }
    }

    public void addSuccess(CommandHook hook) {
        this.freezeCheck();
        if (null != hook) {
            this.success.add(hook);
        }
    }

    public void addFailure(CommandHook hook) {
        this.freezeCheck();
        if (null != hook) {
            this.failure.add(hook);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", (Object)this.active);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (CommandHook hook : this.getBefore()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("before", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getSuccess()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("success", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getFailure()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("failure", m);
        return map;
    }
}

