/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class GoogleChat
extends AbstractAnnouncer<GoogleChat> {
    public static final String NAME = "googlechat";
    public static final String GOOGLE_CHAT_WEBHOOK = "GOOGLE_CHAT_WEBHOOK";
    private String webhook;
    private String message;
    private String messageTemplate;

    public GoogleChat() {
        super(NAME);
    }

    @Override
    public void merge(GoogleChat googleChat) {
        this.freezeCheck();
        super.merge(googleChat);
        this.webhook = this.merge(this.webhook, googleChat.webhook);
        this.message = this.merge(this.message, googleChat.message);
        this.messageTemplate = this.merge(this.messageTemplate, googleChat.messageTemplate);
    }

    @Override
    public String getPrefix() {
        return "googleChat";
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedWebhook() {
        return Env.env((String)GOOGLE_CHAT_WEBHOOK, (String)this.webhook);
    }

    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.freezeCheck();
        this.webhook = webhook;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.freezeCheck();
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.freezeCheck();
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("webhook", StringUtils.isNotBlank((String)this.getResolvedWebhook()) ? "************" : "**unset**");
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

