/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Jlink
extends AbstractJavaAssembler<Jlink> {
    public static final String TYPE = "jlink";
    private final Set<Artifact> targetJdks = new LinkedHashSet<Artifact>();
    private final Set<String> moduleNames = new LinkedHashSet<String>();
    private final Set<String> additionalModuleNames = new LinkedHashSet<String>();
    private final List<String> args = new ArrayList<String>();
    private final Artifact jdk = new Artifact();
    private final Jdeps jdeps = new Jdeps();
    private String imageName;
    private String imageNameTransform;
    private Boolean copyJars;

    public Jlink() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.JLINK;
    }

    @Override
    public void freeze() {
        super.freeze();
        this.targetJdks.forEach(AbstractModelObject::freeze);
        this.jdk.freeze();
        this.jdeps.freeze();
    }

    @Override
    public void merge(Jlink jlink) {
        this.freezeCheck();
        super.merge(jlink);
        this.imageName = this.merge(this.imageName, jlink.imageName);
        this.imageNameTransform = this.merge(this.imageNameTransform, jlink.imageNameTransform);
        this.copyJars = this.merge(this.copyJars, jlink.copyJars);
        this.setJdeps(jlink.jdeps);
        this.setJdk(jlink.jdk);
        this.setTargetJdks(this.merge(this.targetJdks, jlink.targetJdks));
        this.setModuleNames(this.merge(this.moduleNames, jlink.moduleNames));
        this.setAdditionalModuleNames(this.merge(this.additionalModuleNames, jlink.additionalModuleNames));
        this.setArgs(this.merge(this.args, jlink.args));
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageNameTransform, props);
    }

    public Jdeps getJdeps() {
        return this.jdeps;
    }

    public void setJdeps(Jdeps jdeps) {
        this.jdeps.merge(jdeps);
    }

    public Artifact getJdk() {
        return this.jdk;
    }

    public void setJdk(Artifact jdk) {
        this.jdk.merge(jdk);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.freezeCheck();
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.freezeCheck();
        this.imageNameTransform = imageNameTransform;
    }

    public Set<Artifact> getTargetJdks() {
        return this.freezeWrap(Artifact.sortArtifacts(this.targetJdks));
    }

    public void setTargetJdks(Set<Artifact> targetJdks) {
        this.freezeCheck();
        this.targetJdks.clear();
        this.targetJdks.addAll(targetJdks);
    }

    public void addTargetJdk(Artifact jdk) {
        this.freezeCheck();
        if (null != jdk) {
            this.targetJdks.add(jdk);
        }
    }

    public Set<String> getModuleNames() {
        return this.freezeWrap(this.moduleNames);
    }

    public void setModuleNames(Set<String> moduleNames) {
        this.freezeCheck();
        this.moduleNames.clear();
        this.moduleNames.addAll(moduleNames);
    }

    public Set<String> getAdditionalModuleNames() {
        return this.freezeWrap(this.additionalModuleNames);
    }

    public void setAdditionalModuleNames(Set<String> additionalModuleNames) {
        this.freezeCheck();
        this.additionalModuleNames.clear();
        this.additionalModuleNames.addAll(additionalModuleNames);
    }

    public List<String> getArgs() {
        return this.freezeWrap(this.args);
    }

    public void setArgs(List<String> args) {
        this.freezeCheck();
        this.args.clear();
        this.args.addAll(args);
    }

    public Boolean isCopyJars() {
        return this.copyJars == null || this.copyJars != false;
    }

    public void setCopyJars(Boolean copyJars) {
        this.freezeCheck();
        this.copyJars = copyJars;
    }

    public boolean isCopyJarsSet() {
        return this.copyJars != null;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("moduleNames", this.moduleNames);
        props.put("additionalModuleNames", this.additionalModuleNames);
        props.put("args", this.args);
        props.put("jdeps", this.jdeps.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact targetJdk : this.getTargetJdks()) {
            mappedJdks.put("jdk " + i++, targetJdk.asMap(full));
        }
        props.put("jdk", this.jdk.asMap(full));
        props.put("targetJdks", mappedJdks);
        props.put("copyJars", this.isCopyJars());
    }

    public static class Jdeps
    extends AbstractModelObject<Jdeps>
    implements Domain,
    EnabledAware {
        private final Set<String> targets = new LinkedHashSet<String>();
        private String multiRelease;
        private Boolean ignoreMissingDeps;
        private Boolean useWildcardInPath;
        private Boolean enabled;

        @Override
        public void merge(Jdeps jdeps) {
            this.freezeCheck();
            this.multiRelease = this.merge(this.multiRelease, jdeps.multiRelease);
            this.ignoreMissingDeps = this.merge(this.ignoreMissingDeps, jdeps.ignoreMissingDeps);
            this.useWildcardInPath = this.merge(this.useWildcardInPath, jdeps.useWildcardInPath);
            this.enabled = this.merge(this.enabled, jdeps.enabled);
            this.setTargets(this.merge(this.targets, jdeps.targets));
        }

        public String getMultiRelease() {
            return this.multiRelease;
        }

        public void setMultiRelease(String multiRelease) {
            this.freezeCheck();
            this.multiRelease = multiRelease;
        }

        public Boolean isIgnoreMissingDeps() {
            return this.ignoreMissingDeps != null && this.ignoreMissingDeps != false;
        }

        public void setIgnoreMissingDeps(Boolean ignoreMissingDeps) {
            this.freezeCheck();
            this.ignoreMissingDeps = ignoreMissingDeps;
        }

        public boolean isIgnoreMissingDepsSet() {
            return this.ignoreMissingDeps != null;
        }

        public Boolean isUseWildcardInPath() {
            return this.useWildcardInPath == null || this.useWildcardInPath != false;
        }

        public void setUseWildcardInPath(Boolean useWildcardInPath) {
            this.freezeCheck();
            this.useWildcardInPath = useWildcardInPath;
        }

        public boolean isUseWildcardInPathSet() {
            return this.useWildcardInPath != null;
        }

        public Set<String> getTargets() {
            return this.freezeWrap(this.targets);
        }

        public void setTargets(Set<String> targets) {
            this.freezeCheck();
            this.targets.clear();
            this.targets.addAll(targets);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.freezeCheck();
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("multiRelease", this.multiRelease);
            props.put("ignoreMissingDeps", this.isIgnoreMissingDeps());
            props.put("useWildcardInPath", this.isUseWildcardInPath());
            props.put("targets", this.targets);
            return props;
        }
    }
}

