/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.github.mustachejava.TemplateFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.Icon;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Java;
import org.jreleaser.model.ModelObject;
import org.jreleaser.model.Screenshot;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.VersionPattern;
import org.jreleaser.util.CalVer;
import org.jreleaser.util.ChronVer;
import org.jreleaser.util.CustomVersion;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserOutput;
import org.jreleaser.util.JavaModuleVersion;
import org.jreleaser.util.JavaRuntimeVersion;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.SemVer;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;
import org.jreleaser.util.Version;

public class Project
extends AbstractModelObject<Project>
implements Domain,
ExtraProperties {
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJECT_VERSION = "PROJECT_VERSION";
    public static final String PROJECT_VERSION_PATTERN = "PROJECT_VERSION_PATTERN";
    public static final String PROJECT_SNAPSHOT_PATTERN = "PROJECT_SNAPSHOT_PATTERN";
    public static final String PROJECT_SNAPSHOT_LABEL = "PROJECT_SNAPSHOT_LABEL";
    public static final String PROJECT_SNAPSHOT_FULL_CHANGELOG = "PROJECT_SNAPSHOT_FULL_CHANGELOG";
    public static final String DEFAULT_SNAPSHOT_PATTERN = ".*-SNAPSHOT";
    public static final String DEFAULT_SNAPSHOT_LABEL = "early-access";
    private final List<String> authors = new ArrayList<String>();
    private final List<String> tags = new ArrayList<String>();
    private final List<String> maintainers = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Links links = new Links();
    private final Java java = new Java();
    private final Snapshot snapshot = new Snapshot();
    private final List<Screenshot> screenshots = new ArrayList<Screenshot>();
    private final List<Icon> icons = new ArrayList<Icon>();
    private String name;
    private String version;
    private VersionPattern versionPattern = new VersionPattern();
    private String description;
    private String longDescription;
    private String license;
    private String inceptionYear;
    private String copyright;
    private String vendor;
    private Stereotype stereotype = Stereotype.NONE;

    @Override
    public void freeze() {
        super.freeze();
        this.links.freeze();
        this.java.freeze();
        this.snapshot.freeze();
        this.versionPattern.freeze();
        this.screenshots.forEach(ModelObject::freeze);
        this.icons.forEach(ModelObject::freeze);
    }

    @Override
    public void merge(Project project) {
        this.freezeCheck();
        this.name = this.merge(this.name, project.name);
        this.version = this.merge(this.version, project.version);
        this.versionPattern = this.merge(this.versionPattern, project.versionPattern);
        this.description = this.merge(this.description, project.description);
        this.longDescription = this.merge(this.longDescription, project.longDescription);
        this.license = this.merge(this.license, project.license);
        this.inceptionYear = this.merge(this.inceptionYear, project.inceptionYear);
        this.copyright = this.merge(this.copyright, project.copyright);
        this.vendor = this.merge(this.vendor, project.vendor);
        this.stereotype = this.merge(this.stereotype, project.stereotype);
        this.setJava(project.java);
        this.setSnapshot(project.snapshot);
        this.setAuthors(this.merge(this.authors, project.authors));
        this.setTags(this.merge(this.tags, project.tags));
        this.setMaintainers(this.merge(this.maintainers, project.maintainers));
        this.setExtraProperties(this.merge(this.extraProperties, project.extraProperties));
        this.setLinks(project.links);
        this.setScreenshots(this.merge(this.screenshots, project.screenshots));
        this.setIcons(this.merge(this.icons, project.icons));
    }

    @Override
    public String getPrefix() {
        return "project";
    }

    public String getEffectiveVersion() {
        if (this.isSnapshot()) {
            return this.getSnapshot().getEffectiveLabel();
        }
        return this.getResolvedVersion();
    }

    public boolean isSnapshot() {
        return this.snapshot.isSnapshot(this.getResolvedVersion());
    }

    public boolean isRelease() {
        return !this.isSnapshot();
    }

    public String getResolvedName() {
        return Env.env((String)PROJECT_NAME, (String)this.name);
    }

    public String getResolvedVersion() {
        String resolvedVersion = Env.env((String)PROJECT_VERSION, (String)this.version);
        return StringUtils.isNotBlank((String)resolvedVersion) ? resolvedVersion : "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.freezeCheck();
        this.version = version;
    }

    public String getVersionPattern() {
        return this.versionPattern != null ? this.versionPattern.toString() : "";
    }

    public void setVersionPattern(VersionPattern versionPattern) {
        this.versionPattern.merge(versionPattern);
    }

    public void setVersionPattern(String str) {
        this.setVersionPattern(VersionPattern.of(str));
    }

    public VersionPattern versionPattern() {
        return this.versionPattern;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot.merge(snapshot);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.freezeCheck();
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.freezeCheck();
        this.longDescription = longDescription;
    }

    @Deprecated
    public String getWebsite() {
        return this.links.getHomepage();
    }

    @Deprecated
    public void setWebsite(String website) {
        JReleaserOutput.nag((String)"project.website is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.homepage instead");
        this.links.setHomepage(website);
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.freezeCheck();
        this.license = license;
    }

    @Deprecated
    public String getLicenseUrl() {
        return this.links.getLicense();
    }

    @Deprecated
    public void setLicenseUrl(String licenseUrl) {
        JReleaserOutput.nag((String)"project.licenseUrl is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.license instead");
        this.links.setLicense(licenseUrl);
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public void setInceptionYear(String inceptionYear) {
        this.freezeCheck();
        this.inceptionYear = inceptionYear;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.freezeCheck();
        this.copyright = copyright;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.freezeCheck();
        this.vendor = vendor;
    }

    @Deprecated
    public String getDocsUrl() {
        return this.links.getDocumentation();
    }

    @Deprecated
    public void setDocsUrl(String docsUrl) {
        JReleaserOutput.nag((String)"project.docsUrl is deprecated since 1.2.0 and will be removed in 2.0.0. Use project.links.documentation instead");
        this.links.setDocumentation(docsUrl);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.freezeCheck();
        this.stereotype = stereotype;
    }

    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of(str));
    }

    public List<Screenshot> getScreenshots() {
        return this.freezeWrap(this.screenshots);
    }

    public void setScreenshots(List<Screenshot> screenshots) {
        this.freezeCheck();
        this.screenshots.clear();
        this.screenshots.addAll(screenshots);
    }

    public void addScreenshot(Screenshot screenshot) {
        this.freezeCheck();
        if (null != screenshot) {
            this.screenshots.add(screenshot);
        }
    }

    public List<Icon> getIcons() {
        return this.freezeWrap(this.icons);
    }

    public void setIcons(List<Icon> icons) {
        this.freezeCheck();
        this.icons.clear();
        this.icons.addAll(icons);
    }

    public void addIcon(Icon icon) {
        this.freezeCheck();
        if (null != icon) {
            this.icons.add(icon);
        }
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.merge(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    public List<String> getAuthors() {
        return this.freezeWrap(this.authors);
    }

    public void setAuthors(List<String> authors) {
        this.freezeCheck();
        this.authors.clear();
        this.authors.addAll(authors);
    }

    public List<String> getTags() {
        return this.freezeWrap(this.tags);
    }

    public void setTags(List<String> tags) {
        this.freezeCheck();
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public List<String> getMaintainers() {
        return this.freezeWrap(this.maintainers);
    }

    public void setMaintainers(List<String> maintainers) {
        this.freezeCheck();
        this.maintainers.clear();
        this.maintainers.addAll(maintainers);
    }

    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links.merge(links);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("version", this.version);
        map.put("versionPattern", this.versionPattern);
        map.put("snapshot", this.snapshot.asMap(full));
        map.put("description", this.description);
        map.put("longDescription", this.longDescription);
        map.put("license", this.license);
        map.put("inceptionYear", this.inceptionYear);
        map.put("copyright", this.copyright);
        map.put("vendor", this.vendor);
        map.put("authors", this.authors);
        map.put("tags", this.tags);
        map.put("maintainers", this.maintainers);
        map.put("stereotype", (Object)this.stereotype);
        map.put("links", this.links.asMap(full));
        LinkedHashMap<String, Map<String, Object>> sm = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Screenshot screenshot : this.screenshots) {
            sm.put("screenshot " + i++, screenshot.asMap(full));
        }
        map.put("screenshots", sm);
        sm = new LinkedHashMap();
        i = 0;
        for (Icon icon : this.icons) {
            sm.put("icon " + i++, icon.asMap(full));
        }
        map.put("icons", sm);
        map.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            map.put("java", this.java.asMap(full));
        }
        return map;
    }

    public void parseVersion() {
        boolean isFrozen = this.frozen;
        try {
            this.frozen = false;
            this.doParseVersion();
        }
        finally {
            this.frozen = isFrozen;
        }
    }

    private void doParseVersion() {
        String v = this.getResolvedVersion();
        if (StringUtils.isBlank((String)v)) {
            return;
        }
        switch (this.versionPattern().getType()) {
            case SEMVER: {
                SemVer parsedVersion;
                try {
                    parsedVersion = SemVer.of((String)v);
                    StringBuilder vn = new StringBuilder().append(parsedVersion.getMajor());
                    this.addExtraProperty("versionMajor", parsedVersion.getMajor());
                    if (parsedVersion.hasMinor()) {
                        vn.append(".").append(parsedVersion.getMinor());
                        this.addExtraProperty("versionMinor", parsedVersion.getMinor());
                    }
                    if (parsedVersion.hasPatch()) {
                        vn.append(".").append(parsedVersion.getPatch());
                        this.addExtraProperty("versionPatch", parsedVersion.getPatch());
                    }
                    this.addExtraProperty("versionNumber", vn.toString());
                    if (parsedVersion.hasTag()) {
                        this.addExtraProperty("versionTag", parsedVersion.getTag());
                    }
                    if (!parsedVersion.hasBuild()) break;
                    this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "semver"}), (Throwable)e);
                }
            }
            case JAVA_RUNTIME: {
                SemVer parsedVersion;
                try {
                    parsedVersion = JavaRuntimeVersion.of((String)v);
                    this.addExtraProperty("versionNumber", parsedVersion.getVersion());
                    if (parsedVersion.hasPrerelease()) {
                        this.addExtraProperty("versionPrerelease", parsedVersion.getPrerelease());
                    }
                    if (parsedVersion.hasBuild()) {
                        this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    }
                    if (!parsedVersion.hasOptional()) break;
                    this.addExtraProperty("versionOptional", parsedVersion.getOptional());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "Java runtime"}), (Throwable)e);
                }
            }
            case JAVA_MODULE: {
                SemVer parsedVersion;
                try {
                    parsedVersion = JavaModuleVersion.of((String)v);
                    this.addExtraProperty("versionNumber", parsedVersion.getVersion());
                    if (parsedVersion.hasPrerelease()) {
                        this.addExtraProperty("versionPrerelease", parsedVersion.getPrerelease());
                    }
                    if (!parsedVersion.hasBuild()) break;
                    this.addExtraProperty("versionBuild", parsedVersion.getBuild());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "Java module"}), (Throwable)e);
                }
            }
            case CALVER: {
                SemVer parsedVersion;
                try {
                    parsedVersion = CalVer.of((String)this.versionPattern().getFormat(), (String)v);
                    this.addExtraProperty("versionNumber", v);
                    this.addExtraProperty("versionYear", parsedVersion.getYear());
                    if (parsedVersion.hasMonth()) {
                        this.addExtraProperty("versionMonth", parsedVersion.getMonth());
                    }
                    if (parsedVersion.hasDay()) {
                        this.addExtraProperty("versionDay", parsedVersion.getDay());
                    }
                    if (parsedVersion.hasWeek()) {
                        this.addExtraProperty("versionWeek", parsedVersion.getWeek());
                    }
                    if (parsedVersion.hasMinor()) {
                        this.addExtraProperty("versionMinor", parsedVersion.getMinor());
                    }
                    if (parsedVersion.hasMicro()) {
                        this.addExtraProperty("versionMicro", parsedVersion.getMicro());
                    }
                    if (!parsedVersion.hasModifier()) break;
                    this.addExtraProperty("versionModifier", parsedVersion.getModifier());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "calver"}), (Throwable)e);
                }
            }
            case CHRONVER: {
                SemVer parsedVersion;
                try {
                    parsedVersion = ChronVer.of((String)v);
                    this.addExtraProperty("versionNumber", v);
                    this.addExtraProperty("versionYear", parsedVersion.getYear());
                    this.addExtraProperty("versionMonth", parsedVersion.getMonth());
                    this.addExtraProperty("versionDay", parsedVersion.getDay());
                    if (!parsedVersion.hasChangeset()) break;
                    this.addExtraProperty("versionModifier", parsedVersion.getChangeset().toString());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_version_invalid", (Object[])new Object[]{v, "chronver"}), (Throwable)e);
                }
            }
            default: {
                this.addExtraProperty("versionNumber", v);
            }
        }
        String vn = (String)this.getExtraProperties().get("versionNumber");
        String ev = this.getEffectiveVersion();
        this.addExtraProperty("versionWithUnderscores", new MustacheUtils.UnderscoreFunction().apply(v));
        this.addExtraProperty("versionWithDashes", new MustacheUtils.DashFunction().apply(v));
        this.addExtraProperty("versionNumberWithUnderscores", new MustacheUtils.UnderscoreFunction().apply(vn));
        this.addExtraProperty("versionNumberWithDashes", new MustacheUtils.DashFunction().apply(vn));
        if (StringUtils.isNotBlank((String)ev)) {
            this.addExtraProperty("effectiveVersionWithUnderscores", new MustacheUtils.UnderscoreFunction().apply(ev));
            this.addExtraProperty("effectiveVersionWithDashes", new MustacheUtils.DashFunction().apply(ev));
        }
    }

    public Version<?> version() {
        String v = this.getResolvedVersion();
        switch (this.versionPattern().getType()) {
            case SEMVER: {
                return SemVer.of((String)v);
            }
            case JAVA_RUNTIME: {
                return JavaRuntimeVersion.of((String)v);
            }
            case JAVA_MODULE: {
                return JavaModuleVersion.of((String)v);
            }
            case CALVER: {
                return CalVer.of((String)this.versionPattern().getFormat(), (String)v);
            }
            case CHRONVER: {
                return ChronVer.of((String)v);
            }
        }
        return CustomVersion.of((String)v);
    }

    public static class Links
    extends AbstractModelObject<Links>
    implements Domain {
        private static final String PROJECT_LINK = "projectLink";
        private String homepage;
        private String documentation;
        private String license;
        private String bugTracker;
        private String faq;
        private String help;
        private String donation;
        private String translate;
        private String contact;
        private String vcsBrowser;
        private String contribute;

        @Override
        public void merge(Links source) {
            this.freezeCheck();
            this.homepage = this.merge(this.homepage, source.homepage);
            this.documentation = this.merge(this.documentation, source.documentation);
            this.license = this.merge(this.license, source.license);
            this.bugTracker = this.merge(this.bugTracker, source.bugTracker);
            this.faq = this.merge(this.faq, source.faq);
            this.help = this.merge(this.help, source.help);
            this.donation = this.merge(this.donation, source.donation);
            this.translate = this.merge(this.translate, source.translate);
            this.contact = this.merge(this.contact, source.contact);
            this.vcsBrowser = this.merge(this.vcsBrowser, source.vcsBrowser);
            this.contribute = this.merge(this.contribute, source.contribute);
        }

        public String getHomepage() {
            return this.homepage;
        }

        public void setHomepage(String homepage) {
            this.freezeCheck();
            this.homepage = homepage;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public void setDocumentation(String documentation) {
            this.freezeCheck();
            this.documentation = documentation;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.freezeCheck();
            this.license = license;
        }

        public String getBugTracker() {
            return this.bugTracker;
        }

        public void setBugTracker(String bugTracker) {
            this.freezeCheck();
            this.bugTracker = bugTracker;
        }

        public String getFaq() {
            return this.faq;
        }

        public void setFaq(String faq) {
            this.freezeCheck();
            this.faq = faq;
        }

        public String getHelp() {
            return this.help;
        }

        public void setHelp(String help) {
            this.freezeCheck();
            this.help = help;
        }

        public String getDonation() {
            return this.donation;
        }

        public void setDonation(String donation) {
            this.freezeCheck();
            this.donation = donation;
        }

        public String getTranslate() {
            return this.translate;
        }

        public void setTranslate(String translate) {
            this.freezeCheck();
            this.translate = translate;
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.freezeCheck();
            this.contact = contact;
        }

        public String getVcsBrowser() {
            return this.vcsBrowser;
        }

        public void setVcsBrowser(String vcsBrowser) {
            this.freezeCheck();
            this.vcsBrowser = vcsBrowser;
        }

        public String getContribute() {
            return this.contribute;
        }

        public void setContribute(String contribute) {
            this.freezeCheck();
            this.contribute = contribute;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (StringUtils.isNotBlank((String)this.homepage)) {
                map.put("homepage", this.homepage);
            }
            if (StringUtils.isNotBlank((String)this.documentation)) {
                map.put("documentation", this.documentation);
            }
            if (StringUtils.isNotBlank((String)this.license)) {
                map.put("license", this.license);
            }
            if (StringUtils.isNotBlank((String)this.bugTracker)) {
                map.put("bugTracker", this.bugTracker);
            }
            if (StringUtils.isNotBlank((String)this.vcsBrowser)) {
                map.put("vcsBrowser", this.vcsBrowser);
            }
            if (StringUtils.isNotBlank((String)this.faq)) {
                map.put("faq", this.faq);
            }
            if (StringUtils.isNotBlank((String)this.help)) {
                map.put("help", this.help);
            }
            if (StringUtils.isNotBlank((String)this.donation)) {
                map.put("donation", this.donation);
            }
            if (StringUtils.isNotBlank((String)this.translate)) {
                map.put("translate", this.translate);
            }
            if (StringUtils.isNotBlank((String)this.contact)) {
                map.put("contact", this.contact);
            }
            if (StringUtils.isNotBlank((String)this.contribute)) {
                map.put("contribute", this.contribute);
            }
            return map;
        }

        public void fillProps(Map<String, Object> props) {
            if (StringUtils.isNotBlank((String)this.homepage)) {
                props.put("projectLinkHomepage", this.homepage);
            }
            if (StringUtils.isNotBlank((String)this.documentation)) {
                props.put("projectLinkDocumentation", this.documentation);
            }
            if (StringUtils.isNotBlank((String)this.license)) {
                props.put("projectLinkLicense", this.license);
            }
            if (StringUtils.isNotBlank((String)this.bugTracker)) {
                props.put("projectLinkBugTracker", this.bugTracker);
            }
            if (StringUtils.isNotBlank((String)this.vcsBrowser)) {
                props.put("projectLinkVcsBrowser", this.vcsBrowser);
            }
            if (StringUtils.isNotBlank((String)this.faq)) {
                props.put("projectLinkFaq", this.faq);
            }
            if (StringUtils.isNotBlank((String)this.help)) {
                props.put("projectLinkHelp", this.help);
            }
            if (StringUtils.isNotBlank((String)this.donation)) {
                props.put("projectLinkDonation", this.donation);
            }
            if (StringUtils.isNotBlank((String)this.translate)) {
                props.put("projectLinktranslate", this.translate);
            }
            if (StringUtils.isNotBlank((String)this.contact)) {
                props.put("projectLinkcontact", this.contact);
            }
            if (StringUtils.isNotBlank((String)this.contribute)) {
                props.put("projectLinkcontribute", this.contribute);
            }
            if (StringUtils.isNotBlank((String)this.homepage)) {
                props.put("projectWebsite", this.homepage);
            }
            if (StringUtils.isNotBlank((String)this.documentation)) {
                props.put("projectDocsUrl", this.documentation);
            }
            if (StringUtils.isNotBlank((String)this.license)) {
                props.put("projectLicenseUrl", this.license);
            }
        }

        public Collection<LinkTemplate> asLinkTemplates() {
            ArrayList<LinkTemplate> links = new ArrayList<LinkTemplate>();
            if (StringUtils.isNotBlank((String)this.homepage)) {
                links.add(new LinkTemplate("homepage", this.homepage));
            }
            if (StringUtils.isNotBlank((String)this.bugTracker)) {
                links.add(new LinkTemplate("bugtracker", this.bugTracker));
            }
            if (StringUtils.isNotBlank((String)this.faq)) {
                links.add(new LinkTemplate("faq", this.faq));
            }
            if (StringUtils.isNotBlank((String)this.help)) {
                links.add(new LinkTemplate("help", this.help));
            }
            if (StringUtils.isNotBlank((String)this.donation)) {
                links.add(new LinkTemplate("donation", this.donation));
            }
            if (StringUtils.isNotBlank((String)this.translate)) {
                links.add(new LinkTemplate("translate", this.translate));
            }
            if (StringUtils.isNotBlank((String)this.contact)) {
                links.add(new LinkTemplate("contact", this.contact));
            }
            if (StringUtils.isNotBlank((String)this.vcsBrowser)) {
                links.add(new LinkTemplate("vcs-browser", this.vcsBrowser));
            }
            if (StringUtils.isNotBlank((String)this.contribute)) {
                links.add(new LinkTemplate("contribute", this.contribute));
            }
            return links;
        }

        public static final class LinkTemplate {
            private String type;
            private String url;

            public LinkTemplate(String type, String url) {
                this.type = type;
                this.url = url;
            }

            public String getType() {
                return this.type;
            }

            public TemplateFunction getUrl() {
                return s -> this.url;
            }
        }
    }

    public static class Snapshot
    extends AbstractModelObject<Snapshot>
    implements Domain {
        private Boolean enabled;
        private String pattern;
        private String label;
        private Boolean fullChangelog;
        private String cachedLabel;

        @Override
        public void merge(Snapshot snapshot) {
            this.freezeCheck();
            this.enabled = this.merge(this.enabled, snapshot.enabled);
            this.pattern = this.merge(this.pattern, snapshot.pattern);
            this.label = this.merge(this.label, snapshot.label);
            this.fullChangelog = this.merge(this.fullChangelog, snapshot.fullChangelog);
        }

        public boolean isSnapshot(String version) {
            if (null == this.enabled) {
                this.enabled = version.matches(this.getResolvedPattern());
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.env((String)Project.PROJECT_SNAPSHOT_PATTERN, (String)this.pattern);
        }

        public String getResolvedPattern() {
            this.pattern = this.getConfiguredPattern();
            if (StringUtils.isBlank((String)this.pattern)) {
                this.pattern = Project.DEFAULT_SNAPSHOT_PATTERN;
            }
            return this.pattern;
        }

        public String getConfiguredLabel() {
            return Env.env((String)Project.PROJECT_SNAPSHOT_LABEL, (String)this.label);
        }

        public String getResolvedLabel(JReleaserModel model) {
            if (StringUtils.isBlank((String)this.cachedLabel)) {
                this.cachedLabel = this.getConfiguredLabel();
            }
            if (StringUtils.isBlank((String)this.cachedLabel)) {
                this.cachedLabel = Templates.resolveTemplate((String)this.label, this.props(model));
            } else if (this.cachedLabel.contains("{{")) {
                this.cachedLabel = Templates.resolveTemplate((String)this.cachedLabel, this.props(model));
            }
            return this.cachedLabel;
        }

        public String getEffectiveLabel() {
            return this.cachedLabel;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.freezeCheck();
            this.pattern = pattern;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.freezeCheck();
            this.label = label;
        }

        public Boolean getFullChangelog() {
            return this.fullChangelog;
        }

        public boolean isFullChangelog() {
            return this.fullChangelog != null && this.fullChangelog != false;
        }

        public void setFullChangelog(Boolean fullChangelog) {
            this.freezeCheck();
            this.fullChangelog = fullChangelog;
        }

        public boolean isFullChangelogSet() {
            return this.fullChangelog != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.enabled);
            map.put("pattern", this.getConfiguredPattern());
            map.put("label", this.getConfiguredLabel());
            map.put("fullChangelog", this.isFullChangelog());
            return map;
        }

        public Map<String, Object> props(JReleaserModel model) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            Project project = model.getProject();
            props.putAll(model.getEnvironment().getProperties());
            props.putAll(model.getEnvironment().getSourcedProperties());
            props.put("projectName", project.getName());
            props.put("projectNameCapitalized", StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)project.getName()));
            props.put("projectStereotype", (Object)project.getStereotype());
            props.put("projectVersion", project.getVersion());
            props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
            if (StringUtils.isNotBlank((String)project.getDescription())) {
                props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
            }
            if (StringUtils.isNotBlank((String)project.getLongDescription())) {
                props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
            }
            if (StringUtils.isNotBlank((String)project.getLicense())) {
                props.put("projectLicense", project.getLicense());
            }
            if (null != project.getInceptionYear()) {
                props.put("projectInceptionYear", project.getInceptionYear());
            }
            if (StringUtils.isNotBlank((String)project.getCopyright())) {
                props.put("projectCopyright", project.getCopyright());
            }
            if (StringUtils.isNotBlank((String)project.getVendor())) {
                props.put("projectVendor", project.getVendor());
            }
            project.getLinks().fillProps(props);
            if (project.getJava().isEnabled()) {
                props.putAll(project.getJava().getResolvedExtraProperties());
                props.put("projectJavaGroupId", project.getJava().getGroupId());
                props.put("projectJavaArtifactId", project.getJava().getArtifactId());
                props.put("projectJavaVersion", project.getJava().getVersion());
                props.put("projectJavaMainClass", project.getJava().getMainClass());
                SemVer jv = SemVer.of((String)project.getJava().getVersion());
                props.put("projectJavaVersionMajor", jv.getMajor());
                if (jv.hasMinor()) {
                    props.put("projectJavaVersionMinor", jv.getMinor());
                }
                if (jv.hasPatch()) {
                    props.put("projectJavaVersionPatch", jv.getPatch());
                }
                if (jv.hasTag()) {
                    props.put("projectJavaVersionTag", jv.getTag());
                }
                if (jv.hasBuild()) {
                    props.put("projectJavaVersionBuild", jv.getBuild());
                }
            }
            project.parseVersion();
            props.putAll(project.getResolvedExtraProperties());
            String osName = PlatformUtils.getDetectedOs();
            String osArch = PlatformUtils.getDetectedArch();
            props.put("osName", osName);
            props.put("osArch", osArch);
            props.put("osVersion", PlatformUtils.getDetectedVersion());
            props.put("osPlatform", PlatformUtils.getCurrentFull());
            props.put("osPlatformReplaced", model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
            MustacheUtils.applyTemplates(props, project.getResolvedExtraProperties());
            props.put("__ZonedDateTime_now__", model.getNow());
            MustacheUtils.applyFunctions(props);
            return props;
        }
    }
}

