/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Artifactory;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.FtpUploader;
import org.jreleaser.model.GiteaUploader;
import org.jreleaser.model.GitlabUploader;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.ModelObject;
import org.jreleaser.model.Project;
import org.jreleaser.model.S3;
import org.jreleaser.model.ScpUploader;
import org.jreleaser.model.SftpUploader;
import org.jreleaser.model.Uploader;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserOutput;
import org.jreleaser.util.StringUtils;

public class Upload
extends AbstractModelObject<Upload>
implements Domain,
Activatable {
    private final Map<String, Artifactory> artifactory = new LinkedHashMap<String, Artifactory>();
    private final Map<String, FtpUploader> ftp = new LinkedHashMap<String, FtpUploader>();
    private final Map<String, GiteaUploader> gitea = new LinkedHashMap<String, GiteaUploader>();
    private final Map<String, GitlabUploader> gitlab = new LinkedHashMap<String, GitlabUploader>();
    private final Map<String, HttpUploader> http = new LinkedHashMap<String, HttpUploader>();
    private final Map<String, S3> s3 = new LinkedHashMap<String, S3>();
    private final Map<String, ScpUploader> scp = new LinkedHashMap<String, ScpUploader>();
    private final Map<String, SftpUploader> sftp = new LinkedHashMap<String, SftpUploader>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;

    @Override
    public void freeze() {
        super.freeze();
        this.artifactory.values().forEach(ModelObject::freeze);
        this.ftp.values().forEach(ModelObject::freeze);
        this.gitea.values().forEach(ModelObject::freeze);
        this.gitlab.values().forEach(ModelObject::freeze);
        this.http.values().forEach(ModelObject::freeze);
        this.s3.values().forEach(ModelObject::freeze);
        this.scp.values().forEach(ModelObject::freeze);
        this.sftp.values().forEach(ModelObject::freeze);
    }

    @Override
    public void merge(Upload upload) {
        this.freezeCheck();
        this.active = this.merge(this.active, upload.active);
        this.enabled = this.merge(this.enabled, upload.enabled);
        this.setArtifactory(this.mergeModel(this.artifactory, upload.artifactory));
        this.setFtp(this.mergeModel(this.ftp, upload.ftp));
        this.setGitea(this.mergeModel(this.gitea, upload.gitea));
        this.setGitlab(this.mergeModel(this.gitlab, upload.gitlab));
        this.setHttp(this.mergeModel(this.http, upload.http));
        this.setS3(this.mergeModel(this.s3, upload.s3));
        this.setScp(this.mergeModel(this.scp, upload.scp));
        this.setSftp(this.mergeModel(this.sftp, upload.sftp));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.active != null;
    }

    @Deprecated
    public void setEnabled(Boolean enabled) {
        JReleaserOutput.nag((String)"upload.enabled is deprecated since 1.1.0 and will be removed in 2.0.0");
        this.freezeCheck();
        if (null != enabled) {
            this.active = enabled != false ? Active.ALWAYS : Active.NEVER;
        }
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"upload.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public Optional<? extends Uploader> getUploader(String type, String name) {
        switch (type) {
            case "artifactory": {
                return Optional.ofNullable(this.artifactory.get(name));
            }
            case "ftp": {
                return Optional.ofNullable(this.ftp.get(name));
            }
            case "gitea": {
                return Optional.ofNullable(this.gitea.get(name));
            }
            case "gitlab": {
                return Optional.ofNullable(this.gitlab.get(name));
            }
            case "http": {
                return Optional.ofNullable(this.http.get(name));
            }
            case "s3": {
                return Optional.ofNullable(this.s3.get(name));
            }
            case "scp": {
                return Optional.ofNullable(this.scp.get(name));
            }
            case "sftp": {
                return Optional.ofNullable(this.sftp.get(name));
            }
        }
        return Optional.empty();
    }

    public Optional<? extends Uploader> getActiveUploader(String type, String name) {
        switch (type) {
            case "artifactory": {
                return this.getActiveArtifactory(name);
            }
            case "ftp": {
                return this.getActiveFtp(name);
            }
            case "gitea": {
                return this.getActiveGitea(name);
            }
            case "gitlab": {
                return this.getActiveGitlab(name);
            }
            case "http": {
                return this.getActiveHttp(name);
            }
            case "s3": {
                return this.getActiveS3(name);
            }
            case "scp": {
                return this.getActiveScp(name);
            }
            case "sftp": {
                return this.getActiveSftp(name);
            }
        }
        return Optional.empty();
    }

    public Optional<Artifactory> getActiveArtifactory(String name) {
        return this.artifactory.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<FtpUploader> getActiveFtp(String name) {
        return this.ftp.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<GiteaUploader> getActiveGitea(String name) {
        return this.gitea.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<GitlabUploader> getActiveGitlab(String name) {
        return this.gitlab.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<HttpUploader> getActiveHttp(String name) {
        return this.http.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<S3> getActiveS3(String name) {
        return this.s3.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<ScpUploader> getActiveScp(String name) {
        return this.scp.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public Optional<SftpUploader> getActiveSftp(String name) {
        return this.sftp.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.name)).findFirst();
    }

    public List<Artifactory> getActiveArtifactories() {
        return this.artifactory.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Artifactory> getArtifactory() {
        return this.freezeWrap(this.artifactory);
    }

    public void setArtifactory(Map<String, Artifactory> artifactory) {
        this.freezeCheck();
        this.artifactory.clear();
        this.artifactory.putAll(artifactory);
    }

    public void addArtifactory(Artifactory artifactory) {
        this.freezeCheck();
        this.artifactory.put(artifactory.getName(), artifactory);
    }

    public List<FtpUploader> getActiveFtps() {
        return this.ftp.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, FtpUploader> getFtp() {
        return this.freezeWrap(this.ftp);
    }

    public void setFtp(Map<String, FtpUploader> ftp) {
        this.freezeCheck();
        this.ftp.clear();
        this.ftp.putAll(ftp);
    }

    public void addFtp(FtpUploader ftp) {
        this.freezeCheck();
        this.ftp.put(ftp.getName(), ftp);
    }

    public List<GiteaUploader> getActiveGiteas() {
        return this.gitea.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GiteaUploader> getGitea() {
        return this.freezeWrap(this.gitea);
    }

    public void setGitea(Map<String, GiteaUploader> gitea) {
        this.freezeCheck();
        this.gitea.clear();
        this.gitea.putAll(gitea);
    }

    public void addGitea(GiteaUploader gitea) {
        this.freezeCheck();
        this.gitea.put(gitea.getName(), gitea);
    }

    public List<GitlabUploader> getActiveGitlabs() {
        return this.gitlab.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GitlabUploader> getGitlab() {
        return this.freezeWrap(this.gitlab);
    }

    public void setGitlab(Map<String, GitlabUploader> gitlab) {
        this.freezeCheck();
        this.gitlab.clear();
        this.gitlab.putAll(gitlab);
    }

    public void addGitlab(GitlabUploader gitlab) {
        this.freezeCheck();
        this.gitlab.put(gitlab.getName(), gitlab);
    }

    public List<HttpUploader> getActiveHttps() {
        return this.http.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, HttpUploader> getHttp() {
        return this.freezeWrap(this.http);
    }

    public void setHttp(Map<String, HttpUploader> http) {
        this.freezeCheck();
        this.http.clear();
        this.http.putAll(http);
    }

    public void addHttp(HttpUploader http) {
        this.freezeCheck();
        this.http.put(http.getName(), http);
    }

    public List<S3> getActiveS3s() {
        return this.s3.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, S3> getS3() {
        return this.freezeWrap(this.s3);
    }

    public void setS3(Map<String, S3> s3) {
        this.freezeCheck();
        this.s3.clear();
        this.s3.putAll(s3);
    }

    public void addS3(S3 s3) {
        this.freezeCheck();
        this.s3.put(s3.getName(), s3);
    }

    public List<ScpUploader> getActiveScps() {
        return this.scp.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ScpUploader> getScp() {
        return this.freezeWrap(this.scp);
    }

    public void setScp(Map<String, ScpUploader> scp) {
        this.freezeCheck();
        this.scp.clear();
        this.scp.putAll(scp);
    }

    public void addScp(ScpUploader scp) {
        this.freezeCheck();
        this.scp.put(scp.getName(), scp);
    }

    public List<SftpUploader> getActiveSftps() {
        return this.sftp.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, SftpUploader> getSftp() {
        return this.freezeWrap(this.sftp);
    }

    public void setSftp(Map<String, SftpUploader> sftp) {
        this.freezeCheck();
        this.sftp.clear();
        this.sftp.putAll(sftp);
    }

    public void addSftp(SftpUploader sftp) {
        this.freezeCheck();
        this.sftp.put(sftp.getName(), sftp);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List sftp;
        List scp;
        List s3;
        List http;
        List gitlab;
        List gitea;
        List ftp;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.enabled);
        map.put("active", (Object)this.active);
        List artifactory = this.artifactory.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!artifactory.isEmpty()) {
            map.put("artifactory", artifactory);
        }
        if (!(ftp = this.ftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("ftp", ftp);
        }
        if (!(gitea = this.gitea.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitea", gitea);
        }
        if (!(gitlab = this.gitlab.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitlab", gitlab);
        }
        if (!(http = this.http.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("http", http);
        }
        if (!(s3 = this.s3.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("s3", s3);
        }
        if (!(scp = this.scp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("scp", scp);
        }
        if (!(sftp = this.sftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("sftp", sftp);
        }
        return map;
    }

    public <A extends Uploader> Map<String, A> findUploadersByType(String uploaderType) {
        switch (uploaderType) {
            case "artifactory": {
                return this.artifactory;
            }
            case "ftp": {
                return this.ftp;
            }
            case "gitea": {
                return this.gitea;
            }
            case "gitlab": {
                return this.gitlab;
            }
            case "http": {
                return this.http;
            }
            case "s3": {
                return this.s3;
            }
            case "scp": {
                return this.scp;
            }
            case "sftp": {
                return this.sftp;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Uploader> List<A> findAllActiveUploaders() {
        ArrayList<AbstractUploader> uploaders = new ArrayList<AbstractUploader>();
        uploaders.addAll(this.getActiveArtifactories());
        uploaders.addAll(this.getActiveFtps());
        uploaders.addAll(this.getActiveGiteas());
        uploaders.addAll(this.getActiveGitlabs());
        uploaders.addAll(this.getActiveHttps());
        uploaders.addAll(this.getActiveS3s());
        uploaders.addAll(this.getActiveScps());
        uploaders.addAll(this.getActiveSftps());
        return uploaders;
    }

    public Map<String, String> resolveDownloadUrls(JReleaserContext context, Distribution distribution, Artifact artifact, String prefix) {
        Uploader uploader;
        List<String> keys;
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        List uploaders = this.findAllActiveUploaders();
        for (Uploader uploader2 : uploaders) {
            List<String> keys2 = uploader2.resolveSkipKeys();
            if (this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            String key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)uploader2.getName()) + "Url";
            String url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
            if (this.findUploadersByType(uploader2.getType()).size() != 1 || this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + "Url";
            url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        if (uploaders.size() == 1 && !this.isSkip(distribution, keys = (uploader = (Uploader)uploaders.get(0)).resolveSkipKeys()) && !this.isSkip(artifact, keys)) {
            String key = prefix + "DownloadUrl";
            String url = uploader.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        return urls;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> supportedUploaders() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("artifactory");
        set.add("ftp");
        set.add("gitea");
        set.add("gitlab");
        set.add("http");
        set.add("s3");
        set.add("scp");
        set.add("sftp");
        return Collections.unmodifiableSet(set);
    }
}

