/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Asdf;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class AsdfValidator
extends Validator {
    public static void validateAsdf(JReleaserContext context, Distribution distribution, Asdf packager, Errors errors) {
        context.getLogger().debug("distribution.{}.asdf", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        Asdf parentPackager = model.getPackagers().getAsdf();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).count() > 1L) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".asdf"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getToolCheck()) && StringUtils.isNotBlank((String)parentPackager.getToolCheck())) {
            packager.setToolCheck(parentPackager.getToolCheck());
        }
        if (StringUtils.isBlank((String)packager.getToolCheck())) {
            packager.setToolCheck("{{distributionExecutable}} --version");
        }
        if (StringUtils.isBlank((String)packager.getRepository().getName())) {
            packager.getRepository().setName("asdf-" + distribution.getName());
        }
        packager.getRepository().setTapName("asdf-" + distribution.getName());
        AsdfValidator.validateCommitAuthor(packager, parentPackager);
        Asdf.AsdfRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        AsdfValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "asdf.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        AsdfValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

