/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Project;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.CalVer;
import org.jreleaser.util.ChronVer;
import org.jreleaser.util.CustomVersion;
import org.jreleaser.util.Errors;
import org.jreleaser.util.JavaModuleVersion;
import org.jreleaser.util.JavaRuntimeVersion;
import org.jreleaser.util.SemVer;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public abstract class ChocolateyValidator
extends Validator {
    public static void validateChocolatey(JReleaserContext context, Distribution distribution, Chocolatey packager, Errors errors) {
        Project project;
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        Chocolatey parentPackager = model.getPackagers().getChocolatey();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(project = context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".chocolatey"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        ChocolateyValidator.validateCommitAuthor(packager, parentPackager);
        Chocolatey.ChocolateyBucket bucket = packager.getBucket();
        bucket.resolveEnabled(model.getProject());
        ChocolateyValidator.validateTap(context, distribution, bucket, parentPackager.getBucket(), "chocolatey.bucket");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        ChocolateyValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getPackageVersion())) {
            packager.setPackageVersion(parentPackager.getPackageVersion());
            if (StringUtils.isBlank((String)packager.getPackageVersion())) {
                packager.setPackageVersion(model.getProject().getResolvedVersion());
            }
        }
        if (StringUtils.isBlank((String)packager.getUsername())) {
            packager.setUsername(service.getOwner());
        }
        if (!packager.isRemoteBuildSet() && parentPackager.isRemoteBuildSet()) {
            packager.setRemoteBuild(parentPackager.isRemoteBuild());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(parentPackager.getTitle());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(model.getProject().getName());
        }
        if (StringUtils.isBlank((String)packager.getIconUrl())) {
            packager.setIconUrl(parentPackager.getIconUrl());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource(parentPackager.getSource());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource("https://push.chocolatey.org/");
        }
        if (!packager.isRemoteBuild()) {
            if (StringUtils.isBlank((String)packager.getApiKey())) {
                packager.setApiKey(parentPackager.getApiKey());
            }
            packager.setApiKey(ChocolateyValidator.checkProperty(context, "CHOCOLATEY_API_KEY", "chocolatey.apiKey", packager.getApiKey(), errors, context.isDryrun()));
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
        try {
            String packageVersion = Templates.resolveTemplate((String)packager.getPackageVersion(), context.getModel().props());
            switch (project.versionPattern().getType()) {
                case SEMVER: {
                    ChocolateyValidator.checkSemver(context, distribution, packager, SemVer.of((String)packageVersion), errors);
                    break;
                }
                case JAVA_RUNTIME: {
                    ChocolateyValidator.checkJavaRuntime(context, distribution, packager, JavaRuntimeVersion.of((String)packageVersion), errors);
                    break;
                }
                case JAVA_MODULE: {
                    ChocolateyValidator.checkJavaModule(context, distribution, packager, JavaModuleVersion.of((String)packageVersion), errors);
                    break;
                }
                case CALVER: {
                    ChocolateyValidator.checkCalVer(context, distribution, packager, CalVer.of((String)project.versionPattern().getFormat(), (String)packageVersion), errors);
                    break;
                }
                case CHRONVER: {
                    ChocolateyValidator.checkChronVer(context, distribution, packager, ChronVer.of((String)packageVersion), errors);
                    break;
                }
                default: {
                    ChocolateyValidator.checkCustomVersion(context, distribution, packager, CustomVersion.of((String)packageVersion), errors);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            errors.configuration(RB.$((String)"validation_chocolatey_package_version", (Object[])new Object[]{packager.getPackageVersion()}));
        }
    }

    private static void checkSemver(JReleaserContext context, Distribution distribution, Chocolatey packager, SemVer version, Errors errors) {
        boolean date;
        boolean integer;
        block7: {
            if (version.hasBuild()) {
                throw new IllegalArgumentException();
            }
            if (!version.hasTag() || "-".equals(version.getTagsep())) {
                return;
            }
            String tag = version.getTag();
            integer = false;
            date = false;
            try {
                Integer.parseInt(tag);
                integer = true;
                if (tag.length() != 8) break block7;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                try {
                    dateFormat.parse(tag);
                    date = true;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        if (!date && !integer) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkJavaRuntime(JReleaserContext context, Distribution distribution, Chocolatey packager, JavaRuntimeVersion version, Errors errors) {
        if (version.hasBuild()) {
            throw new IllegalArgumentException();
        }
        if (!version.hasPrerelease() && version.hasOptional()) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkJavaModule(JReleaserContext context, Distribution distribution, Chocolatey packager, JavaModuleVersion version, Errors errors) {
        if (version.hasBuild()) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkCalVer(JReleaserContext context, Distribution distribution, Chocolatey packager, CalVer version, Errors errors) {
    }

    private static void checkChronVer(JReleaserContext context, Distribution distribution, Chocolatey packager, ChronVer version, Errors errors) {
        ChronVer.Changeset changeset;
        if (version.hasChangeset() && ((changeset = version.getChangeset()).hasTag() || changeset.hasChange2())) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkCustomVersion(JReleaserContext context, Distribution distribution, Chocolatey packager, CustomVersion version, Errors errors) {
    }

    public static void postValidateChocolatey(JReleaserContext context, Distribution distribution, Chocolatey packager, Errors errors) {
        if (!packager.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        Project project = context.getModel().getProject();
        if (StringUtils.isBlank((String)project.getLinks().getLicense())) {
            errors.configuration(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
    }
}

