/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Gofish;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.JReleaserOutput;
import org.jreleaser.util.StringUtils;

public abstract class GofishValidator
extends Validator {
    public static void validateGofish(JReleaserContext context, Distribution distribution, Gofish packager, Errors errors) {
        context.getLogger().debug("distribution.{}.gofish", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        Gofish parentPackager = model.getPackagers().getGofish();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        JReleaserOutput.nag((String)"Gofish is deprecated since 1.1.0 and will be removed in 2.0.0");
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).count() > 1L) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".gofish"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        GofishValidator.validateCommitAuthor(packager, parentPackager);
        Gofish.GofishRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        GofishValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "gofish.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        GofishValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

