/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinitionProvider;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGenerationContextImpl
implements SchemaGenerationContext {
    private static final Logger logger = LoggerFactory.getLogger(SchemaGenerationContextImpl.class);
    private final SchemaGeneratorConfig generatorConfig;
    private final TypeContext typeContext;
    private final Map<DefinitionKey, ObjectNode> definitions = new LinkedHashMap<DefinitionKey, ObjectNode>();
    private final Map<DefinitionKey, List<ObjectNode>> references = new HashMap<DefinitionKey, List<ObjectNode>>();
    private final Map<DefinitionKey, List<ObjectNode>> nullableReferences = new HashMap<DefinitionKey, List<ObjectNode>>();

    public SchemaGenerationContextImpl(SchemaGeneratorConfig generatorConfig, TypeContext typeContext) {
        this.generatorConfig = generatorConfig;
        this.typeContext = typeContext;
    }

    @Override
    public SchemaGeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    @Override
    public TypeContext getTypeContext() {
        return this.typeContext;
    }

    public DefinitionKey parseType(ResolvedType type) {
        this.traverseGenericType(type, null, false);
        return new DefinitionKey(type, null);
    }

    SchemaGenerationContextImpl putDefinition(ResolvedType javaType, ObjectNode definitionNode, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        this.definitions.put(new DefinitionKey(javaType, ignoredDefinitionProvider), definitionNode);
        return this;
    }

    public boolean containsDefinition(ResolvedType javaType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        return this.definitions.containsKey(new DefinitionKey(javaType, ignoredDefinitionProvider));
    }

    public ObjectNode getDefinition(DefinitionKey key) {
        return this.definitions.get(key);
    }

    public Set<DefinitionKey> getDefinedTypes() {
        return Collections.unmodifiableSet(this.definitions.keySet());
    }

    public SchemaGenerationContextImpl addReference(ResolvedType javaType, ObjectNode referencingNode, CustomDefinitionProviderV2 ignoredDefinitionProvider, boolean isNullable) {
        Map<DefinitionKey, List<ObjectNode>> targetMap = isNullable ? this.nullableReferences : this.references;
        DefinitionKey key = new DefinitionKey(javaType, ignoredDefinitionProvider);
        List valueList = targetMap.computeIfAbsent(key, k -> new ArrayList());
        valueList.add(referencingNode);
        return this;
    }

    public List<ObjectNode> getReferences(DefinitionKey key) {
        return Collections.unmodifiableList(this.references.getOrDefault(key, Collections.emptyList()));
    }

    public List<ObjectNode> getNullableReferences(DefinitionKey key) {
        return Collections.unmodifiableList(this.nullableReferences.getOrDefault(key, Collections.emptyList()));
    }

    @Override
    public ObjectNode createDefinition(ResolvedType targetType) {
        return this.createStandardDefinition(targetType, null);
    }

    @Override
    public ObjectNode createDefinitionReference(ResolvedType targetType) {
        return this.createStandardDefinitionReference(targetType, null);
    }

    @Override
    public ObjectNode createStandardDefinition(ResolvedType targetType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition = this.generatorConfig.createObjectNode();
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        this.traverseGenericType(scope, definition, false, true, ignoredDefinitionProvider);
        return definition;
    }

    @Override
    public ObjectNode createStandardDefinition(FieldScope targetScope, CustomPropertyDefinitionProvider<FieldScope> ignoredDefinitionProvider) {
        return this.createFieldSchema(targetScope, false, true, ignoredDefinitionProvider);
    }

    @Override
    public JsonNode createStandardDefinition(MethodScope targetScope, CustomPropertyDefinitionProvider<MethodScope> ignoredDefinitionProvider) {
        return this.createMethodSchema(targetScope, false, true, ignoredDefinitionProvider);
    }

    @Override
    public ObjectNode createStandardDefinitionReference(ResolvedType targetType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition = this.generatorConfig.createObjectNode();
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        this.traverseGenericType(scope, definition, false, false, ignoredDefinitionProvider);
        return definition;
    }

    @Override
    public ObjectNode createStandardDefinitionReference(FieldScope targetScope, CustomPropertyDefinitionProvider<FieldScope> ignoredDefinitionProvider) {
        return this.createFieldSchema(targetScope, false, false, ignoredDefinitionProvider);
    }

    @Override
    public JsonNode createStandardDefinitionReference(MethodScope targetScope, CustomPropertyDefinitionProvider<MethodScope> ignoredDefinitionProvider) {
        return this.createMethodSchema(targetScope, false, false, ignoredDefinitionProvider);
    }

    protected void traverseGenericType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable) {
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        this.traverseGenericType(scope, targetNode, isNullable, false, null);
    }

    private void traverseGenericType(TypeScope scope, ObjectNode targetNode, boolean isNullable, boolean forceInlineDefinition, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition;
        boolean includeTypeAttributes;
        ResolvedType targetType = scope.getType();
        if (!forceInlineDefinition && this.containsDefinition(targetType, ignoredDefinitionProvider)) {
            logger.debug("adding reference to existing definition of {}", (Object)targetType);
            this.addReference(targetType, targetNode, ignoredDefinitionProvider, isNullable);
            return;
        }
        CustomDefinition customDefinition = this.generatorConfig.getCustomDefinition(targetType, (SchemaGenerationContext)this, ignoredDefinitionProvider);
        if (customDefinition != null && (customDefinition.isMeantToBeInline() || forceInlineDefinition)) {
            includeTypeAttributes = customDefinition.shouldIncludeAttributes();
            if (targetNode == null) {
                logger.debug("storing configured custom inline type for {} as definition (since it is the main schema \"#\")", (Object)targetType);
                definition = customDefinition.getValue();
                this.putDefinition(targetType, definition, ignoredDefinitionProvider);
            } else {
                logger.debug("directly applying configured custom inline type for {}", (Object)targetType);
                targetNode.setAll(customDefinition.getValue());
                definition = targetNode;
            }
            if (isNullable) {
                this.makeNullable(definition);
            }
        } else {
            boolean isContainerType = this.typeContext.isContainerType(targetType);
            if (forceInlineDefinition || isContainerType && targetNode != null && customDefinition == null) {
                definition = targetNode;
            } else {
                definition = this.generatorConfig.createObjectNode();
                this.putDefinition(targetType, definition, ignoredDefinitionProvider);
                if (targetNode != null) {
                    this.addReference(targetType, targetNode, ignoredDefinitionProvider, isNullable);
                }
            }
            if (customDefinition != null) {
                logger.debug("applying configured custom definition for {}", (Object)targetType);
                definition.setAll(customDefinition.getValue());
                includeTypeAttributes = customDefinition.shouldIncludeAttributes();
            } else if (isContainerType) {
                logger.debug("generating array definition for {}", (Object)targetType);
                this.generateArrayDefinition(scope, definition, isNullable);
                includeTypeAttributes = true;
            } else {
                logger.debug("generating definition for {}", (Object)targetType);
                boolean bl = includeTypeAttributes = !this.addSubtypeReferencesInDefinition(targetType, definition);
            }
        }
        if (includeTypeAttributes) {
            Set<String> allowedSchemaTypes = this.collectAllowedSchemaTypes(definition);
            ObjectNode typeAttributes = AttributeCollector.collectTypeAttributes(scope, this, allowedSchemaTypes);
            typeAttributes.setAll(definition);
            definition.setAll(typeAttributes);
        }
        this.generatorConfig.getTypeAttributeOverrides().forEach(override -> override.overrideTypeAttributes(definition, scope, this));
    }

    private boolean addSubtypeReferencesInDefinition(ResolvedType targetType, ObjectNode definition) {
        List<ResolvedType> subtypes = this.generatorConfig.resolveSubtypes(targetType, this);
        if (subtypes.isEmpty()) {
            this.generateObjectDefinition(targetType, definition);
            return false;
        }
        SchemaKeyword arrayNodeName = subtypes.size() == 1 ? SchemaKeyword.TAG_ALLOF : SchemaKeyword.TAG_ANYOF;
        ArrayNode subtypeDefinitionArrayNode = definition.withArray(this.getKeyword(arrayNodeName));
        subtypes.forEach(subtype -> this.traverseGenericType((ResolvedType)subtype, subtypeDefinitionArrayNode.addObject(), false));
        return true;
    }

    private Set<String> collectAllowedSchemaTypes(ObjectNode definition) {
        JsonNode declaredTypes = definition.get(this.getKeyword(SchemaKeyword.TAG_TYPE));
        Set<String> allowedSchemaTypes = declaredTypes == null ? Collections.emptySet() : (declaredTypes.isTextual() ? Collections.singleton(declaredTypes.textValue()) : StreamSupport.stream(declaredTypes.spliterator(), false).map(JsonNode::textValue).collect(Collectors.toSet()));
        return allowedSchemaTypes;
    }

    private void generateArrayDefinition(TypeScope targetScope, ObjectNode definition, boolean isNullable) {
        if (isNullable) {
            ArrayNode typeArray = this.generatorConfig.createArrayNode().add(this.getKeyword(SchemaKeyword.TAG_TYPE_ARRAY)).add(this.getKeyword(SchemaKeyword.TAG_TYPE_NULL));
            definition.set(this.getKeyword(SchemaKeyword.TAG_TYPE), (JsonNode)typeArray);
        } else {
            definition.put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_ARRAY));
        }
        if (targetScope instanceof MemberScope && !((MemberScope)targetScope).isFakeContainerItemScope()) {
            ObjectNode fakeItemDefinition;
            MemberScope fakeArrayItemMember = ((MemberScope)targetScope).asFakeContainerItemScope();
            if (targetScope instanceof FieldScope) {
                fakeItemDefinition = this.populateFieldSchema((FieldScope)fakeArrayItemMember);
            } else if (targetScope instanceof MethodScope) {
                fakeItemDefinition = this.populateMethodSchema((MethodScope)fakeArrayItemMember);
            } else {
                throw new IllegalStateException("Unsupported member type: " + targetScope.getClass().getName());
            }
            definition.set(this.getKeyword(SchemaKeyword.TAG_ITEMS), (JsonNode)fakeItemDefinition);
        } else {
            ObjectNode arrayItemTypeRef = this.generatorConfig.createObjectNode();
            definition.set(this.getKeyword(SchemaKeyword.TAG_ITEMS), (JsonNode)arrayItemTypeRef);
            this.traverseGenericType(targetScope.getContainerItemType(), arrayItemTypeRef, false);
        }
    }

    private void generateObjectDefinition(ResolvedType targetType, ObjectNode definition) {
        definition.put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_OBJECT));
        LinkedHashMap targetProperties = new LinkedHashMap();
        HashSet<String> requiredProperties = new HashSet<String>();
        this.collectObjectProperties(targetType, targetProperties, requiredProperties);
        if (!targetProperties.isEmpty()) {
            ObjectNode propertiesNode = this.generatorConfig.createObjectNode();
            List sortedProperties = targetProperties.values().stream().sorted(this.generatorConfig::sortProperties).collect(Collectors.toList());
            for (MemberScope property : sortedProperties) {
                ObjectNode subSchema;
                if (property instanceof FieldScope) {
                    subSchema = this.populateFieldSchema((FieldScope)property);
                } else if (property instanceof MethodScope) {
                    subSchema = this.populateMethodSchema((MethodScope)property);
                } else {
                    throw new IllegalStateException("Unsupported member scope of type " + property.getClass());
                }
                propertiesNode.set(property.getSchemaPropertyName(), (JsonNode)subSchema);
            }
            definition.set(this.getKeyword(SchemaKeyword.TAG_PROPERTIES), (JsonNode)propertiesNode);
            if (!requiredProperties.isEmpty()) {
                ArrayNode requiredNode = this.generatorConfig.createArrayNode();
                sortedProperties.stream().map(MemberScope::getSchemaPropertyName).filter(requiredProperties::contains).forEach(arg_0 -> ((ArrayNode)requiredNode).add(arg_0));
                definition.set(this.getKeyword(SchemaKeyword.TAG_REQUIRED), (JsonNode)requiredNode);
            }
        }
    }

    private void collectObjectProperties(ResolvedType targetType, Map<String, MemberScope<?, ?>> targetProperties, Set<String> requiredProperties) {
        logger.debug("collecting non-static fields and methods from {}", (Object)targetType);
        ResolvedTypeWithMembers targetTypeWithMembers = this.typeContext.resolveWithMembers(targetType);
        this.collectFields(targetTypeWithMembers, ResolvedTypeWithMembers::getMemberFields, targetProperties, requiredProperties);
        this.collectMethods(targetTypeWithMembers, ResolvedTypeWithMembers::getMemberMethods, targetProperties, requiredProperties);
        boolean includeStaticFields = this.generatorConfig.shouldIncludeStaticFields();
        boolean includeStaticMethods = this.generatorConfig.shouldIncludeStaticMethods();
        if (includeStaticFields || includeStaticMethods) {
            for (HierarchicType singleHierarchy : targetTypeWithMembers.allTypesAndOverrides()) {
                ResolvedType hierachyType = singleHierarchy.getType();
                logger.debug("collecting static fields and methods from {}", (Object)hierachyType);
                if ((!includeStaticFields || hierachyType.getStaticFields().isEmpty()) && (!includeStaticMethods || hierachyType.getStaticMethods().isEmpty())) continue;
                ResolvedTypeWithMembers hierarchyTypeMembers = hierachyType == targetType ? targetTypeWithMembers : this.typeContext.resolveWithMembers(hierachyType);
                if (includeStaticFields) {
                    this.collectFields(hierarchyTypeMembers, ResolvedTypeWithMembers::getStaticFields, targetProperties, requiredProperties);
                }
                if (!includeStaticMethods) continue;
                this.collectMethods(hierarchyTypeMembers, ResolvedTypeWithMembers::getStaticMethods, targetProperties, requiredProperties);
            }
        }
    }

    private void collectFields(ResolvedTypeWithMembers declaringTypeMembers, Function<ResolvedTypeWithMembers, ResolvedField[]> fieldLookup, Map<String, MemberScope<?, ?>> collectedProperties, Set<String> requiredProperties) {
        Stream.of(fieldLookup.apply(declaringTypeMembers)).map(declaredField -> this.typeContext.createFieldScope((ResolvedField)declaredField, declaringTypeMembers)).filter(fieldScope -> !this.generatorConfig.shouldIgnore((FieldScope)fieldScope)).forEach(fieldScope -> this.collectField((FieldScope)fieldScope, collectedProperties, requiredProperties));
    }

    private void collectMethods(ResolvedTypeWithMembers declaringTypeMembers, Function<ResolvedTypeWithMembers, ResolvedMethod[]> methodLookup, Map<String, MemberScope<?, ?>> collectedProperties, Set<String> requiredProperties) {
        Stream.of(methodLookup.apply(declaringTypeMembers)).map(declaredMethod -> this.typeContext.createMethodScope((ResolvedMethod)declaredMethod, declaringTypeMembers)).filter(methodScope -> !this.generatorConfig.shouldIgnore((MethodScope)methodScope)).forEach(methodScope -> this.collectMethod((MethodScope)methodScope, collectedProperties, requiredProperties));
    }

    private void collectField(FieldScope field, Map<String, MemberScope<?, ?>> collectedProperties, Set<String> requiredProperties) {
        String propertyName;
        FieldScope fieldWithNameOverride;
        if (field.isFakeContainerItemScope()) {
            fieldWithNameOverride = field;
            propertyName = field.getSchemaPropertyName();
        } else {
            String propertyNameOverride = this.generatorConfig.resolvePropertyNameOverride(field);
            fieldWithNameOverride = propertyNameOverride == null ? field : field.withOverriddenName(propertyNameOverride);
            propertyName = fieldWithNameOverride.getSchemaPropertyName();
            if (this.generatorConfig.isRequired(field)) {
                requiredProperties.add(propertyName);
            }
            if (collectedProperties.containsKey(propertyName)) {
                logger.debug("ignoring overridden {}.{}", (Object)fieldWithNameOverride.getDeclaringType(), (Object)fieldWithNameOverride.getDeclaredName());
                return;
            }
        }
        collectedProperties.put(propertyName, fieldWithNameOverride);
    }

    private ObjectNode populateFieldSchema(FieldScope field) {
        boolean isNullable;
        List<ResolvedType> typeOverrides = this.generatorConfig.resolveTargetTypeOverrides(field);
        if (typeOverrides == null) {
            typeOverrides = this.generatorConfig.resolveSubtypes(field.getType(), this);
        }
        List<FieldScope> fieldOptions = typeOverrides == null || typeOverrides.isEmpty() ? Collections.singletonList(field) : typeOverrides.stream().map(field::withOverriddenType).collect(Collectors.toList());
        boolean bl = isNullable = !((Field)field.getRawMember()).isEnumConstant() && (!field.isFakeContainerItemScope() || this.generatorConfig.shouldAllowNullableArrayItems()) && this.generatorConfig.isNullable(field);
        if (fieldOptions.size() == 1) {
            return this.createFieldSchema(fieldOptions.get(0), isNullable, false, null);
        }
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ArrayNode anyOfArray = subSchema.withArray(this.getKeyword(SchemaKeyword.TAG_ANYOF));
        if (isNullable) {
            anyOfArray.addObject().put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_NULL));
        }
        fieldOptions.forEach(option -> anyOfArray.add((JsonNode)this.createFieldSchema((FieldScope)option, false, false, null)));
        return subSchema;
    }

    private ObjectNode createFieldSchema(FieldScope field, boolean isNullable, boolean forceInlineDefinition, CustomPropertyDefinitionProvider<FieldScope> ignoredDefinitionProvider) {
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ObjectNode fieldAttributes = AttributeCollector.collectFieldAttributes(field, this);
        this.populateMemberSchema(field, subSchema, isNullable, forceInlineDefinition, fieldAttributes, ignoredDefinitionProvider);
        return subSchema;
    }

    private void collectMethod(MethodScope method, Map<String, MemberScope<?, ?>> collectedProperties, Set<String> requiredProperties) {
        String propertyName;
        MethodScope methodWithNameOverride;
        if (method.isFakeContainerItemScope()) {
            methodWithNameOverride = method;
            propertyName = method.getSchemaPropertyName();
        } else {
            String propertyNameOverride = this.generatorConfig.resolvePropertyNameOverride(method);
            methodWithNameOverride = propertyNameOverride == null ? method : method.withOverriddenName(propertyNameOverride);
            propertyName = methodWithNameOverride.getSchemaPropertyName();
            if (this.generatorConfig.isRequired(method)) {
                requiredProperties.add(propertyName);
            }
            if (collectedProperties.containsKey(propertyName)) {
                logger.debug("ignoring overridden {}.{}", (Object)methodWithNameOverride.getDeclaringType(), (Object)methodWithNameOverride.getDeclaredName());
                return;
            }
        }
        collectedProperties.put(propertyName, methodWithNameOverride);
    }

    private JsonNode populateMethodSchema(MethodScope method) {
        boolean isNullable;
        List<ResolvedType> typeOverrides = this.generatorConfig.resolveTargetTypeOverrides(method);
        if (typeOverrides == null && !method.isVoid()) {
            typeOverrides = this.generatorConfig.resolveSubtypes(method.getType(), this);
        }
        List<MethodScope> methodOptions = typeOverrides == null || typeOverrides.isEmpty() ? Collections.singletonList(method) : typeOverrides.stream().map(method::withOverriddenType).collect(Collectors.toList());
        boolean bl = isNullable = method.isVoid() || (!method.isFakeContainerItemScope() || this.generatorConfig.shouldAllowNullableArrayItems()) && this.generatorConfig.isNullable(method);
        if (methodOptions.size() == 1) {
            return this.createMethodSchema(methodOptions.get(0), isNullable, false, null);
        }
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ArrayNode anyOfArray = subSchema.withArray(this.getKeyword(SchemaKeyword.TAG_ANYOF));
        if (isNullable) {
            anyOfArray.add((JsonNode)this.generatorConfig.createObjectNode().put(this.getKeyword(SchemaKeyword.TAG_TYPE), this.getKeyword(SchemaKeyword.TAG_TYPE_NULL)));
        }
        methodOptions.forEach(option -> anyOfArray.add(this.createMethodSchema((MethodScope)option, false, false, null)));
        return subSchema;
    }

    private JsonNode createMethodSchema(MethodScope method, boolean isNullable, boolean forceInlineDefinition, CustomPropertyDefinitionProvider<MethodScope> ignoredDefinitionProvider) {
        if (method.isVoid()) {
            return BooleanNode.FALSE;
        }
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        ObjectNode methodAttributes = AttributeCollector.collectMethodAttributes(method, this);
        this.populateMemberSchema(method, subSchema, isNullable, forceInlineDefinition, methodAttributes, ignoredDefinitionProvider);
        return subSchema;
    }

    private <M extends MemberScope<?, ?>> void populateMemberSchema(M scope, ObjectNode targetNode, boolean isNullable, boolean forceInlineDefinition, ObjectNode collectedAttributes, CustomPropertyDefinitionProvider<M> ignoredDefinitionProvider) {
        CustomDefinition customDefinition = this.generatorConfig.getCustomDefinition(scope, (SchemaGenerationContext)this, ignoredDefinitionProvider);
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            targetNode.setAll(customDefinition.getValue());
            if (customDefinition.shouldIncludeAttributes()) {
                AttributeCollector.mergeMissingAttributes(targetNode, collectedAttributes);
                Set<String> allowedSchemaTypes = this.collectAllowedSchemaTypes(targetNode);
                ObjectNode typeAttributes = AttributeCollector.collectTypeAttributes(scope, this, allowedSchemaTypes);
                AttributeCollector.mergeMissingAttributes(targetNode, typeAttributes);
            }
            if (isNullable) {
                this.makeNullable(targetNode);
            }
        } else {
            ObjectNode referenceContainer;
            if (customDefinition != null && !customDefinition.shouldIncludeAttributes() || collectedAttributes == null || collectedAttributes.size() == 0) {
                referenceContainer = targetNode;
            } else if (customDefinition == null && scope.isContainerType()) {
                referenceContainer = targetNode;
                AttributeCollector.mergeMissingAttributes(targetNode, collectedAttributes);
            } else {
                referenceContainer = this.generatorConfig.createObjectNode();
                targetNode.set(this.getKeyword(SchemaKeyword.TAG_ALLOF), (JsonNode)this.generatorConfig.createArrayNode().add((JsonNode)referenceContainer).add((JsonNode)collectedAttributes));
            }
            try {
                this.traverseGenericType(scope, referenceContainer, isNullable, forceInlineDefinition, null);
            }
            catch (UnsupportedOperationException ex) {
                logger.warn("Skipping type definition due to error", (Throwable)ex);
            }
        }
    }

    @Override
    public ObjectNode makeNullable(ObjectNode node) {
        String nullTypeName = this.getKeyword(SchemaKeyword.TAG_TYPE_NULL);
        if (node.has(this.getKeyword(SchemaKeyword.TAG_REF)) || node.has(this.getKeyword(SchemaKeyword.TAG_ALLOF)) || node.has(this.getKeyword(SchemaKeyword.TAG_ANYOF)) || node.has(this.getKeyword(SchemaKeyword.TAG_ONEOF)) || node.has(this.getKeyword(SchemaKeyword.TAG_CONST)) || node.has(this.getKeyword(SchemaKeyword.TAG_ENUM))) {
            ObjectNode nullSchema = this.generatorConfig.createObjectNode().put(this.getKeyword(SchemaKeyword.TAG_TYPE), nullTypeName);
            ArrayNode anyOf = this.generatorConfig.createArrayNode().add((JsonNode)nullSchema).add(this.generatorConfig.createObjectNode().setAll(node));
            node.removeAll();
            node.set(this.getKeyword(SchemaKeyword.TAG_ANYOF), (JsonNode)anyOf);
        } else {
            JsonNode fixedJsonSchemaType = node.get(this.getKeyword(SchemaKeyword.TAG_TYPE));
            if (fixedJsonSchemaType instanceof ArrayNode) {
                ArrayNode arrayOfTypes = (ArrayNode)fixedJsonSchemaType;
                boolean alreadyContainsNull = false;
                for (JsonNode arrayEntry : arrayOfTypes) {
                    alreadyContainsNull = alreadyContainsNull || nullTypeName.equals(arrayEntry.textValue());
                }
                if (!alreadyContainsNull) {
                    node.replace(this.getKeyword(SchemaKeyword.TAG_TYPE), (JsonNode)this.generatorConfig.createArrayNode().addAll(arrayOfTypes).add(nullTypeName));
                }
            } else if (fixedJsonSchemaType instanceof TextNode && !nullTypeName.equals(fixedJsonSchemaType.textValue())) {
                node.replace(this.getKeyword(SchemaKeyword.TAG_TYPE), (JsonNode)this.generatorConfig.createArrayNode().add(fixedJsonSchemaType).add(nullTypeName));
            }
        }
        return node;
    }

    @Override
    public String getKeyword(SchemaKeyword keyword) {
        return this.generatorConfig.getKeyword(keyword);
    }
}

