/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import feign.form.FormData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.GiteaUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.uploader.spi.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.JReleaserLogger;

public class GiteaArtifactUploader
extends AbstractArtifactUploader<GiteaUploader> {
    private GiteaUploader uploader;

    public GiteaArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public GiteaUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(GiteaUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "gitea";
    }

    public void upload(String name) throws UploadException {
        List artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String token = this.uploader.getResolvedToken();
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
            if (this.context.isDryrun()) continue;
            try {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                headers.put("Authorization", "token " + token);
                FormData data = ClientUtils.toFormData((Path)path);
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)this.uploader.getResolvedUploadUrl(this.context, artifact), (int)this.uploader.getConnectTimeout(), (int)this.uploader.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
            }
            catch (UploadException e) {
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), e.getCause());
            }
        }
    }
}

