@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  jreleaser startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and JRELEASER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\jreleaser-1.2.0.jar;%APP_HOME%\lib\jreleaser-workflow-1.2.0.jar;%APP_HOME%\lib\jreleaser-config-yaml-1.2.0.jar;%APP_HOME%\lib\jreleaser-config-toml-1.2.0.jar;%APP_HOME%\lib\jreleaser-config-json-1.2.0.jar;%APP_HOME%\lib\jsonschema-generator-4.26.0.jar;%APP_HOME%\lib\jsonschema-module-jackson-4.26.0.jar;%APP_HOME%\lib\picocli-4.6.3.jar;%APP_HOME%\lib\slf4j-simple-2.0.0.jar;%APP_HOME%\lib\github-java-sdk-1.2.0.jar;%APP_HOME%\lib\discord-java-sdk-1.2.0.jar;%APP_HOME%\lib\gitter-java-sdk-1.2.0.jar;%APP_HOME%\lib\google-chat-java-sdk-1.2.0.jar;%APP_HOME%\lib\mastodon-java-sdk-1.2.0.jar;%APP_HOME%\lib\mattermost-java-sdk-1.2.0.jar;%APP_HOME%\lib\slack-java-sdk-1.2.0.jar;%APP_HOME%\lib\teams-java-sdk-1.2.0.jar;%APP_HOME%\lib\telegram-java-sdk-1.2.0.jar;%APP_HOME%\lib\webhooks-java-sdk-1.2.0.jar;%APP_HOME%\lib\zulip-java-sdk-1.2.0.jar;%APP_HOME%\lib\gitlab-java-sdk-1.2.0.jar;%APP_HOME%\lib\codeberg-java-sdk-1.2.0.jar;%APP_HOME%\lib\gitea-java-sdk-1.2.0.jar;%APP_HOME%\lib\genericgit-java-sdk-1.2.0.jar;%APP_HOME%\lib\artifactory-java-sdk-1.2.0.jar;%APP_HOME%\lib\ftp-java-sdk-1.2.0.jar;%APP_HOME%\lib\http-java-sdk-1.2.0.jar;%APP_HOME%\lib\ssh-java-sdk-1.2.0.jar;%APP_HOME%\lib\s3-java-sdk-1.2.0.jar;%APP_HOME%\lib\java-sdk-commons-1.2.0.jar;%APP_HOME%\lib\tika-core-2.4.1.jar;%APP_HOME%\lib\sshj-0.34.0.jar;%APP_HOME%\lib\mail-java-sdk-1.2.0.jar;%APP_HOME%\lib\jreleaser-tools-1.2.0.jar;%APP_HOME%\lib\sdkman-java-sdk-1.2.0.jar;%APP_HOME%\lib\twitter-java-sdk-1.2.0.jar;%APP_HOME%\lib\jreleaser-assemblers-1.2.0.jar;%APP_HOME%\lib\jreleaser-engine-1.2.0.jar;%APP_HOME%\lib\git-sdk-1.2.0.jar;%APP_HOME%\lib\jreleaser-templates-1.2.0.jar;%APP_HOME%\lib\tool-sdk-1.2.0.jar;%APP_HOME%\lib\jreleaser-model-1.2.0.jar;%APP_HOME%\lib\jreleaser-utils-1.2.0.jar;%APP_HOME%\lib\feign-form-3.8.0.jar;%APP_HOME%\lib\org.eclipse.jgit-5.13.0.202109080827-r.jar;%APP_HOME%\lib\asn-one-0.6.0.jar;%APP_HOME%\lib\jcl-over-slf4j-2.0.0.jar;%APP_HOME%\lib\zt-exec-1.12.jar;%APP_HOME%\lib\slf4j-api-2.0.0.jar;%APP_HOME%\lib\jackson-dataformat-toml-2.13.3.jar;%APP_HOME%\lib\jackson-annotations-2.13.3.jar;%APP_HOME%\lib\aws-java-sdk-s3-1.12.290.jar;%APP_HOME%\lib\aws-java-sdk-kms-1.12.290.jar;%APP_HOME%\lib\aws-java-sdk-core-1.12.290.jar;%APP_HOME%\lib\jackson-dataformat-cbor-2.13.3.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.13.3.jar;%APP_HOME%\lib\feign-jackson-11.9.1.jar;%APP_HOME%\lib\github-api-1.129.jar;%APP_HOME%\lib\jmespath-java-1.12.290.jar;%APP_HOME%\lib\jackson-databind-2.13.3.jar;%APP_HOME%\lib\jackson-core-2.13.3.jar;%APP_HOME%\lib\yamllint-1.5.0.jar;%APP_HOME%\lib\classmate-1.5.1.jar;%APP_HOME%\lib\jakarta.mail-2.0.1.jar;%APP_HOME%\lib\feign-httpclient-11.9.1.jar;%APP_HOME%\lib\feign-core-11.9.1.jar;%APP_HOME%\lib\twitter4j-core-4.0.7.jar;%APP_HOME%\lib\commons-lang3-3.12.0.jar;%APP_HOME%\lib\commons-io-2.11.0.jar;%APP_HOME%\lib\commons-net-3.8.0.jar;%APP_HOME%\lib\snakeyaml-1.30.jar;%APP_HOME%\lib\jakarta.activation-2.0.1.jar;%APP_HOME%\lib\httpclient-4.5.13.jar;%APP_HOME%\lib\compiler-0.9.10.jar;%APP_HOME%\lib\bcpkix-jdk15on-1.69.jar;%APP_HOME%\lib\bcpg-jdk15on-1.69.jar;%APP_HOME%\lib\bcutil-jdk15on-1.69.jar;%APP_HOME%\lib\bcprov-jdk15on-1.69.jar;%APP_HOME%\lib\jzlib-1.1.3.jar;%APP_HOME%\lib\eddsa-0.3.0.jar;%APP_HOME%\lib\os-maven-plugin-1.7.0.jar;%APP_HOME%\lib\commons-codec-1.15.jar;%APP_HOME%\lib\commons-compress-1.21.jar;%APP_HOME%\lib\org.tukaani.xz-0.3.jar;%APP_HOME%\lib\commonmark-0.19.0.jar;%APP_HOME%\lib\JavaEWAH-1.1.12.jar;%APP_HOME%\lib\httpcore-4.4.13.jar;%APP_HOME%\lib\ion-java-1.0.2.jar;%APP_HOME%\lib\joda-time-2.8.1.jar


@rem Execute jreleaser
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %JRELEASER_OPTS%  -classpath "%CLASSPATH%" org.jreleaser.cli.Main %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable JRELEASER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%JRELEASER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
