/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.announce.RedditAnnouncer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.RedditAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class RedditAnnouncerValidator {
    private RedditAnnouncerValidator() {
    }

    public static void validateReddit(JReleaserContext context, RedditAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.reddit");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.reddit", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setClientId(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.reddit.client.id", "REDDIT_CLIENT_ID"}), "announce.reddit.clientId", announcer.getClientId(), errors, context.isDryrun()));
        announcer.setClientSecret(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.reddit.client.secret", "REDDIT_CLIENT_SECRET"}), "announce.reddit.clientSecret", announcer.getClientSecret(), errors, context.isDryrun()));
        announcer.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.reddit.username", "REDDIT_USERNAME"}), "announce.reddit.username", announcer.getUsername(), errors, context.isDryrun()));
        announcer.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.reddit.password", "REDDIT_PASSWORD"}), "announce.reddit.password", announcer.getPassword(), errors, context.isDryrun()));
        announcer.setSubreddit(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.reddit.subreddit"}), "announce.reddit.subreddit", announcer.getSubreddit(), errors));
        if (StringUtils.isNotBlank((String)announcer.getTextTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getTextTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"reddit.textTemplate", announcer.getTextTemplate()}));
        }
        if (StringUtils.isBlank((String)announcer.getTitle())) {
            announcer.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (announcer.getSubmissionType() == RedditAnnouncer.SubmissionType.SELF) {
            if (StringUtils.isBlank((String)announcer.getText()) && StringUtils.isBlank((String)announcer.getTextTemplate())) {
                announcer.setText(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        } else if (StringUtils.isBlank((String)announcer.getUrl())) {
            announcer.setUrl("{{releaseNotesUrl}}");
        }
        Validator.validateTimeout(announcer);
    }
}

