/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.jreleaser.cli.AbstractLoggingCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.Main;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.engine.context.ContextCreator;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command
public abstract class AbstractModelCommand
extends AbstractLoggingCommand {
    @CommandLine.Option(names={"-c", "--config-file"})
    Path configFile;
    @CommandLine.Option(names={"-grs", "--git-root-search"})
    boolean gitRootSearch;
    @CommandLine.Option(names={"-P", "--set-property"}, paramLabel="<key=value>")
    String[] properties;
    @CommandLine.ParentCommand
    Main parent;
    Path actualConfigFile;
    Path actualBasedir;

    @Override
    protected Main parent() {
        return this.parent;
    }

    @Override
    protected void execute() {
        this.resolveConfigFile();
        this.resolveBasedir();
        this.initLogger();
        PlatformUtils.resolveCurrentPlatform((JReleaserLogger)this.logger);
        this.logger.info("JReleaser {}", new Object[]{JReleaserVersion.getPlainVersion()});
        JReleaserVersion.banner((PrintWriter)this.logger.getTracer());
        this.logger.info(this.$("TEXT_config_file", new Object[0]), new Object[]{this.actualConfigFile});
        this.logger.increaseIndent();
        this.logger.info(this.$("TEXT_basedir_set", new Object[0]), new Object[]{this.actualBasedir.toAbsolutePath()});
        this.logger.decreaseIndent();
        this.doExecute(this.createContext());
    }

    private void resolveConfigFile() {
        if (null != this.configFile) {
            this.actualConfigFile = this.configFile.normalize();
        } else {
            Path directory = Paths.get(".", new String[0]).normalize();
            Optional<Path> file = this.resolveConfigFileAt(directory);
            if (!file.isPresent() && this.basedir != null) {
                file = this.resolveConfigFileAt(this.basedir);
            }
            this.actualConfigFile = file.orElse(null);
        }
        if (null == this.actualConfigFile || !Files.exists(this.actualConfigFile, new LinkOption[0])) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(this.$("ERROR_missing_config_file", String.join((CharSequence)"|", this.getSupportedConfigFormats()))));
            this.spec.commandLine().usage(this.parent.out);
            throw new HaltExecutionException();
        }
    }

    private Optional<Path> resolveConfigFileAt(Path directory) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            Path file = directory.resolve("jreleaser." + parser.getPreferredFileExtension()).normalize();
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private void resolveBasedir() {
        this.actualBasedir = (null != this.basedir ? this.basedir : this.actualConfigFile.toAbsolutePath().getParent()).normalize();
        if (!Files.exists(this.actualBasedir, new LinkOption[0])) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(this.$("ERROR_missing_required_option", "--basedir=<basedir>")));
            this.spec.commandLine().usage(this.parent.out);
            throw new HaltExecutionException();
        }
    }

    protected abstract void doExecute(JReleaserContext var1);

    protected JReleaserContext createContext() {
        JReleaserModel model = ContextCreator.resolveModel((JReleaserLogger)this.logger, (Path)this.actualConfigFile);
        Environment.PropertiesPropertiesSource propertiesSource = new Environment.PropertiesPropertiesSource(this.collectProperties());
        model.getEnvironment().setPropertiesSource((Environment.PropertiesSource)propertiesSource);
        return ContextCreator.create((JReleaserLogger)this.logger, (JReleaserContext.Configurer)this.resolveConfigurer(this.actualConfigFile), (JReleaserContext.Mode)this.getMode(), (JReleaserModel)model, (Path)this.actualBasedir, (Path)this.getOutputDirectory(), (boolean)this.dryrun(), (boolean)this.gitRootSearch, this.collectSelectedPlatforms());
    }

    protected JReleaserContext.Configurer resolveConfigurer(Path configFile) {
        switch (StringUtils.getFilenameExtension((String)configFile.getFileName().toString())) {
            case "yml": 
            case "yaml": {
                return JReleaserContext.Configurer.CLI_YAML;
            }
            case "toml": {
                return JReleaserContext.Configurer.CLI_TOML;
            }
            case "json": {
                return JReleaserContext.Configurer.CLI_JSON;
            }
        }
        throw new IllegalArgumentException(this.$("ERROR_invalid_config_format", configFile.getFileName()));
    }

    @Override
    protected Path getOutputDirectory() {
        return FileUtils.resolveOutputDirectory((Path)this.actualBasedir, (Path)this.outputdir, (String)"out");
    }

    protected boolean dryrun() {
        return false;
    }

    private Set<String> getSupportedConfigFormats() {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            extensions.add("." + parser.getPreferredFileExtension());
        }
        return extensions;
    }

    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.FULL;
    }

    protected List<String> collectSelectedPlatforms() {
        return Collections.emptyList();
    }

    protected Properties collectProperties() {
        Properties props = new Properties();
        if (this.properties != null && this.properties.length > 0) {
            for (String property : this.properties) {
                if (property.contains("=")) {
                    int d = property.indexOf(61);
                    if (d == 0 || d == this.properties.length - 1) {
                        throw new IllegalArgumentException(this.$("ERROR_invalid_property", property));
                    }
                    props.put(property.substring(0, d), property.substring(d + 1));
                    continue;
                }
                props.put(property, Boolean.TRUE);
            }
        }
        return props;
    }
}

