/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class TelegramAnnouncer
extends AbstractAnnouncer<TelegramAnnouncer, org.jreleaser.model.api.announce.TelegramAnnouncer> {
    private String token;
    private String chatId;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.TelegramAnnouncer immutable = new org.jreleaser.model.api.announce.TelegramAnnouncer(){

        public String getType() {
            return "telegram";
        }

        public String getToken() {
            return TelegramAnnouncer.this.token;
        }

        public String getChatId() {
            return TelegramAnnouncer.this.chatId;
        }

        public String getMessage() {
            return TelegramAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return TelegramAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return TelegramAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return TelegramAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return TelegramAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return TelegramAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(TelegramAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return TelegramAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(TelegramAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return TelegramAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return TelegramAnnouncer.this.readTimeout;
        }
    };

    public TelegramAnnouncer() {
        super("telegram");
    }

    @Override
    public org.jreleaser.model.api.announce.TelegramAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(TelegramAnnouncer source) {
        super.merge(source);
        this.token = this.merge(this.token, source.token);
        this.chatId = this.merge(this.chatId, source.chatId);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedToken() {
        return Env.env((String)"TELEGRAM_TOKEN", (String)this.token);
    }

    public String getResolvedChatId() {
        return Env.env((String)"TELEGRAM_CHAT_ID", (String)this.chatId);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        props.put("chatId", StringUtils.isNotBlank((String)this.getResolvedChatId()) ? "************" : "**unset**");
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

