/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.download.AbstractDownloader;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.FtpDownloader;
import org.jreleaser.model.internal.download.HttpDownloader;
import org.jreleaser.model.internal.download.ScpDownloader;
import org.jreleaser.model.internal.download.SftpDownloader;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;

public final class Download
extends AbstractModelObject<Download>
implements Domain,
Activatable {
    private final Map<String, FtpDownloader> ftp = new LinkedHashMap<String, FtpDownloader>();
    private final Map<String, HttpDownloader> http = new LinkedHashMap<String, HttpDownloader>();
    private final Map<String, ScpDownloader> scp = new LinkedHashMap<String, ScpDownloader>();
    private final Map<String, SftpDownloader> sftp = new LinkedHashMap<String, SftpDownloader>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;
    private final org.jreleaser.model.api.download.Download immutable = new org.jreleaser.model.api.download.Download(){
        private Map<String, ? extends org.jreleaser.model.api.download.FtpDownloader> ftp;
        private Map<String, ? extends org.jreleaser.model.api.download.HttpDownloader> http;
        private Map<String, ? extends org.jreleaser.model.api.download.ScpDownloader> scp;
        private Map<String, ? extends org.jreleaser.model.api.download.SftpDownloader> sftp;

        public Map<String, ? extends org.jreleaser.model.api.download.FtpDownloader> getFtp() {
            if (null == this.ftp) {
                this.ftp = Download.this.ftp.values().stream().map(FtpDownloader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.download.Downloader::getName, Function.identity()));
            }
            return this.ftp;
        }

        public Map<String, ? extends org.jreleaser.model.api.download.HttpDownloader> getHttp() {
            if (null == this.http) {
                this.http = Download.this.http.values().stream().map(HttpDownloader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.download.Downloader::getName, Function.identity()));
            }
            return this.http;
        }

        public Map<String, ? extends org.jreleaser.model.api.download.ScpDownloader> getScp() {
            if (null == this.scp) {
                this.scp = Download.this.scp.values().stream().map(ScpDownloader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.download.Downloader::getName, Function.identity()));
            }
            return this.scp;
        }

        public Map<String, ? extends org.jreleaser.model.api.download.SftpDownloader> getSftp() {
            if (null == this.sftp) {
                this.sftp = Download.this.sftp.values().stream().map(SftpDownloader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.download.Downloader::getName, Function.identity()));
            }
            return this.sftp;
        }

        public Active getActive() {
            return Download.this.active;
        }

        public boolean isEnabled() {
            return Download.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Download.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.download.Download asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Download source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setFtp(this.mergeModel(this.ftp, source.ftp));
        this.setHttp(this.mergeModel(this.http, source.http));
        this.setScp(this.mergeModel(this.scp, source.scp));
        this.setSftp(this.mergeModel(this.sftp, source.sftp));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.active != null;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"download.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public List<FtpDownloader> getActiveFtps() {
        return this.ftp.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, FtpDownloader> getFtp() {
        return this.ftp;
    }

    public void setFtp(Map<String, FtpDownloader> ftp) {
        this.ftp.clear();
        this.ftp.putAll(ftp);
    }

    public void addFtp(FtpDownloader ftp) {
        this.ftp.put(ftp.getName(), ftp);
    }

    public List<HttpDownloader> getActiveHttps() {
        return this.http.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, HttpDownloader> getHttp() {
        return this.http;
    }

    public void setHttp(Map<String, HttpDownloader> http) {
        this.http.clear();
        this.http.putAll(http);
    }

    public void addHttp(HttpDownloader http) {
        this.http.put(http.getName(), http);
    }

    public List<ScpDownloader> getActiveScps() {
        return this.scp.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ScpDownloader> getScp() {
        return this.scp;
    }

    public void setScp(Map<String, ScpDownloader> scp) {
        this.scp.clear();
        this.scp.putAll(scp);
    }

    public void addScp(ScpDownloader scp) {
        this.scp.put(scp.getName(), scp);
    }

    public List<SftpDownloader> getActiveSftps() {
        return this.sftp.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, SftpDownloader> getSftp() {
        return this.sftp;
    }

    public void setSftp(Map<String, SftpDownloader> sftp) {
        this.sftp.clear();
        this.sftp.putAll(sftp);
    }

    public void addSftp(SftpDownloader sftp) {
        this.sftp.put(sftp.getName(), sftp);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List sftp;
        List scp;
        List http;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.enabled);
        map.put("active", this.active);
        List ftp = this.ftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!ftp.isEmpty()) {
            map.put("ftp", ftp);
        }
        if (!(http = this.http.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("http", http);
        }
        if (!(scp = this.scp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("scp", scp);
        }
        if (!(sftp = this.sftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("sftp", sftp);
        }
        return map;
    }

    public <A extends Downloader<?>> Map<String, A> findDownloadersByType(String downloaderType) {
        switch (downloaderType) {
            case "ftp": {
                return this.ftp;
            }
            case "http": {
                return this.http;
            }
            case "scp": {
                return this.scp;
            }
            case "sftp": {
                return this.sftp;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Downloader<?>> List<A> findAllActiveDownloaders() {
        ArrayList<AbstractDownloader> downloaders = new ArrayList<AbstractDownloader>();
        downloaders.addAll(this.getActiveFtps());
        downloaders.addAll(this.getActiveHttps());
        downloaders.addAll(this.getActiveScps());
        downloaders.addAll(this.getActiveSftps());
        return downloaders;
    }
}

