/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.webhooks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class WebhooksAnnouncer
implements Announcer<org.jreleaser.model.api.announce.WebhooksAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.WebhooksAnnouncer webhooks;

    public WebhooksAnnouncer(JReleaserContext context) {
        this.context = context;
        this.webhooks = context.getModel().getAnnounce().getConfiguredWebhooks();
    }

    public org.jreleaser.model.api.announce.WebhooksAnnouncer getAnnouncer() {
        return this.webhooks.asImmutable();
    }

    public String getName() {
        return "webhooks";
    }

    public boolean isEnabled() {
        return this.webhooks.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce() throws AnnounceException {
        Map webhooks = this.webhooks.getWebhooks();
        for (Map.Entry e : webhooks.entrySet()) {
            if (!((WebhookAnnouncer)e.getValue()).isEnabled()) continue;
            this.context.getLogger().setPrefix("webhook." + (String)e.getKey());
            try {
                this.announce((WebhookAnnouncer)e.getValue());
            }
            catch (AnnounceException x) {
                this.context.getLogger().warn(x.getMessage().trim());
            }
            finally {
                this.context.getLogger().restorePrefix();
            }
        }
    }

    public void announce(WebhookAnnouncer webhook) throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)webhook.getMessage())) {
            message = webhook.getResolvedMessage(this.context);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                message = objectMapper.writeValueAsString((Object)CollectionUtils.mapOf((Object[])new Object[]{webhook.getMessageProperty(), message}));
            }
            catch (JsonProcessingException e) {
                throw new AnnounceException(RB.$((String)"ERROR_unexpected_json_format", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = webhook.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            this.fireAnnouncerEvent(ExecutionEvent.before((String)JReleaserCommand.ANNOUNCE.toStep()), webhook);
            try {
                ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)webhook.getResolvedWebhook(), (int)webhook.getConnectTimeout(), (int)webhook.getReadTimeout(), (String)message);
                this.fireAnnouncerEvent(ExecutionEvent.success((String)JReleaserCommand.ANNOUNCE.toStep()), webhook);
            }
            catch (RuntimeException e) {
                this.fireAnnouncerEvent(ExecutionEvent.failure((String)JReleaserCommand.ANNOUNCE.toStep(), (Throwable)e), webhook);
                throw e;
            }
        }
    }

    private void fireAnnouncerEvent(ExecutionEvent event, WebhookAnnouncer webhook) {
        try {
            this.context.fireAnnounceStepEvent(event, (org.jreleaser.model.api.announce.Announcer)webhook.asImmutable());
        }
        catch (WorkflowListenerException e) {
            this.context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
            this.context.getLogger().trace((Throwable)e);
        }
    }
}

