/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="publish")
public class Publish
extends AbstractPlatformAwareModelCommand {
    @CommandLine.Option(names={"--dry-run"})
    Boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedPackagers(this.collectEntries(this.composite.includedPackagers(), true));
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setExcludedPackagers(this.collectEntries(this.composite.excludedPackagers(), true));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
        }
        Workflows.publish((JReleaserContext)context).execute();
    }

    @Override
    protected Boolean dryrun() {
        return this.dryrun;
    }

    static class Exclude {
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;
        @CommandLine.Option(names={"-xp", "--exclude-packager"}, paramLabel="<packager>")
        String[] excludedPackagers;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;
        @CommandLine.Option(names={"-p", "--packager"}, paramLabel="<packager>")
        String[] includedPackagers;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedPackagers() {
            return this.include != null ? this.include.includedPackagers : null;
        }

        String[] includedDistributions() {
            return this.include != null ? this.include.includedDistributions : null;
        }

        String[] excludedPackagers() {
            return this.exclude != null ? this.exclude.excludedPackagers : null;
        }

        String[] excludedDistributions() {
            return this.exclude != null ? this.exclude.excludedDistributions : null;
        }
    }
}

