/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SlackAnnouncer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SlackAnnouncerValidator
extends Validator {
    private static final String DEFAULT_SLACK_TPL = "src/jreleaser/templates/slack.tpl";

    public static void validateSlack(JReleaserContext context, SlackAnnouncer slack, Errors errors) {
        context.getLogger().debug("announce.slack");
        if (!slack.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        Errors ignored = new Errors();
        slack.setToken(SlackAnnouncerValidator.checkProperty(context, "SLACK_TOKEN", "announce.slack.token", slack.getToken(), ignored, context.isDryrun()));
        slack.setWebhook(SlackAnnouncerValidator.checkProperty(context, "SLACK_WEBHOOK", "announce.slack.webhook", slack.getWebhook(), ignored, context.isDryrun()));
        String token = slack.getToken();
        String webhook = slack.getWebhook();
        if (!context.isDryrun() && StringUtils.isBlank((String)token) && StringUtils.isBlank((String)webhook)) {
            errors.configuration(RB.$((String)"validation_slack_token", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)slack.getChannel())) {
            slack.setChannel("#announce");
        }
        if (StringUtils.isBlank((String)slack.getMessage()) && StringUtils.isBlank((String)slack.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_SLACK_TPL), new LinkOption[0])) {
                slack.setMessageTemplate(DEFAULT_SLACK_TPL);
            } else {
                slack.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)slack.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(slack.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"slack.messageTemplate ", slack.getMessageTemplate()}));
        }
        SlackAnnouncerValidator.validateTimeout(slack);
    }
}

