/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Locale;
import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GithubMavenDeployerValidator
extends Validator {
    public static void validateGithubMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GithubMavenDeployer> github = context.getModel().getDeploy().getMaven().getGithub();
        if (!github.isEmpty()) {
            context.getLogger().debug("deploy.maven.github");
        }
        for (Map.Entry<String, GithubMavenDeployer> e : github.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            GithubMavenDeployerValidator.validateGithubMavenDeployer(context, mode, e.getValue(), errors);
        }
    }

    private static void validateGithubMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, GithubMavenDeployer mavenDeployer, Errors errors) {
        if (StringUtils.isBlank((String)mavenDeployer.getUrl())) {
            mavenDeployer.setUrl("https://maven.pkg.github.com/{{owner}}/{{repository}}");
        }
        MavenDeployersValidator.validateMavenDeployer(context, mode, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        String baseEnvKey = mavenDeployer.getType().toUpperCase(Locale.ENGLISH);
        mavenDeployer.setUsername(GithubMavenDeployerValidator.checkProperty(context, baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_USERNAME", "maven.deploy." + mavenDeployer.getType() + ".username", mavenDeployer.getUsername(), errors, true));
        if (StringUtils.isBlank((String)mavenDeployer.getUsername())) {
            mavenDeployer.setUsername(context.getModel().getRelease().getReleaser().getUsername());
        }
        if (StringUtils.isBlank((String)mavenDeployer.getRepository())) {
            mavenDeployer.setRepository(context.getModel().getRelease().getReleaser().getName());
        }
    }
}

