/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.checksum;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.StringUtils;

public class Checksum {
    public static void collectAndWriteChecksums(JReleaserContext context) throws JReleaserException {
        context.getLogger().info(RB.$((String)"checksum.header", (Object[])new Object[0]));
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("checksum");
        LinkedHashMap<Algorithm, List> checksums = new LinkedHashMap<Algorithm, List>();
        if (context.getModel().getChecksum().isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)context)) {
                if (!artifact.isActive()) continue;
                artifact.getEffectivePath(context);
                if (artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                    Checksum.readHash(context, algorithm, artifact);
                    List list = checksums.computeIfAbsent(algorithm, k -> new ArrayList());
                    list.add(artifact.getHash(algorithm) + "  " + artifact.getEffectivePath(context).getFileName());
                }
            }
        }
        for (Distribution distribution : context.getModel().getActiveDistributions()) {
            for (Artifact artifact : distribution.getArtifacts()) {
                if (!artifact.isActive()) continue;
                artifact.getEffectivePath(context, distribution);
                for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                    Checksum.readHash(context, distribution, algorithm, artifact);
                    List list = checksums.computeIfAbsent(algorithm, k -> new ArrayList());
                    list.add(artifact.getHash(algorithm) + "  " + artifact.getEffectivePath(context, distribution).getFileName());
                }
            }
        }
        if (checksums.isEmpty()) {
            context.getLogger().info(RB.$((String)"checksum.not.enabled", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        for (Map.Entry entry : checksums.entrySet()) {
            Algorithm algorithm = (Algorithm)entry.getKey();
            List list = (List)entry.getValue();
            Path checksumsFilePath = context.getChecksumsDirectory().resolve(context.getModel().getChecksum().getResolvedName(context, algorithm));
            String newContent = String.join((CharSequence)System.lineSeparator(), list) + System.lineSeparator();
            try {
                String oldContent;
                if (Files.exists(checksumsFilePath, new LinkOption[0]) && newContent.equals(oldContent = new String(Files.readAllBytes(checksumsFilePath), StandardCharsets.UTF_8))) {
                    context.getLogger().info(RB.$((String)"checksum.not.changed", (Object[])new Object[0]));
                    context.getLogger().restorePrefix();
                    context.getLogger().decreaseIndent();
                    return;
                }
            }
            catch (IOException oldContent) {
                // empty catch block
            }
            try {
                if (StringUtils.isNotBlank((String)newContent)) {
                    Files.createDirectories(context.getChecksumsDirectory(), new FileAttribute[0]);
                    Files.write(checksumsFilePath, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    continue;
                }
                Files.deleteIfExists(checksumsFilePath);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_checksum", (Object[])new Object[]{checksumsFilePath.toAbsolutePath()}), (Throwable)e);
            }
        }
        context.getLogger().restorePrefix();
        context.getLogger().decreaseIndent();
    }

    public static void readHash(JReleaserContext context, Distribution distribution, Algorithm algorithm, Artifact artifact) throws JReleaserException {
        Path artifactPath = artifact.getEffectivePath(context, distribution);
        Path checksumPath = context.getChecksumsDirectory().resolve(distribution.getName()).resolve(artifactPath.getFileName() + "." + algorithm.formatted());
        Checksum.readHash(context, algorithm, artifact, artifactPath, checksumPath);
    }

    public static void readHash(JReleaserContext context, Algorithm algorithm, Artifact artifact) throws JReleaserException {
        Path artifactPath = artifact.getEffectivePath(context);
        Path checksumPath = context.getChecksumsDirectory().resolve(artifactPath.getFileName() + "." + algorithm.formatted());
        Checksum.readHash(context, algorithm, artifact, artifactPath, checksumPath);
    }

    private static void readHash(JReleaserContext context, Algorithm algorithm, Artifact artifact, Path artifactPath, Path checksumPath) throws JReleaserException {
        if (!Files.exists(artifactPath, new LinkOption[0])) {
            throw new JReleaserException(RB.$((String)"ERROR_artifact_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(artifactPath)}));
        }
        if (!Files.exists(checksumPath, new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"checksum.not.exist", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(checksumPath)});
            Checksum.calculateHash(context, artifactPath, checksumPath, algorithm);
        } else if (artifactPath.toFile().lastModified() > checksumPath.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"checksum.file.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(artifactPath), context.relativizeToBasedir(checksumPath)});
            Checksum.calculateHash(context, artifactPath, checksumPath, algorithm);
        }
        try {
            context.getLogger().debug(RB.$((String)"checksum.reading", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(checksumPath)});
            artifact.setHash(algorithm, new String(Files.readAllBytes(checksumPath), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_hash_read", (Object[])new Object[]{context.relativizeToBasedir(checksumPath)}), (Throwable)e);
        }
    }

    public static String calculateHash(JReleaserContext context, Path input, Path output) throws JReleaserException {
        return Checksum.calculateHash(context, input, output, Algorithm.SHA_256);
    }

    public static String calculateHash(JReleaserContext context, Path input, Path output, Algorithm algorithm) throws JReleaserException {
        try {
            context.getLogger().info("{}.{}", new Object[]{context.relativizeToBasedir(input), algorithm.formatted()});
            String hashcode = ChecksumUtils.checksum((Algorithm)algorithm, (byte[])Files.readAllBytes(input));
            output.toFile().getParentFile().mkdirs();
            Files.write(output, hashcode.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return hashcode;
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_calculate_checksum", (Object[])new Object[]{input}), (Throwable)e);
        }
    }
}

