/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.packagers;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.model.api.packagers.PackagerRepository;
import org.jreleaser.model.api.packagers.RepositoryPackager;
import org.jreleaser.util.StringUtils;

public interface WingetPackager
extends RepositoryPackager {
    public static final String TYPE = "winget";
    public static final String SKIP_WINGET = "skipWinget";

    public Package getPackage();

    public Publisher getPublisher();

    public Installer getInstaller();

    public String getDefaultLocale();

    public String getAuthor();

    public String getMoniker();

    public List<String> getTags();

    public String getMinimumOsVersion();

    public String getProductCode();

    public PackagerRepository getRepository();

    public static interface Installer
    extends Domain {
        public Type getType();

        public Scope getScope();

        public Set<Mode> getModes();

        public UpgradeBehavior getUpgradeBehavior();

        public String getCommand();

        public static enum UpgradeBehavior {
            INSTALL("install"),
            UNINSTALL_PREVIOUS("uninstallPrevious");

            private final String alias;

            private UpgradeBehavior(String alias) {
                this.alias = alias;
            }

            public String toString() {
                return this.alias;
            }

            public static UpgradeBehavior of(String str) {
                if (StringUtils.isBlank((String)str)) {
                    return null;
                }
                String value = str.replace(" ", "").replace("-", "").replace("_", "").toUpperCase(Locale.ENGLISH).trim();
                for (UpgradeBehavior type : UpgradeBehavior.values()) {
                    if (!type.alias.toUpperCase(Locale.ENGLISH).equals(value)) continue;
                    return type;
                }
                return UpgradeBehavior.valueOf(value);
            }
        }

        public static enum Mode {
            INTERACTIVE("interactive"),
            SILENT("silent"),
            SILENT_WITH_PROGRESS("silentWithProgress");

            private final String alias;

            private Mode(String alias) {
                this.alias = alias;
            }

            public String toString() {
                return this.alias;
            }

            public static Mode of(String str) {
                if (StringUtils.isBlank((String)str)) {
                    return null;
                }
                String value = str.replace(" ", "").replace("-", "").replace("_", "").toUpperCase(Locale.ENGLISH).trim();
                for (Mode type : Mode.values()) {
                    if (!type.alias.toUpperCase(Locale.ENGLISH).equals(value)) continue;
                    return type;
                }
                return Mode.valueOf(value);
            }
        }

        public static enum Scope {
            USER,
            MACHINE;


            public String toString() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }

            public static Scope of(String str) {
                if (StringUtils.isBlank((String)str)) {
                    return null;
                }
                return Scope.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
            }
        }

        public static enum Type {
            MSIX,
            MSI,
            APPX,
            EXE,
            ZIP,
            INNO,
            NULLSOFT,
            WIX,
            BURN,
            PWA;


            public String toString() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }

            public static Type of(String str) {
                if (StringUtils.isBlank((String)str)) {
                    return null;
                }
                return Type.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
            }
        }
    }

    public static interface Publisher
    extends Domain {
        public String getName();

        public String getUrl();

        public String getSupportUrl();
    }

    public static interface Package
    extends Domain {
        public String getIdentifier();

        public String getVersion();

        public String getName();

        public String getUrl();
    }
}

