/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.DiscourseAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class DiscourseAnnouncerValidator {
    private static final String DEFAULT_DISCOURSE_TPL = "src/jreleaser/templates/discourse.tpl";

    private DiscourseAnnouncerValidator() {
    }

    public static void validateDiscourse(JReleaserContext context, DiscourseAnnouncer discourse, Errors errors) {
        context.getLogger().debug("announce.discourse");
        Validator.resolveActivatable(context, (Activatable)discourse, "announce.discourse", "NEVER");
        if (!discourse.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)discourse.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discourse.host"}));
        }
        discourse.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discourse.username", "DISCOURSE_USERNAME"}), "announce.discourse.username", discourse.getUsername(), errors, context.isDryrun()));
        discourse.setApiKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discourse.api.key", "DISCOURSE_API_KEY"}), "announce.discourse.apiKey", discourse.getApiKey(), errors, context.isDryrun()));
        discourse.setCategoryName(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discourse.category", "DISCOURSE_CATEGORY_NAME"}), "announce.discourse.category", discourse.getCategoryName(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)discourse.getTitle())) {
            discourse.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)discourse.getMessage()) && StringUtils.isBlank((String)discourse.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCOURSE_TPL), new LinkOption[0])) {
                discourse.setMessageTemplate(DEFAULT_DISCOURSE_TPL);
            } else {
                discourse.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)discourse.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(discourse.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"discourse.messageTemplate", discourse.getMessageTemplate()}));
        }
        Validator.validateTimeout(discourse);
    }
}

