/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class JavaArchiveAssemblerValidator {
    private JavaArchiveAssemblerValidator() {
    }

    public static void validateJavaArchive(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JavaArchiveAssembler> archive = context.getModel().getAssemble().getJavaArchive();
        if (!archive.isEmpty()) {
            context.getLogger().debug("assemble.java-archive");
        }
        for (Map.Entry<String, JavaArchiveAssembler> e : archive.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JavaArchiveAssemblerValidator.validateJavaArchive(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJavaArchive(JReleaserContext context, JReleaserContext.Mode mode, JavaArchiveAssembler archive, Errors errors) {
        context.getLogger().debug("assemble.java-archive.{}", new Object[]{archive.getName()});
        Validator.resolveActivatable(context, (Activatable)archive, CollectionUtils.listOf((Object[])new String[]{"assemble.java.archive." + archive.getName(), "assemble.java.archive"}), "NEVER");
        if (!archive.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)archive.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"java-archive.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            archive.disable();
            return;
        }
        if (StringUtils.isBlank((String)archive.getArchiveName())) {
            archive.setArchiveName("{{distributionName}}-{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)archive.getExecutable().getName())) {
            archive.getExecutable().setName(archive.getName());
        }
        if (StringUtils.isBlank((String)archive.getExecutable().getWindowsExtension())) {
            archive.getExecutable().setWindowsExtension("bat");
        }
        if (archive.getFormats().isEmpty()) {
            archive.addFormat(Archive.Format.ZIP);
        }
        if (archive.getJars().isEmpty() && StringUtils.isBlank((String)archive.getMainJar().getPath())) {
            errors.configuration(RB.$((String)"validation_java_archive_empty_jars", (Object[])new Object[]{archive.getName()}));
        } else {
            Validator.validateGlobs(archive.getJars(), "java-archive." + archive.getName() + ".jars", errors);
        }
        AssemblersValidator.validateAssembler(context, mode, archive, errors);
        context.getLogger().debug("assemble.java-archive.{}.java", new Object[]{archive.getName()});
        Project project = context.getModel().getProject();
        boolean mainJarIsSet = StringUtils.isNotBlank((String)archive.getMainJar().getPath());
        if (!mainJarIsSet) {
            if (StringUtils.isBlank((String)archive.getJava().getMainModule())) {
                archive.getJava().setMainModule(project.getJava().getMainModule());
            }
            if (StringUtils.isBlank((String)archive.getJava().getMainClass())) {
                archive.getJava().setMainClass(project.getJava().getMainClass());
            }
        }
        boolean mainClassIsSet = StringUtils.isNotBlank((String)archive.getJava().getMainClass());
        if (!mainJarIsSet && !mainClassIsSet) {
            errors.configuration(RB.$((String)"validation_java_archive_main_jar_or_class_missing", (Object[])new Object[]{archive.getName(), archive.getName()}));
        }
    }
}

