/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.assemble.AssemblersValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class JlinkAssemblerValidator {
    private JlinkAssemblerValidator() {
    }

    public static void validateJlink(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JlinkAssembler> jlink = context.getModel().getAssemble().getJlink();
        if (!jlink.isEmpty()) {
            context.getLogger().debug("assemble.jlink");
        }
        for (Map.Entry<String, JlinkAssembler> e : jlink.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JlinkAssemblerValidator.validateJlink(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJlink(JReleaserContext context, JReleaserContext.Mode mode, JlinkAssembler jlink, Errors errors) {
        context.getLogger().debug("assemble.jlink.{}", new Object[]{jlink.getName()});
        Validator.resolveActivatable(context, (Activatable)jlink, CollectionUtils.listOf((Object[])new String[]{"assemble.jlink." + jlink.getName(), "assemble.jlink"}), "NEVER");
        if (!jlink.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)jlink.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jlink.name"}));
            return;
        }
        context.getLogger().debug("assemble.jlink.{}.java", new Object[]{jlink.getName()});
        if (!JlinkAssemblerValidator.validateJava(context, jlink, errors)) {
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            jlink.disable();
            return;
        }
        jlink.setPlatform(jlink.getPlatform().mergeValues(context.getModel().getPlatform()));
        if (StringUtils.isBlank((String)jlink.getImageName())) {
            jlink.setImageName(jlink.getJava().getGroupId() + "." + jlink.getJava().getArtifactId() + "-" + context.getModel().getProject().getResolvedVersion());
        }
        if (StringUtils.isBlank((String)jlink.getExecutable())) {
            jlink.setExecutable(jlink.getName());
        }
        int i = 0;
        for (Artifact targetJdk : jlink.getTargetJdks()) {
            JlinkAssemblerValidator.validateJdk(context, mode, jlink, targetJdk, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = jlink.getTargetJdks().stream().collect(Collectors.groupingBy(jdk -> StringUtils.isBlank((String)jdk.getPlatform()) ? "<nil>" : jdk.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_jlink_jdk_platform", (Object[])new Object[]{jlink.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_jlink_jdk_multiple_platforms", (Object[])new Object[]{jlink.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)jlink.getJdk().getPath())) {
            String currentPlatform = PlatformUtils.getCurrentFull();
            String javaHome = System.getProperty("java.home");
            if (jlink.getTargetJdks().isEmpty()) {
                if (StringUtils.isBlank((String)javaHome)) {
                    errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                    return;
                }
                jlink.getJdk().setPath(javaHome);
                jlink.getJdk().setPlatform(currentPlatform);
                jlink.addTargetJdk(jlink.getJdk());
            } else {
                Optional<Artifact> jdk2 = jlink.getTargetJdks().stream().filter(j -> PlatformUtils.isCompatible((String)currentPlatform, (String)j.getPlatform())).findFirst();
                if (jdk2.isPresent()) {
                    jlink.setJdk(jdk2.get());
                } else {
                    if (StringUtils.isBlank((String)javaHome)) {
                        errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                        return;
                    }
                    jlink.getJdk().setPath(javaHome);
                    jlink.getJdk().setPlatform(currentPlatform);
                }
            }
        }
        if (jlink.getArgs().isEmpty()) {
            jlink.getArgs().add("--no-header-files");
            jlink.getArgs().add("--no-man-pages");
            jlink.getArgs().add("--compress=2");
            jlink.getArgs().add("--strip-debug");
        }
        if (null == jlink.getMainJar()) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".mainJar"}));
            return;
        }
        if (null == jlink.getArchiveFormat()) {
            jlink.setArchiveFormat(Archive.Format.ZIP);
        }
        AssemblersValidator.validateJavaAssembler(context, mode, jlink, errors, true);
        if (!jlink.getJdeps().isEnabledSet()) {
            jlink.getJdeps().setEnabled(true);
        }
        if (!jlink.getJdeps().isEnabled() && jlink.getModuleNames().isEmpty()) {
            jlink.getModuleNames().add("java.base");
        }
        if (!jlink.getModuleNames().isEmpty()) {
            jlink.getJdeps().setEnabled(false);
        }
    }

    private static boolean validateJava(JReleaserContext context, JlinkAssembler jlink, Errors errors) {
        Project project = context.getModel().getProject();
        if (!jlink.getJava().isEnabledSet() && project.getJava().isEnabledSet()) {
            jlink.getJava().setEnabled(project.getJava().isEnabled());
        }
        if (!jlink.getJava().isEnabledSet()) {
            jlink.getJava().setEnabled(jlink.getJava().isSet());
        }
        if (!jlink.getJava().isEnabled()) {
            return false;
        }
        if (StringUtils.isBlank((String)jlink.getJava().getArtifactId())) {
            jlink.getJava().setArtifactId(project.getJava().getArtifactId());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getGroupId())) {
            jlink.getJava().setGroupId(project.getJava().getGroupId());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getVersion())) {
            jlink.getJava().setVersion(project.getJava().getVersion());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getMainModule())) {
            jlink.getJava().setMainModule(project.getJava().getMainModule());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getMainClass())) {
            jlink.getJava().setMainClass(project.getJava().getMainClass());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jlink." + jlink.getName() + ".java.groupId"}));
        }
        return true;
    }

    private static void validateJdk(JReleaserContext context, JReleaserContext.Mode mode, JlinkAssembler jlink, Artifact jdk, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == jdk) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "]"}));
            return;
        }
        if (StringUtils.isBlank((String)jdk.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "].path"}));
        }
        if (StringUtils.isBlank((String)jdk.getPlatform())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "].platform"}));
        }
        if (StringUtils.isNotBlank((String)jdk.getPlatform()) && !PlatformUtils.isSupported((String)jdk.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_jlink_platform", (Object[])new Object[]{jlink.getName(), index, jdk.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }
}

