/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;

public class GHCompare {
    private String url;
    private String html_url;
    private String permalink_url;
    private String diff_url;
    private String patch_url;
    public Status status;
    private int ahead_by;
    private int behind_by;
    private int total_commits;
    private Commit base_commit;
    private Commit merge_base_commit;
    private Commit[] commits;
    private GHCommit.File[] files;
    private GHRepository owner;

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public URL getPermalinkUrl() {
        return GitHubClient.parseURL(this.permalink_url);
    }

    public URL getDiffUrl() {
        return GitHubClient.parseURL(this.diff_url);
    }

    public URL getPatchUrl() {
        return GitHubClient.parseURL(this.patch_url);
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAheadBy() {
        return this.ahead_by;
    }

    public int getBehindBy() {
        return this.behind_by;
    }

    public int getTotalCommits() {
        return this.total_commits;
    }

    public Commit getBaseCommit() {
        return this.base_commit;
    }

    public Commit getMergeBaseCommit() {
        return this.merge_base_commit;
    }

    public Commit[] getCommits() {
        Commit[] newValue = new Commit[this.commits.length];
        System.arraycopy(this.commits, 0, newValue, 0, this.commits.length);
        return newValue;
    }

    public GHCommit.File[] getFiles() {
        GHCommit.File[] newValue = new GHCommit.File[this.files.length];
        System.arraycopy(this.files, 0, newValue, 0, this.files.length);
        return newValue;
    }

    public GHCompare wrap(GHRepository owner) {
        this.owner = owner;
        for (Commit commit : this.commits) {
            commit.wrapUp(owner);
        }
        this.merge_base_commit.wrapUp(owner);
        this.base_commit.wrapUp(owner);
        return this;
    }

    public static enum Status {
        behind,
        ahead,
        identical,
        diverged;

    }

    public static class User
    extends GitUser {
    }

    public static class Tree {
        private String url;
        private String sha;

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }
    }

    @BridgeMethodsAdded
    public static class InnerCommit {
        private String url;
        private String sha;
        private String message;
        private User author;
        private User committer;
        private Tree tree;

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }

        public String getMessage() {
            return this.message;
        }

        @WithBridgeMethods(value={User.class}, castRequired=true)
        public GitUser getAuthor() {
            return this.author;
        }

        @WithBridgeMethods(value={User.class}, castRequired=true)
        public GitUser getCommitter() {
            return this.committer;
        }

        public Tree getTree() {
            return this.tree;
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class Commit
    extends GHCommit {
        private InnerCommit commit;

        public InnerCommit getCommit() {
            return this.commit;
        }
    }
}

