/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.hooks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.util.PlatformUtils;

public final class CommandHookExecutor {
    private final JReleaserContext context;

    public CommandHookExecutor(JReleaserContext context) {
        this.context = context;
    }

    public void execute(String step, Runnable runnable) {
        this.executeHooks(ExecutionEvent.before((String)step));
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            this.executeHooks(ExecutionEvent.failure((String)step, (Throwable)e));
            throw e;
        }
        this.executeHooks(ExecutionEvent.success((String)step));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHooks(ExecutionEvent event) {
        if (!this.context.getModel().getHooks().isEnabled()) {
            return;
        }
        CommandHooks commandHooks = this.context.getModel().getHooks().getCommand();
        if (!this.context.getModel().getHooks().getCommand().isEnabled()) {
            return;
        }
        ArrayList<Object> hooks = new ArrayList<Object>();
        switch (event.getType()) {
            case BEFORE: {
                hooks.addAll(this.filter(commandHooks.getBefore(), event));
                break;
            }
            case SUCCESS: {
                hooks.addAll(this.filter(commandHooks.getSuccess(), event));
                break;
            }
            case FAILURE: {
                hooks.addAll(this.filter(commandHooks.getFailure(), event));
            }
        }
        if (!hooks.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"hooks.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
        }
        this.context.getLogger().setPrefix("hooks");
        this.context.getLogger().increaseIndent();
        try {
            for (CommandHook commandHook : hooks) {
                String resolvedCmd = commandHook.getResolvedCmd(this.context, event);
                List<String> commandLine = null;
                try {
                    commandLine = CommandHookExecutor.parseCommand(resolvedCmd);
                }
                catch (IllegalStateException e) {
                    throw new JReleaserException(RB.$((String)"ERROR_command_hook_parser_error", (Object[])new Object[]{commandHook.getCmd()}), (Throwable)e);
                }
                try {
                    Command command = new Command(commandLine);
                    this.executeCommand(this.context.getBasedir(), command);
                }
                catch (CommandException e) {
                    if (!commandHook.isContinueOnError()) {
                        throw new JReleaserException(RB.$((String)"ERROR_command_hook_unexpected_error", (Object[])new Object[0]), (Throwable)e);
                    }
                    if (null != e.getCause()) {
                        this.context.getLogger().warn(e.getCause().getMessage());
                    } else {
                        this.context.getLogger().warn(e.getMessage());
                    }
                    this.context.getLogger().trace(RB.$((String)"ERROR_command_hook_unexpected_error", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
        finally {
            this.context.getLogger().decreaseIndent();
            this.context.getLogger().restorePrefix();
        }
    }

    private Collection<? extends CommandHook> filter(List<CommandHook> hooks, ExecutionEvent event) {
        ArrayList<CommandHook> tmp = new ArrayList<CommandHook>();
        for (CommandHook hook : hooks) {
            if (!hook.isEnabled()) continue;
            if (!hook.getFilter().getResolvedIncludes().isEmpty()) {
                if (hook.getFilter().getResolvedIncludes().contains(event.getName()) && this.filterByPlatform(hook)) {
                    tmp.add(hook);
                }
            } else if (this.filterByPlatform(hook)) {
                tmp.add(hook);
            }
            if (!hook.getFilter().getResolvedExcludes().contains(event.getName())) continue;
            tmp.remove(hook);
        }
        return tmp;
    }

    private boolean filterByPlatform(CommandHook hook) {
        if (hook.getPlatforms().isEmpty()) {
            return true;
        }
        boolean success = true;
        for (String platform : hook.getPlatforms()) {
            boolean exclude = false;
            if (platform.startsWith("!")) {
                exclude = true;
                platform = platform.substring(1);
            }
            success &= exclude != PlatformUtils.isCompatible((String)PlatformUtils.getCurrentFull(), (String)platform);
        }
        return success;
    }

    private void executeCommand(Path directory, Command command) throws CommandException {
        int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(directory, command);
        if (exitValue != 0) {
            throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
        }
    }

    public static List<String> parseCommand(String str) {
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(str, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() > 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalStateException(RB.$((String)"ERROR_unbalanced_quotes", (Object[])new Object[]{str}));
        }
        return result;
    }
}

