/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.BrewPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class BrewPackagerProcessor
extends AbstractRepositoryPackagerProcessor<BrewPackager> {
    private static final String KEY_DISTRIBUTION_CHECKSUM_SHA_256 = "distributionChecksumSha256";
    private static final String TPL_MAC_ARM = "  if OS.mac? && Hardware::CPU.arm?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_MAC_INTEL = "  if OS.mac? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_ARM = "  if OS.linux? && Hardware::CPU.arm? && Hardware::CPU.is_64_bit?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_INTEL = "  if OS.linux? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_MAC_ARM_FLAT_BINARY = "  if OS.mac? && Hardware::CPU.arm?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String TPL_MAC_INTEL_FLAT_BINARY = "  if OS.mac? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String TPL_LINUX_ARM_FLAT_BINARY = "  if OS.linux? && Hardware::CPU.arm? && Hardware::CPU.is_64_bit?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String TPL_LINUX_INTEL_FLAT_BINARY = "  if OS.linux? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String CASK_RB = "cask.rb";
    private static final String CASKS = "Casks";
    private static final String FORMULA = "Formula";
    private static final String FORMULA_RB = "formula.rb";
    private static final String FORMULA_MULTI_RB = "formula-multi.rb";
    private static final String RB = ".rb";
    private static final String SKIP_JAVA = "skipJava";

    public BrewPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        BrewPackager.Cask cask;
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.set("brewFormulaName", (Object)((BrewPackager)this.packager).getResolvedFormulaName(props));
        props.set("brewTapRepoOwner", (Object)((BrewPackager)this.packager).getTap().getOwner());
        props.set("brewTapRepoName", (Object)((BrewPackager)this.packager).getTap().getResolvedName());
        props.set("brewTapName", (Object)((BrewPackager)this.packager).getTap().getResolvedName().substring("homebrew-".length()));
        props.set("brewTapRepoUrl", (Object)releaser.getResolvedRepoUrl(this.context.getModel(), ((BrewPackager)this.packager).getTap().getOwner(), ((BrewPackager)this.packager).getTap().getResolvedName()));
        props.set("brewTapRepoCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((BrewPackager)this.packager).getTap().getOwner(), ((BrewPackager)this.packager).getTap().getResolvedName()));
        props.set("brewHasLivecheck", (Object)((BrewPackager)this.packager).hasLivecheck());
        if (((BrewPackager)this.packager).hasLivecheck()) {
            props.set("brewLivecheck", ((BrewPackager)this.packager).getLivecheck().stream().map(line -> Templates.resolveTemplate((String)line, (TemplateContext)props)).map(MustacheUtils::passThrough).collect(Collectors.toList()));
        }
        if ((cask = ((BrewPackager)this.packager).getCask()).isEnabled()) {
            boolean hasPkg = StringUtils.isNotBlank((String)cask.getPkgName());
            boolean hasApp = StringUtils.isNotBlank((String)cask.getAppName());
            props.set("brewCaskName", (Object)cask.getResolvedCaskName(props));
            props.set("brewCaskDisplayName", (Object)cask.getResolvedDisplayName(props));
            props.set("brewCaskHasUninstall", (Object)(!cask.getUninstallItems().isEmpty() ? 1 : 0));
            props.set("brewCaskHasPkg", (Object)hasPkg);
            if (hasPkg) {
                props.set("brewCaskPkg", (Object)cask.getResolvedPkgName(props));
            }
            props.set("brewCaskHasApp", (Object)hasApp);
            if (hasApp) {
                props.set("brewCaskApp", (Object)cask.getResolvedAppName(props));
            }
            props.set("brewCaskUninstall", (Object)cask.getUninstallItems());
            props.set("brewCaskHasZap", (Object)(!cask.getZapItems().isEmpty() ? 1 : 0));
            props.set("brewCaskZap", (Object)cask.getZapItems());
            String appcast = cask.getResolvedAppcast(props);
            props.set("brewCaskHasAppcast", (Object)StringUtils.isNotBlank((String)appcast));
            props.set("brewCaskAppcast", (Object)appcast);
            if (!hasApp && !hasPkg) {
                for (Artifact artifact : this.collectArtifacts(distribution)) {
                    if (!artifact.getPath().endsWith(FileType.ZIP.extension())) continue;
                    props.set("distributionUrl", (Object)this.resolveArtifactUrl(distribution, artifact));
                    props.set("brewCaskHasBinary", (Object)true);
                    break;
                }
            }
        } else if (((BrewPackager)this.packager).isMultiPlatform()) {
            ArrayList<String> multiPlatforms = new ArrayList<String>();
            Artifact osxIntelArtifact = null;
            Artifact osxArmArtifact = null;
            boolean flatBinary = distribution.getType() == Distribution.DistributionType.FLAT_BINARY;
            for (Artifact artifact : this.collectArtifacts(distribution)) {
                if (!artifact.getPath().endsWith(FileType.ZIP.extension()) && !flatBinary || StringUtils.isBlank((String)artifact.getPlatform())) continue;
                String template = null;
                String artifactUrl = this.resolveArtifactUrl(distribution, artifact);
                String artifactFile = artifact.getEffectivePath().getFileName().toString();
                String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
                if (PlatformUtils.isMac((String)artifact.getPlatform())) {
                    if (PlatformUtils.isArm((String)artifact.getPlatform())) {
                        template = flatBinary ? TPL_MAC_ARM_FLAT_BINARY : TPL_MAC_ARM;
                        osxArmArtifact = artifact;
                    } else {
                        template = flatBinary ? TPL_MAC_INTEL_FLAT_BINARY : TPL_MAC_INTEL;
                        osxIntelArtifact = artifact;
                    }
                } else if (PlatformUtils.isLinux((String)artifact.getPlatform())) {
                    if (PlatformUtils.isArm((String)artifact.getPlatform())) {
                        template = flatBinary ? TPL_LINUX_ARM_FLAT_BINARY : TPL_LINUX_ARM;
                    } else {
                        String string = template = flatBinary ? TPL_LINUX_INTEL_FLAT_BINARY : TPL_LINUX_INTEL;
                    }
                }
                if (!StringUtils.isNotBlank(template)) continue;
                TemplateContext newProps = new TemplateContext(props);
                newProps.set("distributionUrl", (Object)artifactUrl);
                newProps.set("distributionArtifactFileName", (Object)artifactFileName);
                newProps.set(KEY_DISTRIBUTION_CHECKSUM_SHA_256, (Object)artifact.getHash(Algorithm.SHA_256));
                multiPlatforms.add(Templates.resolveTemplate((String)template, (TemplateContext)newProps));
            }
            if (null != osxIntelArtifact && null == osxArmArtifact) {
                String artifactUrl = this.resolveArtifactUrl(distribution, osxIntelArtifact);
                String artifactFile = osxIntelArtifact.getEffectivePath().getFileName().toString();
                String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
                TemplateContext newProps = new TemplateContext(props);
                newProps.set("distributionUrl", (Object)artifactUrl);
                newProps.set("distributionArtifactFileName", (Object)artifactFileName);
                newProps.set(KEY_DISTRIBUTION_CHECKSUM_SHA_256, (Object)osxIntelArtifact.getHash(Algorithm.SHA_256));
                multiPlatforms.add(Templates.resolveTemplate((String)(flatBinary ? TPL_LINUX_ARM_FLAT_BINARY : TPL_MAC_ARM), (TemplateContext)newProps));
            }
            if (multiPlatforms.isEmpty()) {
                throw new IllegalStateException(org.jreleaser.bundle.RB.$((String)"ERROR_brew_multiplatform_artifacts", (Object[])new Object[0]));
            }
            props.set("brewMultiPlatform", (Object)MustacheUtils.passThrough((String)String.join((CharSequence)(System.lineSeparator() + "  "), multiPlatforms)));
        } else if (!(distribution.getType() != Distribution.DistributionType.JAVA_BINARY && distribution.getType() != Distribution.DistributionType.SINGLE_JAR || StringUtils.isTrue(((BrewPackager)this.packager).getExtraProperties().get(SKIP_JAVA)))) {
            ((BrewPackager)this.packager).addDependency("openjdk@" + props.get("distributionJavaVersion"));
        }
        props.set("brewDependencies", ((BrewPackager)this.packager).getDependenciesAsList().stream().map(dependency -> MustacheUtils.passThrough((String)dependency.toString())).collect(Collectors.toList()));
    }

    private String resolveArtifactUrl(Distribution distribution, Artifact artifact) {
        return Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)"brew", (Distribution)distribution, (Artifact)artifact);
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        if (((BrewPackager)this.packager).getCask().isEnabled()) {
            if (FORMULA_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            this.writeFile(content, CASK_RB.equals(fileName) ? outputDirectory.resolve(CASKS).resolve(((BrewPackager)this.packager).getCask().getResolvedCaskName(props).concat(RB)) : outputDirectory.resolve(fileName));
        } else if (((BrewPackager)this.packager).isMultiPlatform()) {
            if (CASK_RB.equals(fileName) || FORMULA_RB.equals(fileName)) {
                return;
            }
            this.writeFile(content, FORMULA_MULTI_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(distribution.getExecutable().getName().concat(RB)) : outputDirectory.resolve(fileName));
        } else {
            if (CASK_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            this.writeFile(content, FORMULA_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(StringUtils.getHyphenatedName((String)((BrewPackager)this.packager).getFormulaName()).concat(RB)) : outputDirectory.resolve(fileName));
        }
    }
}

