/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.api.hooks.Hook;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.hooks.AbstractHook;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class CommandHook
extends AbstractHook<CommandHook> {
    private static final long serialVersionUID = 2870547746386823584L;
    private final Set<String> platforms = new LinkedHashSet<String>();
    private String cmd;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.CommandHook immutable = new org.jreleaser.model.api.hooks.CommandHook(){
        private static final long serialVersionUID = 3053204535600637020L;

        public String getCmd() {
            return CommandHook.this.cmd;
        }

        public Set<String> getPlatforms() {
            return Collections.unmodifiableSet(CommandHook.this.getPlatforms());
        }

        public Hook.Filter getFilter() {
            return CommandHook.this.getFilter().asImmutable();
        }

        public boolean isContinueOnError() {
            return CommandHook.this.isContinueOnError();
        }

        public Active getActive() {
            return CommandHook.this.getActive();
        }

        public boolean isEnabled() {
            return CommandHook.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(CommandHook.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.hooks.CommandHook asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(CommandHook source) {
        super.merge(source);
        this.cmd = this.merge(this.cmd, source.cmd);
        this.setPlatforms(this.merge(this.platforms, source.platforms));
    }

    public String getResolvedCmd(JReleaserContext context, ExecutionEvent event) {
        TemplateContext props = context.fullProps();
        props.set("event", (Object)event);
        return Templates.resolveTemplate((String)this.cmd, (TemplateContext)props);
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public Set<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Set<String> platforms) {
        this.platforms.clear();
        this.platforms.addAll(platforms);
    }

    @Override
    public void asMap(boolean full, Map<String, Object> map) {
        map.put("cmd", this.cmd);
        map.put("platforms", this.platforms);
    }
}

