/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.util.StringUtils;

public class Links {
    private static final Pattern REL_PATTERN = Pattern.compile("rel=\"(.*)\"");
    private String first;
    private String next;
    private String prev;
    private String last;

    private Links(String input) {
        if (!StringUtils.isBlank((String)input)) {
            block12: for (String s : input.split(",")) {
                String[] parts = s.split(";");
                Matcher matcher = REL_PATTERN.matcher(parts[1].trim());
                if (!matcher.matches()) continue;
                switch (matcher.group(1).toLowerCase(Locale.ENGLISH)) {
                    case "first": {
                        this.first = this.normalize(parts[0]);
                        continue block12;
                    }
                    case "next": {
                        this.next = this.normalize(parts[0]);
                        continue block12;
                    }
                    case "prev": {
                        this.prev = this.normalize(parts[0]);
                        continue block12;
                    }
                    case "last": {
                        this.last = this.normalize(parts[0]);
                        continue block12;
                    }
                }
            }
        }
    }

    private String normalize(String url) {
        if ((url = url.trim()).startsWith("<") && url.endsWith(">")) {
            url = url.substring(1, url.length() - 1);
        }
        return url;
    }

    public boolean isEmpty() {
        return !this.hasFirst() && !this.hasLast() && !this.hasPrev() && !this.hasNext();
    }

    public boolean hasFirst() {
        return !StringUtils.isBlank((String)this.first);
    }

    public boolean hasNext() {
        return !StringUtils.isBlank((String)this.next);
    }

    public boolean hasPrev() {
        return !StringUtils.isBlank((String)this.prev);
    }

    public boolean hasLast() {
        return !StringUtils.isBlank((String)this.last);
    }

    public String first() {
        return this.first;
    }

    public String next() {
        return this.next;
    }

    public String prev() {
        return this.prev;
    }

    public String last() {
        return this.last;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Links[");
        sb.append("first='").append(this.first).append('\'');
        sb.append(", next='").append(this.next).append('\'');
        sb.append(", prev='").append(this.prev).append('\'');
        sb.append(", last='").append(this.last).append('\'');
        sb.append(']');
        return sb.toString();
    }

    public static Links of(String input) {
        return new Links(input);
    }

    public static Links of(Collection<String> input) {
        return new Links(null != input && !input.isEmpty() ? input.iterator().next() : "");
    }
}

