/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final NotFoundClasses notFoundClasses;
    @NotNull
    private final AnnotationDeserializer annotationDeserializer;

    public BinaryClassAnnotationAndConstantLoaderImpl(@NotNull ModuleDescriptor module2, @NotNull NotFoundClasses notFoundClasses, @NotNull StorageManager storageManager, @NotNull KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(notFoundClasses, "notFoundClasses");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(kotlinClassFinder, "kotlinClassFinder");
        super(storageManager, kotlinClassFinder);
        this.module = module2;
        this.notFoundClasses = notFoundClasses;
        this.annotationDeserializer = new AnnotationDeserializer(this.module, this.notFoundClasses);
    }

    @Override
    @NotNull
    protected AnnotationDescriptor loadTypeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        return this.annotationDeserializer.deserializeAnnotation(proto, nameResolver2);
    }

    @Override
    @Nullable
    protected ConstantValue<?> loadConstant(@NotNull String desc, @NotNull Object initializer2) {
        Object object;
        block18: {
            block16: {
                Intrinsics.checkNotNullParameter(desc, "desc");
                Intrinsics.checkNotNullParameter(initializer2, "initializer");
                if (!StringsKt.contains$default((CharSequence)"ZBCS", desc, false, 2, null)) break block16;
                int intValue = (Integer)initializer2;
                switch (desc) {
                    case "Z": {
                        object = intValue != 0;
                        break block18;
                    }
                    case "B": {
                        object = (byte)intValue;
                        break block18;
                    }
                    case "C": {
                        object = Character.valueOf((char)intValue);
                        break block18;
                    }
                    case "S": {
                        object = (short)intValue;
                        break block18;
                    }
                    default: {
                        throw new AssertionError((Object)desc);
                    }
                }
            }
            object = initializer2;
        }
        Object normalizedValue = object;
        return ConstantValueFactory.INSTANCE.createConstantValue(normalizedValue);
    }

    @Override
    @Nullable
    protected ConstantValue<?> transformToUnsignedConstant(@NotNull ConstantValue<?> constant) {
        Intrinsics.checkNotNullParameter(constant, "constant");
        ConstantValue constantValue = constant;
        return constantValue instanceof ByteValue ? (ConstantValue)new UByteValue(((Number)((ByteValue)constant).getValue()).byteValue()) : (constantValue instanceof ShortValue ? (ConstantValue)new UShortValue(((Number)((ShortValue)constant).getValue()).shortValue()) : (constantValue instanceof IntValue ? (ConstantValue)new UIntValue(((Number)((IntValue)constant).getValue()).intValue()) : (constantValue instanceof LongValue ? (ConstantValue)new ULongValue(((Number)((LongValue)constant).getValue()).longValue()) : constant)));
    }

    @Override
    @Nullable
    protected KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<AnnotationDescriptor> result2) {
        Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(result2, "result");
        ClassDescriptor annotationClass = this.resolveClass(annotationClassId);
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(annotationClass, this, result2, source){
            @NotNull
            private final HashMap<Name, ConstantValue<?>> arguments;
            final /* synthetic */ ClassDescriptor $annotationClass;
            final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
            final /* synthetic */ List<AnnotationDescriptor> $result;
            final /* synthetic */ SourceElement $source;
            {
                this.$annotationClass = $annotationClass;
                this.this$0 = $receiver;
                this.$result = $result;
                this.$source = $source;
                this.arguments = new HashMap<K, V>();
            }

            public void visit(@Nullable Name name2, @Nullable Object value2) {
                if (name2 != null) {
                    Map map2 = this.arguments;
                    ConstantValue<?> constantValue = this.createConstant(name2, value2);
                    boolean bl = false;
                    map2.put(name2, constantValue);
                }
            }

            public void visitClassLiteral(@NotNull Name name2, @NotNull ClassLiteralValue value2) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(value2, "value");
                Map map2 = this.arguments;
                KClassValue kClassValue = new KClassValue(value2);
                boolean bl = false;
                map2.put(name2, kClassValue);
            }

            public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(enumClassId, "enumClassId");
                Intrinsics.checkNotNullParameter(enumEntryName, "enumEntryName");
                Map map2 = this.arguments;
                EnumValue enumValue = new EnumValue(enumClassId, enumEntryName);
                boolean bl = false;
                map2.put(name2, enumValue);
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
                Intrinsics.checkNotNullParameter(name2, "name");
                return new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(this, name2, this.$annotationClass){
                    @NotNull
                    private final ArrayList<ConstantValue<?>> elements;
                    final /* synthetic */ loadAnnotation.1 this$0;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ ClassDescriptor $annotationClass;
                    {
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.$annotationClass = $annotationClass;
                        this.elements = new ArrayList<E>();
                    }

                    public void visit(@Nullable Object value2) {
                        this.elements.add(loadAnnotation.1.access$createConstant(this.this$0, this.$name, value2));
                    }

                    public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        Intrinsics.checkNotNullParameter(enumClassId, "enumClassId");
                        Intrinsics.checkNotNullParameter(enumEntryName, "enumEntryName");
                        this.elements.add(new EnumValue(enumClassId, enumEntryName));
                    }

                    public void visitClassLiteral(@NotNull ClassLiteralValue value2) {
                        Intrinsics.checkNotNullParameter(value2, "value");
                        this.elements.add(new KClassValue(value2));
                    }

                    public void visitEnd() {
                        ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(this.$name, this.$annotationClass);
                        if (parameter != null) {
                            Map map2 = loadAnnotation.1.access$getArguments$p(this.this$0);
                            Name name2 = this.$name;
                            List<ConstantValue<?>> list2 = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.compact(this.elements);
                            Object object = parameter.getType();
                            Intrinsics.checkNotNullExpressionValue(object, "parameter.type");
                            object = ConstantValueFactory.INSTANCE.createArrayValue(list2, (KotlinType)object);
                            boolean bl = false;
                            map2.put(name2, object);
                        }
                    }
                };
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(classId, "classId");
                ArrayList<AnnotationDescriptor> list2 = new ArrayList<AnnotationDescriptor>();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
                KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$0.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)list2);
                Intrinsics.checkNotNull(annotationArgumentVisitor);
                KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2 = annotationArgumentVisitor;
                return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(visitor2, this, name2, list2){
                    private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                    final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                    final /* synthetic */ loadAnnotation.1 this$0;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                    {
                        this.$visitor = $visitor;
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.$list = $list;
                        this.$$delegate_0 = this.$visitor;
                    }

                    public void visit(@Nullable Name name2, @Nullable Object value2) {
                        this.$$delegate_0.visit(name2, value2);
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
                        Intrinsics.checkNotNullParameter(name2, "name");
                        Intrinsics.checkNotNullParameter(classId, "classId");
                        return this.$$delegate_0.visitAnnotation(name2, classId);
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
                        Intrinsics.checkNotNullParameter(name2, "name");
                        return this.$$delegate_0.visitArray(name2);
                    }

                    public void visitClassLiteral(@NotNull Name name2, @NotNull ClassLiteralValue value2) {
                        Intrinsics.checkNotNullParameter(name2, "name");
                        Intrinsics.checkNotNullParameter(value2, "value");
                        this.$$delegate_0.visitClassLiteral(name2, value2);
                    }

                    public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        Intrinsics.checkNotNullParameter(name2, "name");
                        Intrinsics.checkNotNullParameter(enumClassId, "enumClassId");
                        Intrinsics.checkNotNullParameter(enumEntryName, "enumEntryName");
                        this.$$delegate_0.visitEnum(name2, enumClassId, enumEntryName);
                    }

                    public void visitEnd() {
                        this.$visitor.visitEnd();
                        Map map2 = loadAnnotation.1.access$getArguments$p(this.this$0);
                        Name name2 = this.$name;
                        AnnotationValue annotationValue = new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list));
                        boolean bl = false;
                        map2.put(name2, annotationValue);
                    }
                };
            }

            public void visitEnd() {
                this.$result.add(new AnnotationDescriptorImpl(this.$annotationClass.getDefaultType(), (Map)this.arguments, this.$source));
            }

            private final ConstantValue<?> createConstant(Name name2, Object value2) {
                ConstantValue constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value2);
                return constantValue == null ? (ConstantValue)ErrorValue.Companion.create(Intrinsics.stringPlus("Unsupported annotation argument: ", name2)) : constantValue;
            }

            public static final /* synthetic */ ConstantValue access$createConstant(loadAnnotation.1 $this, Name name2, Object value2) {
                return $this.createConstant(name2, value2);
            }

            public static final /* synthetic */ HashMap access$getArguments$p(loadAnnotation.1 $this) {
                return $this.arguments;
            }
        };
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }
}

